CREATE TABLE `t_sync_app_resource` (
	`APP_RESOURCE_ID` VARCHAR(32) NOT NULL COMMENT '主键',
	`APP_ID` VARCHAR(64) NOT NULL COMMENT '应用id',
	`APP_REGIONALISM_CODE` VARCHAR(32) NOT NULL COMMENT '应用行政区划代码',
	`APP_NETWORK_CODE` VARCHAR(1) NULL DEFAULT NULL COMMENT '1一类2二类3三类',
	`RESOURCE_ID` VARCHAR(64) NOT NULL COMMENT '资源id',
	`RESOURCE_REGIONALISM_CODE` VARCHAR(32) NOT NULL COMMENT '资源行政区划代码',
	`RESOURCE_NETWORK_CODE` VARCHAR(1) NULL DEFAULT NULL COMMENT '1一类2二类3三类',
	`STATUS` INT(1) NOT NULL COMMENT '1授权，2收回，3删除',
	`CREATE_TIME` BIGINT(20) NOT NULL COMMENT '创建时间戳',
	`LAST_UPDATE_TIME` BIGINT(20) NULL DEFAULT NULL COMMENT '最后更新时间戳',
	PRIMARY KEY (`APP_RESOURCE_ID`),
	UNIQUE INDEX `unique_app_resource` (`APP_ID`, `RESOURCE_ID`, `APP_REGIONALISM_CODE`, `RESOURCE_REGIONALISM_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='应用资源关系表'
