/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.controller;

import com.alibaba.fastjson.JSON;
import com.xdja.log.bean.Dict;
import com.xdja.log.bean.DictReqBean;
import com.xdja.log.bean.LogDetailRepBean;
import com.xdja.log.bean.LogDetailReqBean;
import com.xdja.log.bean.LogListReqBean;
import com.xdja.log.controller.LogBaseController;
import com.xdja.log.enums.LogStatus;
import com.xdja.log.service.BasicLogService;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.exception.RoamException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BasicLogController
extends LogBaseController {
    private static final Logger logger = LoggerFactory.getLogger(BasicLogController.class);
    @Autowired
    private BasicLogService basicLogService;

    @PostMapping(value={"/admin/v1/basicLog/queryLogList"})
    public void list(@RequestBody LogListReqBean reqBean) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)reqBean));
        }
        if (reqBean.getPageNo() < 1) {
            throw new RoamException(LogStatus.LOG_PAGE_NO_ERROR.getCode(), LogStatus.LOG_PAGE_NO_ERROR.getDesc());
        }
        if (reqBean.getPageSize() < 5) {
            throw new RoamException(LogStatus.LOG_PAGE_SIZE_ERROR.getCode(), LogStatus.LOG_PAGE_SIZE_ERROR.getDesc());
        }
        if (reqBean.getStartTime() == null || reqBean.getEndTime() == null) {
            throw new RoamException(LogStatus.LOG_TIME_INCOMPLETE.getCode(), LogStatus.LOG_TIME_INCOMPLETE.getDesc());
        }
        Page page = new Page(reqBean.getPageNo(), reqBean.getPageSize());
        this.basicLogService.selectList(reqBean, page);
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)page));
        }
        this.writeAndFlushSuccessResponse(page);
    }

    @PostMapping(value={"/admin/v1/basicLog/queryLogDetail"})
    public void detail(@RequestBody LogDetailReqBean reqBean) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)reqBean));
        }
        if (StringUtils.isEmpty((Object)reqBean.getId())) {
            throw new RoamException(LogStatus.LOG_ID_INCOMPLETE.getCode(), LogStatus.LOG_ID_INCOMPLETE.getDesc());
        }
        LogDetailRepBean result = this.basicLogService.getLogDetail(reqBean);
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)result));
        }
        this.writeAndFlushSuccessResponse(result);
    }

    @PostMapping(value={"/admin/v1/basicLog/getLogDict"})
    public void getDict(@RequestBody DictReqBean reqBean) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)reqBean));
        }
        if (StringUtils.isEmpty((Object)reqBean.getSystemCode())) {
            throw new RoamException(LogStatus.LOG_SYSTEM_CODE_INCOMPLETE.getCode(), LogStatus.LOG_SYSTEM_CODE_INCOMPLETE.getDesc());
        }
        List<Dict> result = this.basicLogService.getDicts(reqBean);
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString(result));
        }
        this.writeAndFlushSuccessResponse(result);
    }

    @PostMapping(value={"/admin/v1/basicLog/exportLog"})
    public void exportLog(@RequestBody LogListReqBean reqBean, HttpServletResponse response) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5165\u53c2\u4e3a\uff1a", (Object)JSON.toJSONString((Object)reqBean));
        }
        if (reqBean.getStartTime() == null || reqBean.getEndTime() == null) {
            throw new RoamException(LogStatus.LOG_TIME_INCOMPLETE.getCode(), LogStatus.LOG_TIME_INCOMPLETE.getDesc());
        }
        this.basicLogService.exportLog(reqBean, response);
    }
}

