/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.service.impl;

import com.xdja.log.bean.Dict;
import com.xdja.log.bean.DictReqBean;
import com.xdja.log.bean.LogDetailRepBean;
import com.xdja.log.bean.LogDetailReqBean;
import com.xdja.log.bean.LogExcelRepBean;
import com.xdja.log.bean.LogListRepBean;
import com.xdja.log.bean.LogListReqBean;
import com.xdja.log.enums.LogStatus;
import com.xdja.log.enums.RequestMehodEnum;
import com.xdja.log.service.BasicLogService;
import com.xdja.log.util.LogEnumUtil;
import com.xdja.log.util.excel.ExcelUtil;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.dao.BasicSyncCommonDao;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BasicLogServiceImpl
implements BasicLogService {
    private static final Logger logger = LoggerFactory.getLogger(BasicLogServiceImpl.class);
    @Autowired
    BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public List<LogListRepBean> selectList(LogListReqBean reqBean, Page page) {
        String selectSql = "SELECT id,user_code,user_name,ip,log_type,log_content,STATUS,create_time FROM  t_sys_log  where  create_time >= ? and create_time <= ?";
        StringBuilder query = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(reqBean.getStartTime());
        args.add(reqBean.getEndTime());
        if (!StringUtils.isEmpty((Object)reqBean.getLogType())) {
            query.append(" and log_type = ?");
            args.add(reqBean.getLogType());
        }
        if (!StringUtils.isEmpty((Object)reqBean.getSearchKey())) {
            query.append(" and (user_name like ? or user_code like ? or log_content like ? ) ");
            args.add("%" + reqBean.getSearchKey() + "%");
            args.add("%" + reqBean.getSearchKey() + "%");
            args.add("%" + reqBean.getSearchKey() + "%");
        }
        if (reqBean.getStatus() != null) {
            if (reqBean.getStatus() == 0) {
                query.append(" and status = 0 ");
            } else {
                query.append(" and status != 0 ");
            }
        }
        selectSql = selectSql + query + " order by create_time desc";
        List<LogListRepBean> result = this.basicSyncCommonDao.selectList(selectSql, args.toArray(), LogListRepBean.class, page);
        result = result.stream().map(e -> {
            e.setLogTypeName(LogEnumUtil.SYSTEM_LOGS.get(e.getLogType()));
            return e;
        }).collect(Collectors.toList());
        return result;
    }

    @Override
    public LogDetailRepBean getLogDetail(LogDetailReqBean reqBean) {
        String sql = "SELECT id,user_code,user_name,ip,log_type,log_content,request_header,request_body,request_method,request_url,response_header,response_body,cost_time,status,error_msg,create_time FROM t_sys_log  WHERE id = ?";
        LogDetailRepBean result = (LogDetailRepBean)this.basicSyncCommonDao.selectOne(sql, new Object[]{reqBean.getId()}, LogDetailRepBean.class);
        if (result == null) {
            return null;
        }
        result.setLogTypeName(LogEnumUtil.SYSTEM_LOGS.get(result.getLogType()));
        result.setRequestMethod(RequestMehodEnum.getApiCode(result.getRequestMethod()).getName());
        return result;
    }

    @Override
    public List<Dict> getDicts(DictReqBean reqBean) {
        List<Dict> dicts = LogEnumUtil.getLogDicts(reqBean.getSystemCode());
        return dicts.stream().sorted(Comparator.comparing(Dict::getCode)).collect(Collectors.toList());
    }

    @Override
    public void exportLog(LogListReqBean reqBean, HttpServletResponse response) {
        String selectSql = "SELECT id,user_code,user_name,ip,log_type,log_content,STATUS,create_time FROM  t_sys_log  where  create_time >= ? and create_time <= ?";
        StringBuilder query = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(reqBean.getStartTime());
        args.add(reqBean.getEndTime());
        if (!StringUtils.isEmpty((Object)reqBean.getLogType())) {
            query.append(" and log_type = ?");
            args.add(reqBean.getLogType());
        }
        if (!StringUtils.isEmpty((Object)reqBean.getSearchKey())) {
            query.append(" and (user_name like ? or user_code like ? or log_content like ? ) ");
            args.add("%" + reqBean.getSearchKey() + "%");
            args.add("%" + reqBean.getSearchKey() + "%");
            args.add("%" + reqBean.getSearchKey() + "%");
        }
        if (reqBean.getStatus() != null) {
            if (reqBean.getStatus() == 0) {
                query.append(" and status = 0 ");
            } else {
                query.append(" and status != 0 ");
            }
        }
        selectSql = selectSql + query + " order by create_time desc";
        List<?> logListRepBeans = this.basicSyncCommonDao.selectList(selectSql, args.toArray(), LogListRepBean.class);
        List result = logListRepBeans.stream().map(e -> {
            LogExcelRepBean logExcel = new LogExcelRepBean();
            BeanUtils.copyProperties((Object)e, (Object)logExcel);
            logExcel.setResult(e.getStatus() == 0 ? "\u6210\u529f" : "\u5931\u8d25");
            logExcel.setLogTypeName(LogEnumUtil.SYSTEM_LOGS.get(e.getLogType()));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logExcel.setCreateTime(simpleDateFormat.format(e.getCreateTime()));
            return logExcel;
        }).collect(Collectors.toList());
        try {
            Date now = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            ExcelUtil.downloadExcel(response, "\u7cfb\u7edf\u64cd\u4f5c\u65e5\u5fd7_" + simpleDateFormat.format(now), "sysLog", result, LogExcelRepBean.class);
        }
        catch (Exception e2) {
            logger.debug(LogStatus.LOG_EXPORT_EXCEL_FAIL.getDesc(), (Throwable)e2);
        }
    }
}

