create table T_SYS_LOG
(
    id              VARCHAR2(32) not null,
    client_type     NUMBER(1),
    log_type        NUMBER(4),
    operate_type    NUMBER(1),
    log_content     CLOB,
    user_id         VARCHAR2(32),
    user_code       VARCHAR2(32),
    user_name       VARCHAR2(255),
    ip              VARCHAR2(255),
    request_method  NUMBER(1),
    request_url     VARCHAR2(500),
    request_type    NUMBER(1),
    request_header  CLOB,
    request_body    CLOB,
    response_header CLOB,
    response_body   CLOB,
    cost_time       NUMBER(20),
    status          NUMBER(6),
    error_msg       CLOB,
    create_by       VARCHAR2(32),
    create_time     NUMBER(20),
    update_by       VARCHAR2(32),
    update_time     NUMBER(20)
);
comment on table T_SYS_LOG is '系统日志表';
comment on column T_SYS_LOG.client_type is '客户端类型,1：系统操作日志，2：Android客户端日志，3:服务日志';
comment on column T_SYS_LOG.log_type is '日志类型';
comment on column T_SYS_LOG.operate_type is '操作类型（1:增,2:删,3:改,4:查）';
comment on column T_SYS_LOG.log_content is '日志内容';
comment on column T_SYS_LOG.user_id is '操作用户id';
comment on column T_SYS_LOG.user_code is '操作用户账号';
comment on column T_SYS_LOG.user_name is '操作用户名称';
comment on column T_SYS_LOG.ip is 'IP';
comment on column T_SYS_LOG.request_method is '请求方法，(1:POST,2:DELETE,3:PUT,4:GET)';
comment on column T_SYS_LOG.request_url is '请求路径';
comment on column T_SYS_LOG.request_type is '请求类型,1:form,2:json';
comment on column T_SYS_LOG.request_header is '请求头';
comment on column T_SYS_LOG.request_body is '请求体';
comment on column T_SYS_LOG.response_header is '响应头';
comment on column T_SYS_LOG.response_body is '响应体';
comment on column T_SYS_LOG.cost_time is '耗时';
comment on column T_SYS_LOG.status is '状态，0:成功,非0:失败';
comment on column T_SYS_LOG.error_msg is '错误内容';
comment on column T_SYS_LOG.create_by is '创建人';
comment on column T_SYS_LOG.create_time is '创建时间';
comment on column T_SYS_LOG.update_by is '更新人';
comment on column T_SYS_LOG.update_time is '更新时间';

alter table T_SYS_LOG add primary key (ID);