/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.interceptor;

import com.alibaba.fastjson.JSON;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.service.BasicLogCacheService;
import com.xdja.log.threadlocal.LogCacheBeanThreadLocal;
import com.xdja.sync.bean.common.Consts;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class BasicAutoLogFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(BasicAutoLogFilter.class);
    private static final String LOG_SWITCH_KEY = "log.switch";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Environment environment = (Environment)Consts.applicationContext.getBean(Environment.class);
        String logSwitch = environment.getProperty(LOG_SWITCH_KEY, "off");
        boolean logFlag = "on".equalsIgnoreCase(logSwitch);
        if (!logFlag) {
            return;
        }
        LogCacheBean logCacheBean = LogCacheBeanThreadLocal.getLogCacheBean();
        if (null == logCacheBean) {
            LogCacheBeanThreadLocal.removeLogCacheBean();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u7f13\u5b58\u65e5\u5fd7LogCacheBean:\u3010{}\u3011", (Object)JSON.toJSONString((Object)logCacheBean));
        }
        if (logCacheBean.getCacheFlag().booleanValue()) {
            LogCacheBeanThreadLocal.removeLogCacheBean();
            return;
        }
        try {
            String resHeaderJson = JSON.toJSONString(this.getResponseHeaderParam((HttpServletResponse)response));
            logCacheBean.setResponseHeader(resHeaderJson);
            BasicLogCacheService basicLogCacheService = (BasicLogCacheService)Consts.applicationContext.getBean(BasicLogCacheService.class);
            basicLogCacheService.cacheLog(logCacheBean);
            logCacheBean.setCacheFlag(true);
        }
        catch (Exception e1) {
            logger.error("\u7f13\u5b58\u65e5\u5fd7\u4fe1\u606f\u5931\u8d25:", (Throwable)e1);
        }
        LogCacheBeanThreadLocal.removeLogCacheBean();
    }

    public void destroy() {
    }

    protected Map<String, String> getResponseHeaderParam(HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null != response) {
            Collection headerNames = response.getHeaderNames();
            for (String key : headerNames) {
                String value = response.getHeader(key);
                map.put(key, value);
            }
        }
        return map;
    }
}

