/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.smcs.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.smcs.bean.SmcsApp;
import com.xdja.smcs.bean.SmcsAppDelete;
import com.xdja.smcs.bean.SmcsDepartmentAudit;
import com.xdja.smcs.bean.SmcsDepartmentDelete;
import com.xdja.smcs.bean.SmcsIdentity;
import com.xdja.smcs.bean.SmcsPerson;
import com.xdja.smcs.bean.SmcsPersonApp;
import com.xdja.smcs.bean.SmcsPersonAudit;
import com.xdja.smcs.bean.SmcsPersonDelete;
import com.xdja.smcs.bean.SmcsPlatform;
import com.xdja.smcs.bean.SmcsPlatformAudit;
import com.xdja.smcs.bean.SmcsResource;
import com.xdja.smcs.bean.SmcsResourceApp;
import com.xdja.smcs.bean.SmcsResourceDelete;
import com.xdja.smcs.bean.SmcsResourceState;
import com.xdja.smcs.bean.SmsDepartment;
import com.xdja.smcs.service.BasicPullSmcsService;
import com.xdja.smcs.util.SmcsPlatformUtil;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.SyncPersonApp;
import com.xdja.sync.bean.SyncResource;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.enums.SmcsInterfaceEnum;
import com.xdja.sync.util.HttpUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BasicPullSmcsServiceImpl
implements BasicPullSmcsService {
    private static final Logger log = LoggerFactory.getLogger(BasicPullSmcsServiceImpl.class);
    private static CompletionService completionService = BasicPullSmcsServiceImpl.getExecutorService();

    @Override
    public void pullAddOrUpdateAppToSmcs(List<SyncApp> listApp) {
        try {
            ArrayList<SmcsApp> smcsApps = new ArrayList<SmcsApp>();
            for (SyncApp syncApp : listApp) {
                SmcsApp smcsApp = new SmcsApp();
                smcsApp.setAppId(syncApp.getAppId());
                smcsApp.setAppDescription(syncApp.getAppDescription());
                smcsApp.setAppPackage(syncApp.getAppPackage());
                smcsApp.setAppFileSize(syncApp.getAppFileSize().longValue());
                smcsApp.setBuildOrgId(syncApp.getAppRegionalismCode());
                smcsApp.setBuildOrgName(syncApp.getRegionalismName());
                smcsApp.setVersion(syncApp.getAppVersion());
                smcsApp.setState(StringUtils.isEmpty((Object)syncApp.getAppStatus()) ? 1 : Integer.valueOf(syncApp.getAppStatus()));
                smcsApp.setName(syncApp.getAppName());
                smcsApp.setAppNetworkType(this.gentNetworkCode(syncApp.getNetworkAreaCode()));
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                smcsApp.setCreateTime(dateFormat.format(new Date(syncApp.getCreateTime())));
                smcsApp.setUpdateTime(dateFormat.format(new Date(syncApp.getUpdateTime())));
                smcsApp.setPlatformId(SmcsPlatformUtil.getRegionalismCode());
                smcsApp.setAssetsType(StringUtils.isEmpty((Object)syncApp.getAppType()) ? 1 : Integer.valueOf(syncApp.getAppType()));
                smcsApps.add(smcsApp);
            }
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_01.getUrl(), (JSONArray)JSON.toJSON(smcsApps));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void pullAddDeptToSmcs(JSONArray listDept) {
        try {
            ArrayList<SmsDepartment> smsDepartments = new ArrayList<SmsDepartment>();
            ArrayList<SmcsDepartmentDelete> departmentDeletes = new ArrayList<SmcsDepartmentDelete>();
            for (int i = 0; i < listDept.size(); ++i) {
                JSONObject jsonObject = listDept.getJSONObject(i);
                String flag = jsonObject.getString("delete_flag");
                if (!StringUtils.isEmpty((Object)flag) && "1".equals(flag)) {
                    departmentDeletes.add(new SmcsDepartmentDelete(jsonObject.getString("id")));
                }
                SmsDepartment smsDepartment = new SmsDepartment();
                smsDepartment.setOrgId(jsonObject.getString("id"));
                smsDepartment.setOrgName(jsonObject.getString("name"));
                smsDepartment.setParentOrgId(jsonObject.getString("parent_id"));
                smsDepartment.setCode(jsonObject.getString("code"));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                smsDepartment.setUpdateTime(simpleDateFormat.format(jsonObject.getLong("n_last_update_time") == null ? new Date().getTime() : jsonObject.getLong("n_last_update_time").longValue()));
                smsDepartments.add(smsDepartment);
            }
            if (!departmentDeletes.isEmpty()) {
                this.executeCall(SmcsInterfaceEnum.IF_SMCS_04.getUrl(), (JSONArray)JSON.toJSON(departmentDeletes));
                return;
            }
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_03.getUrl(), (JSONArray)JSON.toJSON(smsDepartments));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void pullAddDeptAuditToSmcs(JSONArray listDept) {
        try {
            ArrayList<SmcsDepartmentAudit> departmentAudits = new ArrayList<SmcsDepartmentAudit>();
            for (int i = 0; i < listDept.size(); ++i) {
                JSONObject jsonObject = listDept.getJSONObject(i);
                String flag = jsonObject.getString("delete_flag");
                SmcsDepartmentAudit departmentAudit = new SmcsDepartmentAudit();
                departmentAudit.setOrgId(jsonObject.getString("id"));
                departmentAudit.setSourceSysName(SmcsPlatformUtil.getSystemCode());
                departmentAudit.setPlatformId(SmcsPlatformUtil.getRegionalismCode());
                departmentAudit.setOperateUserName("\u8d85\u7ea7\u7ba1\u7406\u5458");
                departmentAudit.setOperateType(1);
                if (!StringUtils.isEmpty((Object)flag) && "1".equals(flag)) {
                    departmentAudit.setOperateType(2);
                }
                departmentAudit.setOperateTime(new Date().getTime());
                departmentAudit.setOperateResult(1);
                departmentAudits.add(departmentAudit);
            }
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_05.getUrl(), (JSONArray)JSON.toJSON(departmentAudits));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void pullAddPersonToSmcs(JSONArray listPerson) {
        try {
            ArrayList<SmcsPerson> smcsPersons = new ArrayList<SmcsPerson>();
            ArrayList<SmcsPersonDelete> personDeletes = new ArrayList<SmcsPersonDelete>();
            for (int i = 0; i < listPerson.size(); ++i) {
                JSONObject jsonObject = listPerson.getJSONObject(i);
                SmcsPerson smcsPerson = new SmcsPerson();
                String flag = jsonObject.getString("delete_flag");
                if (!StringUtils.isEmpty((Object)flag) && "1".equals(flag)) {
                    personDeletes.add(new SmcsPersonDelete(jsonObject.getString("id")));
                }
                smcsPerson.setUserId(jsonObject.getString("id"));
                smcsPerson.setUserName(jsonObject.getString("name"));
                smcsPerson.setCardNo(jsonObject.getString("identifier"));
                smcsPerson.setOrgId(jsonObject.getString("dep_id"));
                smcsPerson.setOfficePhone(jsonObject.getString("officePhone"));
                smcsPerson.setEmail(jsonObject.getString("mail"));
                smcsPerson.setPosition(jsonObject.getString("position"));
                smcsPerson.setPlatformId(SmcsPlatformUtil.getRegionalismCode());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                smcsPerson.setUpdateTime(simpleDateFormat.format(jsonObject.getLong("n_last_update_time") == null ? new Date().getTime() : jsonObject.getLong("n_last_update_time").longValue()));
                smcsPersons.add(smcsPerson);
            }
            if (!personDeletes.isEmpty()) {
                this.executeCall(SmcsInterfaceEnum.IF_SMCS_07.getUrl(), (JSONArray)JSON.toJSON(personDeletes));
                return;
            }
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_06.getUrl(), (JSONArray)JSON.toJSON(smcsPersons));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void pullAddPersonAuditToSmcs(JSONArray listPerson) {
        try {
            ArrayList<SmcsPersonAudit> personAudits = new ArrayList<SmcsPersonAudit>();
            for (int i = 0; i < listPerson.size(); ++i) {
                JSONObject jsonObject = listPerson.getJSONObject(i);
                String flag = jsonObject.getString("delete_flag");
                SmcsPersonAudit personAudit = new SmcsPersonAudit();
                personAudit.setUserId(jsonObject.getString("id"));
                personAudit.setSourceSysName(SmcsPlatformUtil.getSystemCode());
                personAudit.setPlatformId(SmcsPlatformUtil.getRegionalismCode());
                personAudit.setOperateUserName("\u8d85\u7ea7\u7ba1\u7406\u5458");
                personAudit.setOperateType(1);
                if (!StringUtils.isEmpty((Object)flag) && "1".equals(flag)) {
                    personAudit.setOperateType(2);
                }
                personAudit.setOperateTime(new Date().getTime());
                personAudit.setOperateResult(1);
                personAudits.add(personAudit);
            }
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_08.getUrl(), (JSONArray)JSON.toJSON(personAudits));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void pullAddOrUpdateResourceToSmcs(List<SyncResource> listAddSyncResource) {
        try {
            ArrayList<SmcsResource> smcsResources = new ArrayList<SmcsResource>();
            for (SyncResource syncResource : listAddSyncResource) {
                SmcsResource smcsResource = new SmcsResource();
                smcsResource.setPlatformId(SmcsPlatformUtil.getRegionalismCode());
                smcsResource.setResourceId(syncResource.getResourceId());
                smcsResource.setResourceName(syncResource.getResourceName());
                smcsResource.setResourceType(syncResource.getResourceType());
                smcsResource.setResourceStatus(syncResource.getStatus());
                smcsResource.setCreateTime(syncResource.getRegisterTime());
                smcsResource.setCollection(new Date().getTime());
                smcsResource.setOrg(syncResource.getDepName());
                smcsResource.setReleaseScopeOrgCode(syncResource.getPublishScope());
                smcsResource.setUpdateTime(syncResource.getUpdateTime());
                smcsResources.add(smcsResource);
            }
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_09.getUrl(), (JSONArray)JSON.toJSON(smcsResources));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void pullResourceStatusToSmcs(List<SyncResource> resourceStates) {
        try {
            ArrayList<SmcsResourceState> smcsResourceStates = new ArrayList<SmcsResourceState>();
            for (SyncResource syncResource : resourceStates) {
                SmcsResourceState resourceState = new SmcsResourceState();
                resourceState.setResourceId(syncResource.getResourceId());
                resourceState.setResourceStatus(syncResource.getStatus());
                resourceState.setCreateTime(syncResource.getRegisterTime());
                resourceState.setUpdateTime(syncResource.getUpdateTime());
                resourceState.setCollection(new Date().getTime());
                smcsResourceStates.add(resourceState);
            }
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_11.getUrl(), (JSONArray)JSON.toJSON(smcsResourceStates));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void pullAddOrUpdateAppResourceToSmcs(List<SyncAppResource> listAddSyncAppResource) {
        try {
            ArrayList<SmcsResourceApp> resourceApps = new ArrayList<SmcsResourceApp>();
            for (SyncAppResource syncAppResource : listAddSyncAppResource) {
                SmcsResourceApp resourceApp = new SmcsResourceApp();
                resourceApp.setResourceId(syncAppResource.getResourceId());
                resourceApp.setAppId(syncAppResource.getAppId());
                resourceApp.setAuthStatus(syncAppResource.getStatus());
                resourceApp.setCreateTime(syncAppResource.getCreateTime());
                resourceApp.setUpdateTime(syncAppResource.getLastUpdateTime());
                resourceApp.setCollectionTime(new Date().getTime());
                resourceApps.add(resourceApp);
            }
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_10.getUrl(), (JSONArray)JSON.toJSON(resourceApps));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void pullAddOrUpdatePersonAppToSmcs(List<SyncPersonApp> listAddSyncPersonApp) {
        try {
            ArrayList<SmcsPersonApp> smcsPersonApps = new ArrayList<SmcsPersonApp>();
            for (SyncPersonApp personApp : listAddSyncPersonApp) {
                SmcsPersonApp smcsPersonApp = new SmcsPersonApp();
                smcsPersonApp.setPlatformId(SmcsPlatformUtil.getRegionalismCode());
                smcsPersonApp.setAppId(personApp.getAppId());
                smcsPersonApp.setUserId(personApp.getPersonId());
                smcsPersonApp.setStatus(personApp.getStatus());
                smcsPersonApp.setCreateTime(personApp.getCreateTime());
                smcsPersonApp.setUpdateTime(personApp.getLastUpdateTime());
                smcsPersonApp.setCollectionTime(new Date().getTime());
                smcsPersonApps.add(smcsPersonApp);
            }
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_14.getUrl(), (JSONArray)JSON.toJSON(smcsPersonApps));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void aspectLogToSmcs(String requestParams, String logContent, int logType, String userId, String userName, String responseBody) {
        try {
            JSONObject request = JSONObject.parseObject((String)requestParams);
            switch (logContent) {
                case "\u6ce8\u9500\u5e94\u7528": {
                    ArrayList<SmcsAppDelete> appDeletes = new ArrayList<SmcsAppDelete>();
                    SmcsAppDelete appDelete = new SmcsAppDelete();
                    appDelete.setAppId(request.getString("appId"));
                    appDeletes.add(appDelete);
                    this.executeCall(SmcsInterfaceEnum.IF_SMCS_02.getUrl(), (JSONArray)JSON.toJSON(appDeletes));
                    break;
                }
                case "\u8d44\u6e90\u5220\u9664": {
                    String resourceId = request.getString("resourceId");
                    ArrayList<SmcsResourceDelete> resourceDeletes = new ArrayList<SmcsResourceDelete>();
                    SmcsResourceDelete resourceDelete = new SmcsResourceDelete();
                    resourceDelete.setResourceId(resourceId);
                    resourceDeletes.add(resourceDelete);
                    this.executeCall(SmcsInterfaceEnum.IF_SMCS_16.getUrl(), (JSONArray)JSON.toJSON(resourceDeletes));
                    break;
                }
                case "\u4e0a/\u4e0b\u67b6\u5e94\u7528": 
                case "\u6ce8\u518c\u5e94\u7528": 
                case "\u53d1\u5e03\u5e94\u7528": 
                case "\u4fee\u6539\u5e94\u7528": {
                    this.setMamInfo(request, userId, userName, logContent);
                    break;
                }
                case "\u8d44\u6e90\u6ce8\u518c": 
                case "\u8d44\u6e90\u53d1\u5e03": 
                case "\u8d44\u6e90\u66f4\u65b0": 
                case "\u8d44\u6e90\u4e0b\u7ebf": 
                case "\u8d44\u6e90\u4e0a\u7ebf": {
                    this.setRsbInfo(request, userId, userName, logContent);
                    break;
                }
                case "\u8ba4\u8bc1\u65e5\u5fd7": {
                    if (logType != 1401 && logType != 1201) break;
                    JSONObject response = JSONObject.parseObject((String)responseBody);
                    this.setUaaInfo(request, response);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void platformInfoToSmcs() {
        try {
            ArrayList<SmcsPlatform> smcsPlatforms = new ArrayList<SmcsPlatform>();
            int type = this.getApplicationName();
            SmcsPlatform platform = new SmcsPlatform();
            platform.setPlatformId(SmcsPlatformUtil.getRegionalismCode());
            platform.setType(type);
            platform.setParentPlatformId(SmcsPlatformUtil.getRegionalismCode());
            smcsPlatforms.add(platform);
            this.executeCall(SmcsInterfaceEnum.IF_SMCS_12.getUrl(), (JSONArray)JSON.toJSON(smcsPlatforms));
        }
        catch (Exception e) {
            log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    public void pullAppResourceAuditToSmcs(List<SyncAppResource> listAddSyncAppResource) {
        ArrayList<SmcsPlatformAudit> smcsPlatformAudits = new ArrayList<SmcsPlatformAudit>();
        for (SyncAppResource appResource : listAddSyncAppResource) {
            SmcsPlatformAudit platformAudit = this.setBaseInfo("0", "\u8d85\u7ea7\u7ba1\u7406\u5458");
            platformAudit.setPermissionType(1);
            platformAudit.setPermissionResourceId(appResource.getResourceId());
            platformAudit.setPermissionAuthAction("\u6388\u6743\u8d44\u6e90");
            smcsPlatformAudits.add(platformAudit);
        }
        this.executeCall(SmcsInterfaceEnum.IF_SMCS_13.getUrl(), (JSONArray)JSON.toJSON(smcsPlatformAudits));
    }

    @Override
    public void pullPersonAppToAuditSmcs(List<SyncPersonApp> listAddSyncPersonApp) {
        ArrayList<SmcsPlatformAudit> smcsPlatformAudits = new ArrayList<SmcsPlatformAudit>();
        for (SyncPersonApp personApp : listAddSyncPersonApp) {
            SmcsPlatformAudit platformAudit = this.setBaseInfo("0", "\u8d85\u7ea7\u7ba1\u7406\u5458");
            platformAudit.setPermissionType(2);
            platformAudit.setAppId(personApp.getAppId());
            platformAudit.setPermissionAuthAction("\u6388\u6743\u5e94\u7528");
            smcsPlatformAudits.add(platformAudit);
        }
        this.executeCall(SmcsInterfaceEnum.IF_SMCS_13.getUrl(), (JSONArray)JSON.toJSON(smcsPlatformAudits));
    }

    private void executeCall(String interfaceUrl, JSONArray bodyParam) {
        completionService.submit(() -> {
            String code;
            String result = "";
            result = HttpUtils.createPost(SmcsPlatformUtil.getSmcsUrl() + interfaceUrl).addJsonBody(bodyParam).execute().getString();
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (null != jsonObject && !"1".equals(code = jsonObject.get((Object)"code").toString())) {
                String errorMsg = "\u8fd4\u56de\u4e1a\u52a1\u9519\u8bef\u72b6\u6001\u7801:" + code + ",\u9519\u8bef\u6d88\u606f\uff1a" + jsonObject.getString("message");
                log.error("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7\u5931\u8d25\uff1a", (Object)errorMsg);
                return 0;
            }
            return 1;
        });
    }

    private String gentNetworkCode(String netWorkAreaCode) {
        switch (netWorkAreaCode) {
            case "1": {
                return "SYS_I";
            }
            case "2": {
                return "SYS_II";
            }
        }
        return "SYS_III";
    }

    private int getApplicationName() {
        String applicationName;
        Environment environment = (Environment)Consts.applicationContext.getBean(Environment.class);
        switch (applicationName = environment.getProperty(Consts.APPLICATION_NAME, "uaa")) {
            case "mdp": {
                return 1;
            }
            case "rsb": {
                return 2;
            }
            case "uaa": {
                return 3;
            }
            case "uas": {
                return 4;
            }
        }
        return 99;
    }

    private void setMamInfo(JSONObject request, String userId, String userName, String logContent) {
        ArrayList<SmcsPlatformAudit> smcsPlatformAudits = new ArrayList<SmcsPlatformAudit>();
        SmcsPlatformAudit platformAudit = this.setBaseInfo(userId, userName);
        platformAudit.setAppId(StringUtils.isEmpty((Object)request.getString("appId")) ? "" : request.getString("appId"));
        platformAudit.setAppName(StringUtils.isEmpty((Object)request.getString("appName")) ? "" : request.getString("appName"));
        platformAudit.setAppAction(logContent);
        smcsPlatformAudits.add(platformAudit);
        this.executeCall(SmcsInterfaceEnum.IF_SMCS_13.getUrl(), (JSONArray)JSON.toJSON(smcsPlatformAudits));
    }

    private void setRsbInfo(JSONObject request, String userId, String userName, String logContent) {
        ArrayList smcsPlatformAudits = new ArrayList();
        SmcsPlatformAudit platformAudit = this.setBaseInfo(userId, userName);
        platformAudit.setServiceResourceId(request.getString("resourceId"));
        platformAudit.setServiceAction(logContent);
        this.executeCall(SmcsInterfaceEnum.IF_SMCS_13.getUrl(), (JSONArray)JSON.toJSON(smcsPlatformAudits));
    }

    private void setUpmInfo(JSONObject request, String userId, String userName, String logContent, Integer permissionType) {
        ArrayList<SmcsPlatformAudit> smcsPlatformAudits = new ArrayList<SmcsPlatformAudit>();
        SmcsPlatformAudit platformAudit = this.setBaseInfo(userId, userName);
        platformAudit.setPermissionType(permissionType);
        platformAudit.setPermissionAuthAction(logContent);
        if (1 == permissionType) {
            platformAudit.setAppId(request.getString("appId"));
        } else {
            platformAudit.setPermissionResourceId(request.getString("resourceId"));
        }
        smcsPlatformAudits.add(platformAudit);
        this.executeCall(SmcsInterfaceEnum.IF_SMCS_13.getUrl(), (JSONArray)JSON.toJSON(smcsPlatformAudits));
    }

    private void setUaaInfo(JSONObject request, JSONObject response) {
        ArrayList<SmcsIdentity> smcsIdentities = new ArrayList<SmcsIdentity>();
        SmcsIdentity identity = new SmcsIdentity();
        identity.setTicket(request.getString("mode"));
        identity.setRecordId(SmcsPlatformUtil.getRegionalismCode());
        identity.setTicketType(1);
        identity.setAuthTime(new Date().getTime());
        identity.setAuthResult("1");
        if (!"0".equals(response.getString("status"))) {
            identity.setAuthResult("0");
        }
        identity.setAppId(StringUtils.isEmpty((Object)request.getString("appId")) ? "1" : request.getString("appId"));
        identity.setCollectionTime(new Date().getTime());
        smcsIdentities.add(identity);
        this.executeCall(SmcsInterfaceEnum.IF_SMCS_17.getUrl(), (JSONArray)JSON.toJSON(smcsIdentities));
    }

    private SmcsPlatformAudit setBaseInfo(String userId, String userName) {
        SmcsPlatformAudit platformAudit = new SmcsPlatformAudit();
        platformAudit.setPlatformId(SmcsPlatformUtil.getRegionalismCode());
        platformAudit.setOperatorId(userId);
        platformAudit.setOperatorName(userName);
        platformAudit.setOperatorTime(new Date().getTime());
        platformAudit.setOperatorResult(1);
        return platformAudit;
    }

    private static CompletionService getExecutorService() {
        if (completionService == null) {
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 10, 2L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024));
            completionService = new ExecutorCompletionService(executorService);
        }
        return completionService;
    }
}

