/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.xdja.sync.enums.TableEnum;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractSyncHandler {
    private static AtomicInteger atomicInteger = new AtomicInteger(1);

    void doHandler(TableEnum[] tableEnums) {
        TableEnum[] tableEnums1 = this.supportType(tableEnums);
        if (null != tableEnums1 && tableEnums1.length > 0) {
            String poolName = this.getPoolName();
            int poolNum = this.getCorePoolSize();
            ScheduledExecutorService executorService = this.initScheduledExecutorService(poolName, poolNum);
            this.handler(tableEnums1, executorService);
        }
    }

    public ScheduledExecutorService initScheduledExecutorService(String poolName, int corePoolSize) {
        return new ScheduledThreadPoolExecutor(corePoolSize, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("sync-pool-" + poolName + "-" + atomicInteger.getAndIncrement());
            return thread;
        });
    }

    abstract void handler(TableEnum[] var1, ScheduledExecutorService var2);

    abstract TableEnum[] supportType(TableEnum[] var1);

    String getPoolName() {
        return "default";
    }

    int getCorePoolSize() {
        return 1;
    }
}

