/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.PamsSyncDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.util.HttpUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class PamsSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(PamsSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private PamsSyncDao pamsSyncDao;
    @Value(value="${sync.pams.interval:300}")
    private Long syncPamsInterval;
    private int pageSize = 200;
    private String dept_uri = TableEnum.TABLE_DEPARTMENT.getUri();
    private String person_uri = TableEnum.TABLE_PERSON.getUri();
    private volatile boolean syncDeptRunning = false;
    private volatile boolean syncPersonRunning = false;

    @Override
    String getPoolName() {
        return "pams";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    String uri = tableEnum.getUri();
                    String tableName = tableEnum.getTableName();
                    if (this.dept_uri.equals(uri)) {
                        try {
                            this.syncDept();
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    if (!this.person_uri.equals(uri)) continue;
                    try {
                        this.syncPerson();
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    }
                }
                this.pamsSyncDao.updatePersonTreeIdCode();
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65pams\u6570\u636e\u5f02\u5e38:", (Throwable)e);
            }
        }, 5L, this.syncPamsInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncDept() {
        PamsSyncHandler pamsSyncHandler = this;
        synchronized (pamsSyncHandler) {
            if (this.syncDeptRunning) {
                logger.error("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncDeptRunning = true;
        }
        try {
            int size;
            JSONArray listDept = this.pullAllDept();
            int n = size = this.pamsSyncDao.updateDept(listDept);
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u5f02\u5e38", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncDeptRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncPerson() {
        PamsSyncHandler pamsSyncHandler = this;
        synchronized (pamsSyncHandler) {
            if (this.syncPersonRunning) {
                logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncPersonRunning = true;
        }
        try {
            int updatePerson;
            JSONArray jsonArray = this.pullAllPerson();
            int n = updatePerson = this.pamsSyncDao.updatePerson(jsonArray);
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,\u5f02\u5e38", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncPersonRunning = false;
        }
    }

    private JSONArray pullAllPerson() {
        JSONArray listPerson;
        String url = Consts.pamsServerUrl + this.person_uri;
        Long lastUpdateTime = this.pamsSyncDao.getPersonLastUpdateTime();
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,url:\u3010{}\u3011, lastUpdateTime:\u3010{}\u3011", (Object)url, (Object)lastUpdateTime);
        }
        if (CollectionUtils.isEmpty((Collection)(listPerson = this.pullPamsData(lastUpdateTime, 1, 1, url)))) {
            logger.info("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,\u6ca1\u6709\u66f4\u65b0,lastUpdateTime:\u3010{}\u3011", (Object)lastUpdateTime);
            return new JSONArray();
        }
        int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;
        JSONArray listPersonResult = new JSONArray();
        int pageNum = 1;
        while (true) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,lastUpdateTime:\u3010{}\u3011,pageNo:\u3010{}\u3011>>>", (Object)lastUpdateTime, (Object)pageNum);
            }
            listPerson = this.pullPamsData(lastUpdateTime, pageNum, pageSize, url);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,lastUpdateTime:\u3010{}\u3011,pageNo:\u3010{}\u3011<<<", new Object[]{lastUpdateTime, pageNum, listPersonResult.toJSONString()});
            }
            if (!CollectionUtils.isEmpty((Collection)listPerson)) {
                listPersonResult.addAll((Collection)listPerson);
            }
            if (CollectionUtils.isEmpty((Collection)listPerson) || listPerson.size() < pageSize) break;
            ++pageNum;
        }
        logger.info("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,<<<");
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,total:\u3010{}\u3011", (Object)listPersonResult.size());
        }
        return listPersonResult;
    }

    private JSONArray pullAllDept() {
        JSONArray listDept;
        String url = Consts.pamsServerUrl + this.dept_uri;
        Long lastUpdateTime = this.pamsSyncDao.getDepartmentLastUpdateTime();
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,url:\u3010{}\u3011,lastUpdateTime:\u3010{}\u3011>>>", (Object)url, (Object)lastUpdateTime);
        }
        if (CollectionUtils.isEmpty((Collection)(listDept = this.pullPamsData(lastUpdateTime, 1, this.pageSize, url)))) {
            logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u672c\u6b21\u5355\u4f4d\u6ca1\u6709\u66f4\u65b0,lastUpdateTime:\u3010{}\u3011", (Object)lastUpdateTime);
            return new JSONArray();
        }
        int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;
        JSONArray listDeptResult = new JSONArray();
        int pageNum = 1;
        while (true) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u672c\u6b21\u5355\u4f4d\u6ca1\u6709\u66f4\u65b0,lastUpdateTime:\u3010{}\u3011,pageNo:\u3010{}\u3011>>>", (Object)lastUpdateTime, (Object)pageNum);
            }
            listDept = this.pullPamsData(lastUpdateTime, pageNum, pageSize, url);
            logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u672c\u6b21\u5355\u4f4d\u6ca1\u6709\u66f4\u65b0,lastUpdateTime:\u3010{}\u3011,pageNo:\u3010{}\u3011,rows:\u3010{}\u3011<<<", new Object[]{lastUpdateTime, pageNum, listDept.toJSONString()});
            if (!CollectionUtils.isEmpty((Collection)listDept)) {
                listDeptResult.addAll((Collection)listDept);
            }
            if (CollectionUtils.isEmpty((Collection)listDept) || listDept.size() < pageSize) break;
            ++pageNum;
        }
        logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,<<<");
        logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,total:\u3010{}\u3011", (Object)listDeptResult.size());
        return listDeptResult;
    }

    public JSONArray pullPamsData(Long dataMaxVersion, int pageNo, int pageSize, String url) {
        JSONArray listPamsData = new JSONArray();
        HashMap<String, String> requestParam = new HashMap<String, String>(4);
        requestParam.put("thirdId", Consts.systemName);
        requestParam.put("lastTime", dataMaxVersion == null ? "0" : String.valueOf(dataMaxVersion));
        requestParam.put("pageNo", pageNo + "");
        requestParam.put("pageSize", pageSize + "");
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606furl:[{}],param:\u3010{}\u3011>>>", (Object)url, (Object)JSON.toJSONString(requestParam));
            }
            if ((responseWrap = HttpUtils.createForm(url).addParameters(requestParam).execute()) == null) {
                logger.error("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            if (200 != responseWrap.statusCode()) {
                logger.error("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        try {
            JSONObject jsonObject;
            String flag;
            String json = responseWrap.getString();
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606furl:[{}],param:\u3010{}\u3011,result:\u3010{}\u3011<<<", new Object[]{url, JSON.toJSONString(requestParam), json});
            }
            if (!"0".equals(flag = (jsonObject = JSONObject.parseObject((String)json)).getJSONObject("result").getString("flag"))) {
                logger.error("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fe1\u606f\u5931\u8d25flag:{}", (Object)flag);
                return listPamsData;
            }
            listPamsData = jsonObject.getJSONArray("list");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        return null == listPamsData ? new JSONArray() : listPamsData;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        List<TableEnum> listTableEnum = Arrays.asList(tableEnums).stream().filter(tableEnum -> TableEnum.TABLE_PERSON == tableEnum || TableEnum.TABLE_DEPARTMENT == tableEnum).collect(Collectors.toList());
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

