/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.sync.bean.IndentifyAppCredentialResBean;
import com.xdja.sync.bean.IndentifyUserCredentialResBean;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.exception.RoamException;
import com.xdja.sync.service.BasicCredentialService;
import com.xdja.sync.service.BasicSyncServiceInterfaceService;
import com.xdja.sync.util.HttpUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BasicCredentialServiceImpl
implements BasicCredentialService {
    private static final Logger log = LoggerFactory.getLogger(BasicCredentialServiceImpl.class);
    @Autowired
    private BasicSyncServiceInterfaceService basicSyncServiceInterfaceService;

    @Override
    public IndentifyUserCredentialResBean indentifyUserCredential(String userCredential) {
        String regionalismCode = Consts.local_regionalismCode;
        String networkAreaCode = Consts.local_networkAreaCode;
        String interfaceCode = InterfaceCodeEnum.IF_UA_SVC_01.getCode();
        String interfaceUrl = this.basicSyncServiceInterfaceService.queryInterfaceUrl(regionalismCode, interfaceCode, networkAreaCode);
        if (StringUtils.isEmpty((Object)interfaceUrl)) {
            log.error("regionalismCode\uff1a\u3010{}\u3011, interfaceCode:\u3010{}\u3011, networkCode:\u3010{}\u3011\u5bf9\u5e94\u7684\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a", new Object[]{regionalismCode, interfaceCode, networkAreaCode});
            throw new RoamException(-1, "\u6821\u9a8c\u7528\u6237\u51ed\u8bc1\u5931\u8d25");
        }
        String resJson = this.executeCall(interfaceUrl, null, userCredential, null, new HashMap<String, Object>(){
            {
                this.put("backInfo", "0");
            }
        });
        if (StringUtils.isEmpty((Object)interfaceUrl)) {
            log.error("regionalismCode\uff1a\u3010{}\u3011, interfaceCode:\u3010{}\u3011, networkCode:\u3010{}\u3011\u5bf9\u5e94\u7684\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a", new Object[]{regionalismCode, interfaceCode, networkAreaCode});
            throw new RoamException(-1, "\u6821\u9a8c\u7528\u6237\u51ed\u8bc1\u5931\u8d25");
        }
        return (IndentifyUserCredentialResBean)JSON.parseObject((String)resJson, IndentifyUserCredentialResBean.class);
    }

    @Override
    public IndentifyAppCredentialResBean indentifyAppCredential(String appCredential) {
        String regionalismCode = Consts.local_regionalismCode;
        String networkAreaCode = Consts.local_networkAreaCode;
        String interfaceCode = InterfaceCodeEnum.IF_UA_SVC_02.getCode();
        String interfaceUrl = this.basicSyncServiceInterfaceService.queryInterfaceUrl(regionalismCode, interfaceCode, networkAreaCode);
        if (StringUtils.isEmpty((Object)interfaceUrl)) {
            log.error("regionalismCode\uff1a\u3010{}\u3011, interfaceCode:\u3010{}\u3011, networkCode:\u3010{}\u3011\u5bf9\u5e94\u7684\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a", new Object[]{regionalismCode, interfaceCode, networkAreaCode});
            throw new RoamException(-1, "\u6821\u9a8c\u5e94\u7528\u51ed\u8bc1\u5931\u8d25");
        }
        String resJson = this.executeCall(interfaceUrl, null, null, appCredential, null);
        if (StringUtils.isEmpty((Object)interfaceUrl)) {
            log.error("regionalismCode\uff1a\u3010{}\u3011, interfaceCode:\u3010{}\u3011, networkCode:\u3010{}\u3011\u5bf9\u5e94\u7684\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a", new Object[]{regionalismCode, interfaceCode, networkAreaCode});
            throw new RoamException(-1, "\u6821\u9a8c\u5e94\u7528\u51ed\u8bc1\u5931\u8d25");
        }
        return (IndentifyAppCredentialResBean)JSON.parseObject((String)resJson, IndentifyAppCredentialResBean.class);
    }

    public String executeCall(String interfaceUrl, String messageId, String userCredential, String appCredential, Object bodyParam) {
        HashMap<String, String> mapHeader = new HashMap<String, String>();
        mapHeader.put("messageId", StringUtils.isEmpty((Object)messageId) ? UUID.randomUUID().toString().replaceAll("-", "") : messageId);
        if (!StringUtils.isEmpty((Object)appCredential)) {
            mapHeader.put("appCredential", appCredential);
        }
        if (!StringUtils.isEmpty((Object)userCredential)) {
            mapHeader.put("userCredential", userCredential);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u63a5\u53e3>>>url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
        }
        HttpUtils.ResponseWrap responseWrap = HttpUtils.createPost(interfaceUrl).addHeader(mapHeader).addJsonBody(bodyParam).execute();
        String code = "";
        String message = "";
        if (responseWrap == null) {
            log.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a,url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam)});
            throw new RoamException(-1, "\u63a5\u53e3\u8c03\u7528\u5931\u8d25:\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        }
        if (200 != responseWrap.statusCode()) {
            log.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef{},", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), responseWrap.statusCode()});
            throw new RoamException(responseWrap.statusCode(), "\u8fd4\u56deHTTP\u72b6\u6001\u7801\u9519\u8bef," + responseWrap.statusCode());
        }
        code = responseWrap.getHeaderValue("code");
        message = responseWrap.getHeaderValue("message");
        try {
            message = URLDecoder.decode(message, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u54cd\u5e94\u7ed3\u679c\u5931\u8d25\uff1a", (Throwable)e);
        }
        if (!"0".equals(code)) {
            String errorMsg = "\u8fd4\u56de\u4e1a\u52a1\u9519\u8bef\u72b6\u6001\u7801:" + code + ",\u9519\u8bef\u6d88\u606f\uff1a" + responseWrap.getHeaderValue("message");
            log.error("\u8c03\u7528\u63a5\u53e3\u5931\u8d25url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,:\u8fd4\u56decode:\u3010{}\u3011,message:\u3010{}\u3011,", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, this.decode(message)});
            throw new RoamException(Integer.parseInt(code), this.decode(errorMsg));
        }
        String result = responseWrap.getString();
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u63a5\u53e3<<<url:\u3010{}\u3011,Header:\u3010{}\u3011,param:\u3010{}\u3011,resultCode:\u3010{}\u3011,resultMessage:\u3010{}\u3011,result:\u3010{}\u3011", new Object[]{interfaceUrl, JSON.toJSONString(mapHeader), Objects.isNull(bodyParam) ? "" : JSON.toJSONString((Object)bodyParam), code, this.decode(message), result});
        }
        return result;
    }

    private String decode(String message) {
        try {
            message = URLDecoder.decode(message, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u54cd\u5e94\u7ed3\u679c\u5931\u8d25\uff1a", (Throwable)e);
        }
        return message;
    }

    private String encode(String message) {
        try {
            message = URLEncoder.encode(message, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u54cd\u5e94\u7ed3\u679c\u5931\u8d25\uff1a", (Throwable)e);
        }
        return message;
    }
}

