/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.controller;

import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.handler.AppResourceSyncHandler;
import com.xdja.sync.handler.AppSyncHandler;
import com.xdja.sync.handler.CcmSyncHandler;
import com.xdja.sync.handler.PamsSyncHandler;
import com.xdja.sync.handler.ResourceSyncHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CommonSyncController {
    private static final Logger logger = LoggerFactory.getLogger(CommonSyncController.class);
    @Autowired
    private AppSyncHandler appSyncHandler;
    @Autowired
    private ResourceSyncHandler resourceSyncHandler;
    @Autowired
    private CcmSyncHandler ccmSyncHandler;
    @Autowired
    private PamsSyncHandler pamsSyncHandler;
    @Autowired
    private AppResourceSyncHandler appResourceSyncHandler;

    private void checkCcmServerUrl(String errorMsg) {
        if (null == Consts.ccmServerUrl || "".equals(Consts.ccmServerUrl)) {
            errorMsg = "ccm\u5730\u5740\u6ca1\u6709\u914d\u7f6e," + errorMsg;
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
    }

    private void checkPamsServerUrl(String errorMsg) {
        if (null == Consts.pamsServerUrl || "".equals(Consts.pamsServerUrl)) {
            errorMsg = "pams\u5730\u5740\u6ca1\u6709\u914d\u7f6e," + errorMsg;
            logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
    }

    @RequestMapping(value={"/common/sync/syncApp"})
    public void syncApp() {
        this.checkCcmServerUrl("\u65e0\u6cd5\u540c\u6b65\u5e94\u7528\u4fe1\u606f");
        this.appSyncHandler.syncApp();
    }

    @RequestMapping(value={"/common/sync/syncResource"})
    public void syncResource() {
        this.checkCcmServerUrl("\u65e0\u6cd5\u540c\u6b65\u8d44\u6e90\u4fe1\u606f");
        this.resourceSyncHandler.syncResource();
    }

    @RequestMapping(value={"/common/sync/syncRegionalism"})
    public void syncRegionalism() {
        this.checkCcmServerUrl("\u65e0\u6cd5\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801\u4fe1\u606f");
        this.ccmSyncHandler.syncRegionalism();
    }

    @RequestMapping(value={"/common/sync/syncBusinessType"})
    public void syncBusinessType() {
        this.checkCcmServerUrl("\u65e0\u6cd5\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f");
        this.ccmSyncHandler.syncBusinessType();
    }

    @RequestMapping(value={"/common/sync/syncServiceAndInterfaceInfo"})
    public void syncServiceAndInterfaceInfo() {
        this.checkCcmServerUrl("\u65e0\u6cd5\u540c\u6b65\u63a5\u53e3\u670d\u52a1\u4fe1\u606f");
        this.ccmSyncHandler.syncServiceAndInterfaceInfo();
    }

    @RequestMapping(value={"/common/sync/syncDept"})
    public void syncDept() {
        this.checkPamsServerUrl("\u65e0\u6cd5\u540c\u6b65\u5355\u4f4d\u4fe1\u606f");
        this.pamsSyncHandler.syncDept();
    }

    @RequestMapping(value={"/common/sync/syncPerson"})
    public void syncPerson() {
        this.checkPamsServerUrl("\u65e0\u6cd5\u540c\u6b65\u4eba\u5458\u4fe1\u606f");
        this.pamsSyncHandler.syncPerson();
    }

    @RequestMapping(value={"/common/sync/getSyncPerson"})
    public void getSyncPerson() {
        this.checkPamsServerUrl("\u65e0\u6cd5\u540c\u6b65\u4eba\u5458\u4fe1\u606f");
        this.pamsSyncHandler.syncPerson();
    }

    @RequestMapping(value={"/common/sync/getSyncAppResource"})
    public void getSyncAppResource() {
        this.checkCcmServerUrl("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f");
        this.appResourceSyncHandler.syncAppResource();
    }
}

