/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.smcs.factory.BasicPullSmcsFactory;
import com.xdja.smcs.util.SmcsPlatformUtil;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.AppResourceSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncAppService;
import com.xdja.sync.service.BasicSyncResourceService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.IdGeneratorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AppResourceSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(AppResourceSyncHandler.class);
    private static AtomicInteger atomicInteger = new AtomicInteger(1);
    private ScheduledExecutorService executorService = null;
    @Autowired
    private BasicSyncAppService basicSyncAppService;
    @Autowired
    private BasicSyncResourceService basicSyncResourceService;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private AppResourceSyncDao appResourceSyncDao;
    @Autowired
    private BasicPullSmcsFactory basicPullSmcsFactory;
    @Autowired
    private Environment environment;
    @Autowired
    private SmcsPlatformUtil smcsPlatformUtil;
    @Value(value="${sync.appResource.interval:300}")
    private Long syncAppInterval;
    private String syncAppResourceAppRegionalimCode_key = "sync.appResource.app.regionalismCode";
    private volatile boolean syncAppResourceRunning = false;
    private int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;

    @Override
    String getPoolName() {
        return "appResource";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_APP_RESOURCE.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncAppResource();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, 30L, this.syncAppInterval, TimeUnit.SECONDS);
    }

    @Transactional(rollbackFor={Exception.class})
    public int syncAppResource() {
        List<SyncApp> listSyncApp = this.basicSyncAppService.querySyncAppList();
        return this.syncAppResource(listSyncApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncAppResource(List<SyncApp> listSyncApp) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        AppResourceSyncHandler appResourceSyncHandler = this;
        synchronized (appResourceSyncHandler) {
            if (this.syncAppResourceRunning) {
                logger.error("\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncAppResourceRunning = true;
        }
        int syncAppTotal = 0;
        try {
            String syncAppResourceAppRegionalimCode;
            if (CollectionUtils.isEmpty(listSyncApp)) {
                logger.warn("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a,\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u5e94\u7528:\u3010{}\u3011", (Object)JSON.toJSONString(listSyncApp));
            }
            if (!StringUtils.isEmpty((Object)(syncAppResourceAppRegionalimCode = this.environment.getProperty(this.syncAppResourceAppRegionalimCode_key, "")))) {
                String[] ary = syncAppResourceAppRegionalimCode.split(",");
                List<String> listAppRegionalsimCode = Arrays.asList(ary);
                ArrayList<SyncApp> listSyncAppTmp = new ArrayList<SyncApp>();
                for (SyncApp syncApp : listSyncApp) {
                    String appRegionalismCode = syncApp.getAppRegionalismCode();
                    if (!listAppRegionalsimCode.contains(appRegionalismCode)) continue;
                    listSyncAppTmp.add(syncApp);
                }
                listSyncApp = listSyncAppTmp;
            }
            for (SyncApp syncApp : listSyncApp) {
                String appId = syncApp.getAppId();
                String appRegionalismCode = syncApp.getRegionalismCode();
                String appNetworkAreaCode = syncApp.getNetworkAreaCode();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011,appRegionalismCode:\u3010{}\u3011>>>", (Object)appId, (Object)appRegionalismCode);
                }
                try {
                    List<SyncAppResource> listPullSyncAppResource = this.pullResourceList(appId, appRegionalismCode, appNetworkAreaCode);
                    if (null == listPullSyncAppResource || listPullSyncAppResource.isEmpty()) {
                        logger.info("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5220\u9664\u5168\u90e8", (Object)appId, (Object)appRegionalismCode);
                        List<SyncAppResource> listDbSyncAppResource = this.appResourceSyncDao.queryAppResourceByAppId(appId, appRegionalismCode);
                        if (null != listDbSyncAppResource && listDbSyncAppResource.size() > 0) {
                            for (SyncAppResource syncAppResource : listDbSyncAppResource) {
                                syncAppResource.setStatus(SyncAppResource.status_delete_3);
                                syncAppResource.setLastUpdateTime(System.currentTimeMillis());
                                this.appResourceSyncDao.updateAppResourceStatus(syncAppResource);
                            }
                        }
                    } else {
                        List<SyncAppResource> listDeleteSyncAppResource;
                        List<SyncAppResource> list;
                        List<SyncAppResource> listAddSyncAppResource;
                        HashMap<String, SyncAppResource> mapPullSyncAppResource = new HashMap<String, SyncAppResource>();
                        for (SyncAppResource syncAppResource : listPullSyncAppResource) {
                            syncAppResource.setAppId(appId);
                            syncAppResource.setAppRegionalismCode(appRegionalismCode);
                            syncAppResource.setAppNetworkCode(appNetworkAreaCode);
                            String key = syncAppResource.getAppId() + syncAppResource.getAppRegionalismCode() + syncAppResource.getResourceId() + syncAppResource.getResourceRegionalismCode();
                            mapPullSyncAppResource.put(key, syncAppResource);
                        }
                        List<SyncAppResource> listDbSyncAppResource = this.appResourceSyncDao.queryAppResourceByAppId(appId, appRegionalismCode);
                        HashMap<String, SyncAppResource> mapDbSyncAppResource = new HashMap<String, SyncAppResource>();
                        if (null != listDbSyncAppResource && !listDbSyncAppResource.isEmpty()) {
                            for (SyncAppResource syncAppResource : listDbSyncAppResource) {
                                String key = syncAppResource.getAppId() + syncAppResource.getAppRegionalismCode() + syncAppResource.getResourceId() + syncAppResource.getResourceRegionalismCode();
                                mapDbSyncAppResource.put(key, syncAppResource);
                            }
                        }
                        if (null != (listAddSyncAppResource = this.computeAddSyncAppResource(mapPullSyncAppResource, mapDbSyncAppResource)) && listAddSyncAppResource.size() > 0) {
                            if (logger.isDebugEnabled()) {
                                logger.info("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u65b0\u589e:\u3010{}\u3011", new Object[]{appId, appRegionalismCode, JSON.toJSONString(listAddSyncAppResource)});
                            }
                            for (Object appResource : listAddSyncAppResource) {
                                long currentTimeMillis = System.currentTimeMillis();
                                ((SyncAppResource)appResource).setCreateTime(currentTimeMillis);
                                ((SyncAppResource)appResource).setLastUpdateTime(currentTimeMillis);
                                this.appResourceSyncDao.saveAppResource((SyncAppResource)appResource);
                            }
                            if ("on".equals(this.smcsPlatformUtil.getSmcsSwitch()) && "uas".equals(this.smcsPlatformUtil.getSystemCode())) {
                                this.basicPullSmcsFactory.getBasicPullSmcsService().pullAddAppResourceToSmcs(listAddSyncAppResource);
                                this.basicPullSmcsFactory.getBasicPullSmcsService().pullAppResourceAuditToSmcs(listAddSyncAppResource);
                            }
                        }
                        if (null != (list = this.computeUpdateSyncAppResource(mapPullSyncAppResource, mapDbSyncAppResource)) && !list.isEmpty()) {
                            Object appResource;
                            if (logger.isDebugEnabled()) {
                                logger.info("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u66f4\u65b0:\u3010{}\u3011", new Object[]{appId, appRegionalismCode, JSON.toJSONString(list)});
                            }
                            appResource = list.iterator();
                            while (appResource.hasNext()) {
                                SyncAppResource appResource2 = (SyncAppResource)appResource.next();
                                long currentTimeMillis = System.currentTimeMillis();
                                appResource2.setCreateTime(currentTimeMillis);
                                appResource2.setLastUpdateTime(currentTimeMillis);
                                this.appResourceSyncDao.updateAppResourceStatus(appResource2);
                            }
                            if ("on".equals(this.smcsPlatformUtil.getSmcsSwitch()) && "uas".equals(this.smcsPlatformUtil.getSystemCode())) {
                                this.basicPullSmcsFactory.getBasicPullSmcsService().pullAddAppResourceToSmcs(list);
                                this.basicPullSmcsFactory.getBasicPullSmcsService().pullAppResourceAuditToSmcs(list);
                            }
                        }
                        if (null != (listDeleteSyncAppResource = this.computeDeleteSyncAppResource(mapPullSyncAppResource, mapDbSyncAppResource)) && !listDeleteSyncAppResource.isEmpty()) {
                            if (logger.isDebugEnabled()) {
                                logger.info("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u5220\u9664:\u3010{}\u3011", new Object[]{appId, appRegionalismCode, JSON.toJSONString(listDeleteSyncAppResource)});
                            }
                            for (SyncAppResource appResource : listDeleteSyncAppResource) {
                                long currentTimeMillis = System.currentTimeMillis();
                                appResource.setCreateTime(currentTimeMillis);
                                appResource.setLastUpdateTime(currentTimeMillis);
                                this.appResourceSyncDao.updateAppResourceStatus(appResource);
                            }
                            if ("on".equals(this.smcsPlatformUtil.getSmcsSwitch()) && "uas".equals(this.smcsPlatformUtil.getSystemCode())) {
                                this.basicPullSmcsFactory.getBasicPullSmcsService().pullDeleteAppResourceToSmcs(listDeleteSyncAppResource);
                                this.basicPullSmcsFactory.getBasicPullSmcsService().pullAppResourceAuditToSmcs(listDeleteSyncAppResource);
                            }
                        }
                        logger.info("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761,\u5220\u9664:\u3010{}\u3011\u6761", new Object[]{appId, appRegionalismCode, listAddSyncAppResource.size(), listDeleteSyncAppResource.size()});
                    }
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5f02\u5e38:", new Object[]{appId, appRegionalismCode, e});
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<", (Object)appId, (Object)appRegionalismCode);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncAppResourceRunning = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb<<<");
        }
        return syncAppTotal;
    }

    private List<SyncAppResource> computeDeleteSyncAppResource(Map<String, SyncAppResource> mapPullSyncAppResource, Map<String, SyncAppResource> mapDbSyncAppResource) {
        ArrayList<SyncAppResource> listDeleteSyncAppResource = new ArrayList<SyncAppResource>();
        for (Map.Entry<String, SyncAppResource> entry : mapDbSyncAppResource.entrySet()) {
            String key = entry.getKey();
            if (mapPullSyncAppResource.containsKey(key)) continue;
            long currentTimeMillis = System.currentTimeMillis();
            SyncAppResource syncAppResource = entry.getValue();
            syncAppResource.setLastUpdateTime(currentTimeMillis);
            syncAppResource.setStatus(SyncAppResource.status_delete_3);
            listDeleteSyncAppResource.add(syncAppResource);
        }
        return listDeleteSyncAppResource;
    }

    private List<SyncAppResource> computeUpdateSyncAppResource(Map<String, SyncAppResource> mapPullSyncAppResource, Map<String, SyncAppResource> mapDbSyncAppResource) {
        ArrayList<SyncAppResource> listUpdateSyncAppResource = new ArrayList<SyncAppResource>();
        for (Map.Entry<String, SyncAppResource> entry : mapPullSyncAppResource.entrySet()) {
            String key = entry.getKey();
            if (!mapDbSyncAppResource.containsKey(key)) continue;
            long currentTimeMillis = System.currentTimeMillis();
            SyncAppResource syncAppResource = mapDbSyncAppResource.get(key);
            syncAppResource.setStatus(SyncAppResource.status_grant_1);
            syncAppResource.setCreateTime(currentTimeMillis);
            syncAppResource.setLastUpdateTime(currentTimeMillis);
            listUpdateSyncAppResource.add(syncAppResource);
        }
        return listUpdateSyncAppResource;
    }

    private List<SyncAppResource> computeAddSyncAppResource(Map<String, SyncAppResource> mapPullSyncAppResource, Map<String, SyncAppResource> mapDbSyncAppResource) {
        ArrayList<SyncAppResource> listAddSyncAppResource = new ArrayList<SyncAppResource>();
        for (Map.Entry<String, SyncAppResource> entry : mapPullSyncAppResource.entrySet()) {
            String key = entry.getKey();
            if (mapDbSyncAppResource.containsKey(key)) continue;
            long currentTimeMillis = System.currentTimeMillis();
            SyncAppResource syncAppResource = entry.getValue();
            syncAppResource.setAppResourceId(IdGeneratorUtil.nextIdStr());
            syncAppResource.setStatus(SyncAppResource.status_grant_1);
            syncAppResource.setCreateTime(currentTimeMillis);
            syncAppResource.setLastUpdateTime(currentTimeMillis);
            listAddSyncAppResource.add(syncAppResource);
        }
        return listAddSyncAppResource;
    }

    public List<SyncAppResource> pullResourceList(String appId, String appRegionalismCode, String appNetworkAreaCode) {
        HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
        mapReqParam.put("pageNo", 1);
        mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
        mapReqParam.put("appId", appId);
        mapReqParam.put("appRegionalismCode", appRegionalismCode);
        String localNetworkCode = Consts.local_networkAreaCode;
        long appResourceTotal = 0L;
        JSONArray resourceAllList = new JSONArray();
        int pageNo = 1;
        while (true) {
            mapReqParam.put("pageNo", pageNo);
            JSONArray resourceList = this.queryOffsiteAppResourceList(appRegionalismCode, localNetworkCode, mapReqParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{appId, appRegionalismCode, pageNo, null != resourceList ? resourceList.toJSONString() : null});
            }
            if (!CollectionUtils.isEmpty((Collection)resourceList)) {
                resourceAllList.addAll((Collection)resourceList);
                appResourceTotal += (long)resourceList.size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011, pageNo:\u3010{}\u3011, rows:\u3010{}\u3011, total:\u3010{}\u3011<<<", new Object[]{appId, appRegionalismCode, pageNo, resourceList.toJSONString(), appResourceTotal});
            }
            if (CollectionUtils.isEmpty((Collection)resourceList) || resourceList.size() < this.pageSize) {
                if (!logger.isDebugEnabled()) break;
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f", (Object)appId, (Object)appRegionalismCode);
                break;
            }
            ++pageNo;
        }
        return this.buildSyncAppResource(resourceAllList, appId, appRegionalismCode, appNetworkAreaCode);
    }

    private List<SyncAppResource> buildSyncAppResource(JSONArray resourceList, String appId, String appRegionalismCode, String appNetworkAreaCode) {
        ArrayList<SyncAppResource> listSyncAppResource = new ArrayList<SyncAppResource>();
        SyncAppResource syncAppResource = null;
        for (int i = 0; i < resourceList.size(); ++i) {
            JSONObject jsonObject = resourceList.getJSONObject(i);
            String resourceId = jsonObject.getString("resourceId");
            String resourceRegionalismCode = jsonObject.getString("resourceRegionalismCode");
            syncAppResource = new SyncAppResource();
            syncAppResource.setAppResourceId(IdGeneratorUtil.nextIdStr());
            syncAppResource.setAppId(appId);
            syncAppResource.setAppRegionalismCode(appRegionalismCode);
            syncAppResource.setAppNetworkCode(appNetworkAreaCode);
            syncAppResource.setResourceId(resourceId);
            syncAppResource.setResourceRegionalismCode(resourceRegionalismCode);
            listSyncAppResource.add(syncAppResource);
        }
        return listSyncAppResource;
    }

    private JSONArray queryOffsiteAppResourceList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_UPM_SVC_06.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011,appResource:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("resourceList");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
        }
        if (null == resultList) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        return resultList;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_APP_RESOURCE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

