create table t_sync_person_app
(
  PERSON_APP_ID             NUMBER(20) not null,
  APP_ID                    VARCHAR2(64),
  APP_REGIONALISM_CODE      VARCHAR2(32),
  APP_NETWORK_CODE          VARCHAR2(1),
  PERSON_ID                 VARCHAR2(64),
  PERSON_REGIONALISM_CODE   VARCHAR2(32),
  STATUS                    NUMBER(1),
  CREATE_TIME               NUMBER(19),
  LAST_UPDATE_TIME          NUMBER(19)
);
comment on table t_sync_person_app is '人员应用权限关系信息表';
comment on column t_sync_person_app.PERSON_APP_ID is '主键id';
comment on column t_sync_person_app.APP_ID is '应用id';
comment on column t_sync_person_app.APP_REGIONALISM_CODE is '应用行政区划代码';
comment on column t_sync_person_app.APP_NETWORK_CODE is '1一类2二类3三类';
comment on column t_sync_person_app.PERSON_ID is '人员id';
comment on column t_sync_person_app.PERSON_REGIONALISM_CODE is '人员行政区划代码';
comment on column t_sync_person_app.STATUS is '1授权，2收回，3删除';
comment on column t_sync_person_app.CREATE_TIME is '创建时间戳';
comment on column t_sync_person_app.LAST_UPDATE_TIME is '最后更新时间戳';
alter table t_sync_person_app add primary key (PERSON_APP_ID);
