/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.bean.common.RestfulQuery;
import com.xdja.sync.bean.common.RestfulResult;
import com.xdja.sync.dao.CcmSyncDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.util.HttpUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class CcmSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(CcmSyncHandler.class);
    @Autowired
    private CcmSyncDao ccmSyncDao;
    @Value(value="${sync.ccm.interval:300}")
    private Long syncCcmInterval;
    @Value(value="${sync.ccm.switch:on}")
    private String syncCcmSwitch;
    private volatile boolean syncRegionalismRunning = false;
    private volatile boolean syncBusinessTypeRunning = false;
    private volatile boolean syncServiceAndInterfaceInfoRunning = false;
    private String SYNC_REGIONALISM = TableEnum.TABLE_REGISIONALISM.getUri();
    private String SYNC_SERVICE_INTERFACE = TableEnum.TABLE_SERVICE.getUri();
    private String SYNC_SERVICE_TYPE = TableEnum.TABLE_BUSINESS_TYPE.getUri();

    @Override
    String getPoolName() {
        return "ccm";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                if ("off".equalsIgnoreCase(this.syncCcmSwitch)) {
                    logger.info("\u540c\u6b65ccm\u4fe1\u606f\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879sync.ccm.switch=on");
                    return;
                }
                for (TableEnum tableEnum : tableEnums) {
                    logger.info("\u540c\u6b65ccm\u4fe1\u606f\uff0c\u540c\u6b65\u9891\u7387sync.ccm.interval[{}]\u79d2", (Object)this.syncCcmInterval);
                    String tableName = tableEnum.getTableName();
                    String uri = tableEnum.getUri();
                    if (this.SYNC_REGIONALISM.equals(uri)) {
                        try {
                            this.syncRegionalism();
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    if (this.SYNC_SERVICE_TYPE.equals(uri)) {
                        try {
                            this.syncBusinessType();
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    if (!this.SYNC_SERVICE_INTERFACE.equals(uri)) continue;
                    try {
                        this.syncServiceAndInterfaceInfo();
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u63a5\u53e3\u670d\u52a1\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u7ea7\u8054\u914d\u7f6e\u4e2d\u5fc3\u6570\u636e\u5f02\u5e38:", (Throwable)e);
            }
        }, SyncHandlerThreadFactory.getSyncInitialDelay(), this.syncCcmInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncRegionalism() {
        CcmSyncHandler ccmSyncHandler = this;
        synchronized (ccmSyncHandler) {
            if (this.syncRegionalismRunning) {
                logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new RuntimeException("\u884c\u653f\u533a\u5212\u7f16\u7801\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncRegionalismRunning = true;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f>>>>>>");
            }
            JSONArray listRegionalismBean = this.pullRegionalism();
            this.ccmSyncDao.saveRegionalism(listRegionalismBean);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f<<<<<<");
            }
            int n = null == listRegionalismBean ? 0 : listRegionalismBean.size();
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f,\u5931\u8d25", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncRegionalismRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncServiceAndInterfaceInfo() {
        CcmSyncHandler ccmSyncHandler = this;
        synchronized (ccmSyncHandler) {
            if (this.syncServiceAndInterfaceInfoRunning) {
                logger.error("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new RuntimeException("\u670d\u52a1\u63a5\u53e3\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncServiceAndInterfaceInfoRunning = true;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f>>>>>>>>>>>>>>>>>>>>");
            }
            JSONArray listServiceInterface = this.queryServiceAndInterfaceInfo();
            this.ccmSyncDao.saveServiceAndInterfaceInfo(listServiceInterface);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f<<<<<<<<<<<<<<<<<<<");
            }
            int n = listServiceInterface.size();
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,\u5f02\u5e38", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncServiceAndInterfaceInfoRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncBusinessType() {
        CcmSyncHandler ccmSyncHandler = this;
        synchronized (ccmSyncHandler) {
            if (this.syncBusinessTypeRunning) {
                logger.error("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801\u4fe1\u606f,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new RuntimeException("\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncBusinessTypeRunning = true;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801\u4fe1\u606f>>>>>>");
            }
            JSONArray listBusinessType = this.pullBusinessType();
            this.ccmSyncDao.saveBusinessType(listBusinessType);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801\u4fe1\u606f<<<<<<");
            }
            int n = listBusinessType.size();
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4ee3\u7801\u4fe1\u606f,\u5931\u8d25");
        }
        finally {
            this.syncBusinessTypeRunning = false;
        }
        return 0;
    }

    private JSONArray pullServiceInterfaceInfo(int pageNum, int pageSize, Long lastUpdateTime, String url) {
        RestfulResult rmcResult;
        JSONArray listServiceInterface = new JSONArray();
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,pageNum:\u3010{}\u3011, pageSize:\u3010{}\u3011, lastUpdateTimestamp:\u3010{}\u3011, url:\u3010{}\u3011", new Object[]{pageNum, pageSize, lastUpdateTime, url});
        }
        try {
            RestfulQuery<JSONObject> restfulQuery = new RestfulQuery<JSONObject>();
            JSONObject parameter = new JSONObject();
            parameter.put("pageNo", (Object)pageNum);
            parameter.put("pageSize", (Object)pageSize);
            parameter.put("lastUpdateTimestamp", (Object)lastUpdateTime);
            restfulQuery.setParameter(parameter);
            rmcResult = this.executeCallCcm(url, restfulQuery);
            if (rmcResult == null || !String.valueOf(200).equals(rmcResult.getCode())) {
                logger.error("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,\u5f02\u5e38 {}", (Object)JSON.toJSONString((Object)rmcResult));
                return listServiceInterface;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,\u3010{}\u3011<<<", (Object)JSON.toJSONString((Object)rmcResult));
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listServiceInterface;
        }
        if (CollectionUtils.isEmpty((Map)((JSONObject)rmcResult.getData()))) {
            return listServiceInterface;
        }
        listServiceInterface = ((JSONObject)rmcResult.getData()).getJSONArray("list");
        return listServiceInterface;
    }

    private JSONArray pullRegionalism() {
        RestfulResult rmcResult;
        JSONArray listRegionalismBean = new JSONArray();
        String url = Consts.ccmServerUrl + this.SYNC_REGIONALISM;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f, url:{}", (Object)url);
        }
        try {
            RestfulQuery<JSONObject> restfulQuery = new RestfulQuery<JSONObject>();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("pageNo", (Object)1);
            jsonObject.put("pageSize", (Object)10000);
            restfulQuery.setParameter(jsonObject);
            rmcResult = this.executeCallCcm(url, restfulQuery);
            if (rmcResult == null || !String.valueOf(200).equals(rmcResult.getCode())) {
                logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f,\u5f02\u5e38 {}", (Object)rmcResult);
                return listRegionalismBean;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f,result:\u3010{}\u3011<<<", (Object)JSON.toJSONString((Object)rmcResult));
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f,\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listRegionalismBean;
        }
        JSONObject jsonResult = (JSONObject)rmcResult.getData();
        if (CollectionUtils.isEmpty((Map)jsonResult)) {
            return listRegionalismBean;
        }
        return jsonResult.getJSONArray("list");
    }

    private JSONArray pullBusinessType() {
        RestfulResult rmcResult;
        JSONArray listBusinessType = new JSONArray();
        Long lastUpdateTime = this.ccmSyncDao.queryBusinessTypeLastUpdateTime();
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        String url = Consts.ccmServerUrl + this.SYNC_SERVICE_TYPE;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f,lastUpdateTime:\u3010{}\u3011, url:\u3010{}\u3011", (Object)lastUpdateTime, (Object)url);
        }
        try {
            RestfulQuery query = new RestfulQuery();
            HashMap<String, Long> parameter = new HashMap<String, Long>();
            parameter.put("lastUpdateTimestamp", lastUpdateTime);
            parameter.put("pageNo", 1L);
            parameter.put("pageSize", 10000L);
            query.setParameter(parameter);
            rmcResult = this.executeCallCcm(url, query);
            if (rmcResult == null || !String.valueOf(200).equals(rmcResult.getCode())) {
                logger.error("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f,\u5f02\u5e38 {}", (Object)rmcResult);
                return listBusinessType;
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4e1a\u52a1\u7c7b\u578b\u4fe1\u606f,\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            return listBusinessType;
        }
        JSONObject businessTypeResult = (JSONObject)rmcResult.getData();
        if (CollectionUtils.isEmpty((Map)businessTypeResult)) {
            return listBusinessType;
        }
        listBusinessType = businessTypeResult.getJSONArray("list");
        return listBusinessType;
    }

    private JSONArray queryServiceAndInterfaceInfo() {
        String url;
        JSONArray interfaceDetailList;
        Long lastUpdateTime = this.ccmSyncDao.queryServiceInterfaceLastUpdateTime();
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,lastUpdateTime:\u3010{}\u3011", (Object)lastUpdateTime);
        }
        if (CollectionUtils.isEmpty((Collection)(interfaceDetailList = this.pullServiceInterfaceInfo(1, 1, lastUpdateTime, url = Consts.ccmServerUrl + this.SYNC_SERVICE_INTERFACE)))) {
            logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,\u6ca1\u6709\u66f4\u65b0");
            return new JSONArray();
        }
        int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;
        JSONArray listServiceInterface = new JSONArray();
        int pageNum = 1;
        while (true) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,url:\u3010{}\u3011,pageNo:\u3010{}\u3011>>>", (Object)url, (Object)pageNum);
            }
            interfaceDetailList = this.pullServiceInterfaceInfo(pageNum, pageSize, lastUpdateTime, url);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,url:\u3010{}\u3011,pageNo:\u3010{}\u3011,result:\u3010{}\u3011<<<", new Object[]{url, pageNum, interfaceDetailList.toJSONString()});
            }
            if (!CollectionUtils.isEmpty((Collection)interfaceDetailList)) {
                listServiceInterface.addAll((Collection)interfaceDetailList);
            }
            if (CollectionUtils.isEmpty((Collection)interfaceDetailList) || interfaceDetailList.size() < pageSize) break;
            ++pageNum;
        }
        logger.info("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f<<<");
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u670d\u52a1\u63a5\u53e3\u4fe1\u606f,\u5171\u3010{}\u3011\u6761,result:\u3010{}\u3011", (Object)listServiceInterface.size(), (Object)JSON.toJSONString((Object)listServiceInterface));
        }
        return listServiceInterface;
    }

    private RestfulResult executeCallCcm(String url, RestfulQuery restfulQuery) {
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u8c03\u7528ccm,url:[{}], RestfulQuery:\u3010{}\u3011>>>", (Object)url, (Object)JSON.toJSONString((Object)restfulQuery));
            }
            if ((responseWrap = HttpUtils.createPost(url).addJsonBody(restfulQuery).execute()) == null) {
                logger.error("\u8c03\u7528ccm,url:[{}]\u5f02\u5e38", (Object)url);
                throw SyncClientException.operateErrorException("\u8c03\u7528\u63a5\u53e3" + url + "\u5f02\u5e38");
            }
            if (200 != responseWrap.statusCode()) {
                logger.error("\u8c03\u7528ccm,url:[{}]\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801:{}", (Object)url, (Object)responseWrap.statusCode());
                throw SyncClientException.operateErrorException("\u8c03\u7528\u63a5\u53e3" + url + "\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801:" + responseWrap.statusCode());
            }
            String json = responseWrap.getString();
            if (StringUtils.isEmpty((Object)json)) {
                logger.error("\u8c03\u7528ccm,\u63a5\u53e3" + url + "\u5f02\u5e38,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
                throw SyncClientException.operateErrorException("\u8c03\u7528\u63a5\u53e3" + url + "\u5f02\u5e38,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            return (RestfulResult)JSON.parseObject((String)json, RestfulResult.class);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528ccm,url:[{}]\u5f02\u5e38:{}", (Object)url, (Object)e);
            throw SyncClientException.operateErrorException("\u8c03\u7528ccm\u63a5\u53e3" + url + "\u5f02\u5e38,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_BUSINESS_TYPE != tableEnum && TableEnum.TABLE_REGISIONALISM != tableEnum && TableEnum.TABLE_SERVICE != tableEnum && TableEnum.TABLE_SERVICE_INTERFACE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

