/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.smcs.factory.BasicPullSmcsFactory;
import com.xdja.smcs.util.SmcsPlatformUtil;
import com.xdja.sync.bean.Regionalism;
import com.xdja.sync.bean.SyncResource;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.ResourceSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.IdGeneratorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ResourceSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(ResourceSyncHandler.class);
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private ResourceSyncDao resourceSyncDao;
    @Autowired
    private BasicPullSmcsFactory basicPullSmcsFactory;
    @Autowired
    private Environment environment;
    @Autowired
    private SmcsPlatformUtil smcsPlatformUtil;
    @Value(value="${sync.resource.interval:300}")
    private Long syncResourceInterval;
    @Value(value="${sync.resource.switch:on}")
    private String syncResourceSwitch;
    private volatile boolean syncResourceRunning = false;
    private String syncResourceRegionalimCode_key = "sync.resource.regionalismCode";

    @Override
    String getPoolName() {
        return "resource";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        if ("off".equalsIgnoreCase(this.syncResourceSwitch)) {
            logger.info("\u540c\u6b65\u8d44\u6e90\u4fe1\u606f\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879sync.resource.switch=on");
            return;
        }
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_RESOURCE.getTableName().equals(tableEnum.getTableName())) continue;
                    logger.info("\u540c\u6b65\u8d44\u6e90\u4fe1\u606f\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879sync.resource.interval[{}]\u79d2", (Object)this.syncResourceInterval);
                    this.syncResource();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u8d44\u6e90\u5f02\u5e38:", (Throwable)e);
            }
        }, SyncHandlerThreadFactory.getSyncInitialDelay(), this.syncResourceInterval, TimeUnit.SECONDS);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public int syncResource() {
        List<String> listRegionalismCode = this.basicInfoSyncService.getRegionalismCodeList(Regionalism.STATUS_NORMAL);
        return this.syncResource(listRegionalismCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public int syncResource(List<String> listRegionalismCode) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8d44\u6e90>>>:\u3010{}\u3011", (Object)System.currentTimeMillis());
        }
        ResourceSyncHandler resourceSyncHandler = this;
        synchronized (resourceSyncHandler) {
            if (this.syncResourceRunning) {
                logger.error("\u8d44\u6e90\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u8d44\u6e90\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncResourceRunning = true;
        }
        int syncResourceTotal = 0;
        try {
            String syncResourceRegionalimCode;
            if (CollectionUtils.isEmpty(listRegionalismCode)) {
                logger.error("\u540c\u6b65\u8d44\u6e90\u5168\u56fd\u884c\u653f\u533a\u5212\u7f16\u7801\u4e3a\u7a7a(t_sync_regionalism),\u8d44\u6e90\u4fe1\u606f\u540c\u6b65\u7ed3\u675f");
                int n = syncResourceTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u8d44\u6e90\u5168\u56fd\u884c\u653f\u533a\u5212\u7f16\u7801:\u3010{}\u3011", Arrays.asList(listRegionalismCode));
            }
            if (!StringUtils.isEmpty((Object)(syncResourceRegionalimCode = this.environment.getProperty(this.syncResourceRegionalimCode_key, "")))) {
                String[] ary = syncResourceRegionalimCode.split(",");
                listRegionalismCode = Arrays.asList(ary);
            }
            for (String regionalismCode : listRegionalismCode) {
                JSONArray listPullSyncResource = this.pullResourceListByRegionalismCode(regionalismCode);
                if (null == listPullSyncResource || listPullSyncResource.size() <= 0) continue;
                ArrayList<SyncResource> listAddSyncResource = new ArrayList<SyncResource>();
                ArrayList<SyncResource> listUpdateSyncResource = new ArrayList<SyncResource>();
                ArrayList<SyncResource> resourceStates = new ArrayList<SyncResource>();
                for (int i = 0; i < listPullSyncResource.size(); ++i) {
                    JSONObject jsonObject = listPullSyncResource.getJSONObject(i);
                    SyncResource syncResource = this.buildSyncResource(jsonObject);
                    SyncResource syncResourceDb = this.resourceSyncDao.getResourceSyncByResourceId(syncResource.getResourceId(), syncResource.getRegionalismCode());
                    if (null == syncResourceDb) {
                        listAddSyncResource.add(syncResource);
                        continue;
                    }
                    listUpdateSyncResource.add(syncResource);
                    if (syncResource.getStatus() == syncResourceDb.getStatus()) continue;
                    resourceStates.add(syncResource);
                }
                if (null != listAddSyncResource && listAddSyncResource.size() > 0) {
                    this.resourceSyncDao.saveResource(listAddSyncResource);
                    if ("on".equals(this.smcsPlatformUtil.getSmcsSwitch()) && "rsb".equals(this.smcsPlatformUtil.getSystemCode())) {
                        this.basicPullSmcsFactory.getBasicPullSmcsService().pullAddResourceToSmcs(listAddSyncResource);
                    }
                }
                if (null != listUpdateSyncResource && listUpdateSyncResource.size() > 0) {
                    this.resourceSyncDao.updateResource(listUpdateSyncResource);
                    if ("on".equals(this.smcsPlatformUtil.getSmcsSwitch()) && "rsb".equals(this.smcsPlatformUtil.getSystemCode())) {
                        this.basicPullSmcsFactory.getBasicPullSmcsService().pullUpdateResourceToSmcs(listUpdateSyncResource);
                    }
                }
                if (!"on".equals(this.smcsPlatformUtil.getSmcsSwitch()) || !"rsb".equals(this.smcsPlatformUtil.getSystemCode()) || resourceStates.isEmpty()) continue;
                this.basicPullSmcsFactory.getBasicPullSmcsService().pullResourceStatusToSmcs(resourceStates);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncResourceRunning = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8d44\u6e90<<<:\u3010{}\u3011", (Object)System.currentTimeMillis());
        }
        return syncResourceTotal;
    }

    public SyncResource buildSyncResource(JSONObject jsonObject) {
        String resourceId = jsonObject.getString("resourceId");
        Integer networkAreaCode = jsonObject.getInteger("networkAreaCode");
        networkAreaCode = null == networkAreaCode ? 3 : networkAreaCode;
        String powerType = jsonObject.getString("powerType");
        powerType = StringUtils.isEmpty((Object)powerType) ? "10" : powerType;
        Integer resourceType = jsonObject.getInteger("resourceType");
        String resourceServiceType = jsonObject.getString("resourceServiceType");
        String resourceOperatorType = jsonObject.getString("resourceOperatorType");
        String resourceInterfaceType = jsonObject.getString("resourceInterfaceType");
        String resourceInterfaceAddress = jsonObject.getString("resourceInterfaceAddress");
        String regionalismCode = jsonObject.getString("regionalismCode");
        String resourceName = jsonObject.getString("resourceName");
        String depCode = jsonObject.getString("depCode");
        String ownerIdentifier = jsonObject.getString("ownerIdentifier");
        String approverIdentifier = jsonObject.getString("approverIdentifier");
        String resourceDescription = jsonObject.getString("resourceDescription");
        Long approveTime = jsonObject.getLongValue("approveTime");
        Long lastUpdateTime = jsonObject.getLongValue("lastUpdateTime");
        Long registerTime = jsonObject.getLongValue("registerTime");
        Integer status = jsonObject.getInteger("status");
        status = null == status ? 1 : status;
        JSONArray publishScopeAry = jsonObject.getJSONArray("publishScope");
        String publishScope = "";
        for (int i1 = 0; i1 < publishScopeAry.size(); ++i1) {
            publishScope = publishScope + publishScopeAry.getString(i1) + ",";
        }
        SyncResource syncResource = new SyncResource();
        syncResource.setId(IdGeneratorUtil.nextIdStr());
        syncResource.setResourceId(resourceId);
        syncResource.setNetworkAreaCode(networkAreaCode);
        syncResource.setResourceType(resourceType);
        syncResource.setResourceServiceType(resourceServiceType);
        syncResource.setResourceOperatorType(resourceOperatorType);
        syncResource.setResourceInterfaceType(resourceInterfaceType);
        syncResource.setResourceInterfaceAddress(resourceInterfaceAddress);
        syncResource.setPowerType(powerType);
        syncResource.setRegionalismCode(regionalismCode);
        syncResource.setResourceName(resourceName);
        syncResource.setResourceDescription(resourceDescription);
        syncResource.setStatus(status);
        syncResource.setPublishScope(publishScope);
        syncResource.setRegisterTime(registerTime);
        syncResource.setUpdateTime(lastUpdateTime);
        syncResource.setDepCode(depCode);
        syncResource.setOwnerIdentifier(ownerIdentifier);
        syncResource.setApproverIdentifier(approverIdentifier);
        syncResource.setApproveTime(approveTime);
        return syncResource;
    }

    private JSONArray pullResourceListByRegionalismCode(String regionalismCode) {
        JSONArray result = new JSONArray();
        try {
            String localRegionalismCode = Consts.local_regionalismCode;
            String localNetworkCode = Consts.local_networkAreaCode;
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u8d44\u6e90regionalismCode:\u3010{}\u3011>>>", (Object)regionalismCode);
            }
            int total = 0;
            Long lastUpdateTime = this.resourceSyncDao.getResourceLastUpdateTime(regionalismCode);
            lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u8d44\u6e90regionalismCode:\u3010{}\u3011,lastUpdateTime:\u3010{}\u3011", (Object)regionalismCode, (Object)lastUpdateTime);
            }
            HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
            mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
            mapReqParam.put("lastUpdateTime", lastUpdateTime);
            int pageNo = 1;
            JSONArray resourceList = null;
            do {
                mapReqParam.put("pageNo", pageNo);
                resourceList = this.queryOffsiteResourceList(regionalismCode, localNetworkCode, mapReqParam);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u8d44\u6e90regionalismCode:\u3010{}\u3011\u7b2c\u3010{}\u3011\u9875>>>", (Object)regionalismCode, (Object)pageNo);
                }
                if (null != resourceList && !resourceList.isEmpty()) {
                    total += resourceList.size();
                    result.addAll((Collection)resourceList);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u8d44\u6e90regionalismCode:\u3010{}\u3011,pageNo:\u3010{}\u3011,rows:\u3010{}\u3011\u6761,total:\u3010{}\u3011<<<", new Object[]{regionalismCode, pageNo, null != resourceList ? resourceList.size() : 0, total});
                }
                ++pageNo;
            } while (null != resourceList && !resourceList.isEmpty() && resourceList.size() >= Consts.SYNC_DEFAULT_PAGE_SIZE);
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u8d44\u6e90regionalismCode:\u3010{}\u3011,\u5f02\u5e38:", (Object)regionalismCode, (Object)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8d44\u6e90regionalismCode:\u3010{}\u3011<<<", (Object)regionalismCode);
        }
        return result;
    }

    private JSONArray queryOffsiteResourceList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_RSB_SVC_01.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u62c9\u53d6regionalismCode:\u3010{}]\u8d44\u6e90\u5217\u8868\u4fe1\u606f:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.error("\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u8d44\u6e90\u5217\u8868\u5f02\u5e38", (Object)regionalismCode);
            throw SyncClientException.operateErrorException("\u62c9\u53d6\u5f02\u5730\u8d44\u6e90\u5217\u8868\u5931\u8d25");
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("resourceList");
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u8d44\u6e90\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u8d44\u6e90\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38, \u539f\u6570\u636e\uff1a" + json);
        }
        for (int i = 0; i < resultList.size(); ++i) {
            JSONObject simpleResource = resultList.getJSONObject(i);
            String resourceId = simpleResource.getString("resourceId");
            try {
                JSONObject detail = this.httpQueryResourceDetail(resourceId, regionalismCode, localNetworkCode);
                if (Objects.isNull(detail)) {
                    logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801regionalismCode:\u3010{}\u3011,resourceId:\u3010{}\u3011\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a", (Object)regionalismCode, (Object)resourceId);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801regionalismCode:\u3010{}\u3011,resourceId:\u3010{}\u3011\u8fd4\u56de\u6570\u636e:\u3010{}\u3011", new Object[]{regionalismCode, resourceId, detail.toJSONString()});
                }
                simpleResource.putAll((Map)detail);
                continue;
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u7f16\u7801regionalismCode:\u3010{}\u3011,resourceId:\u3010{}\u3011\u8be6\u60c5\u5931\u8d25:", new Object[]{regionalismCode, resourceId, e});
            }
        }
        return resultList;
    }

    public JSONObject httpQueryResourceDetail(String resourceId, String regionalismCode, String localNetworkCode) {
        JSONObject result;
        HashMap<String, String> mapReqParam = new HashMap<String, String>();
        mapReqParam.put("resourceId", resourceId);
        mapReqParam.put("regionalismCode", regionalismCode);
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_RSB_SVC_02.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u62c9\u53d6regionalismCode:\u3010{}\u3011\u8d44\u6e90resourceId:\u3010{}\u3011\u8be6\u60c5\u4fe1\u606f:\u3010{}\u3011", new Object[]{regionalismCode, resourceId, json});
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.error("\u62c9\u53d6regionalismCode:\u3010{}\u3011\u8d44\u6e90resourceId:\u3010{}\u3011\u8be6\u60c5\u4fe1\u606f:\u3010{}\u3011", new Object[]{regionalismCode, resourceId, json});
            throw SyncClientException.operateErrorException("\u62c9\u53d6\u8d44\u6e90\u8be6\u60c5\u5931\u8d25");
        }
        try {
            result = JSON.parseObject((String)json);
        }
        catch (Exception e) {
            logger.error("\u63a5\u6536\u62c9\u53d6\u5f02\u5730\u3010{}\u3011\u8d44\u6e90resourceId\u3010{}\u3011\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38\uff0c\u539f\u6570\u636e\uff1a\u3010{}\u3011", new Object[]{regionalismCode, resourceId, json});
            throw SyncClientException.operateErrorException(String.format("\u63a5\u6536\u62c9\u53d6%s\u8d44\u6e90%s\u8be6\u60c5\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38\uff0c\u539f\u6570\u636e\uff1a%s", regionalismCode, resourceId, json));
        }
        return result;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_RESOURCE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

