/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.alibaba.fastjson.JSON;
import com.xdja.smcs.service.impl.XdjaBasicPullSmcsServiceImpl;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.bean.common.DbType;
import com.xdja.sync.bean.common.TableColumn;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.AppSyncHandler;
import com.xdja.sync.handler.CcmSyncHandler;
import com.xdja.sync.handler.PamsSyncHandler;
import com.xdja.sync.handler.ResourceSyncHandler;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ExecuteScheduleSyncHandler
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteScheduleSyncHandler.class);
    @Autowired
    private CcmSyncHandler ccmSyncHandler;
    @Autowired
    private PamsSyncHandler pamsSyncHandler;
    @Autowired
    private AppSyncHandler appSyncHandler;
    @Autowired
    private ResourceSyncHandler resourceSyncHandler;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private XdjaBasicPullSmcsServiceImpl xdjaBasicPullSmcsService;
    @Autowired
    private Map<String, AbstractSyncHandler> syncHandlers;

    public void run(TableEnum ... tableEnums) {
        tableEnums = null == tableEnums ? TableEnum.values() : tableEnums;
        this.checkRequiredTableSchema(tableEnums);
        TableEnum[] finalTableEnums = tableEnums;
        for (AbstractSyncHandler syncHandler : this.syncHandlers.values()) {
            syncHandler.doHandler(finalTableEnums);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void checkRequiredTableSchema(TableEnum[] tableEnums) {
        try (Connection connection = this.basicSyncCommonDao.getJdbcTemplate().getDataSource().getConnection();){
            Map<String, String> mapDbAllTableName = this.getDbAllTableName(connection);
            HashMap<String, String> mapFileTableSql = new HashMap<String, String>();
            HashMap<String, List<TableColumn>> mapTableColumn = new HashMap<String, List<TableColumn>>();
            String tableName = "";
            String sql = "";
            for (TableEnum tableEnum : tableEnums) {
                tableName = tableEnum.getTableName().toLowerCase();
                if (mapDbAllTableName.containsKey(tableName)) {
                    List<TableColumn> listTableColumn = this.getTableTableColumn(connection, tableName);
                    mapTableColumn.put(tableName, listTableColumn);
                    continue;
                }
                sql = this.getInitTableFileSql(tableName);
                mapFileTableSql.put(tableName, sql);
                sql = (String)mapFileTableSql.get(tableName);
                if (Consts.dbType == DbType.ORACLE || Consts.dbType == DbType.ORACLE_12C) {
                    String[] ary;
                    for (String s : ary = sql.split(";")) {
                        if (null == s || "".equals(s.trim())) continue;
                        try {
                            logger.error("\u6267\u884csql:\u3010{}\u3011", (Object)s);
                            this.basicSyncCommonDao.updateBySql(s, null);
                        }
                        catch (Exception e) {
                            logger.error("\u6267\u884csql:[{}]\u5931\u8d25:", (Object)s, (Object)e);
                        }
                    }
                    continue;
                }
                this.basicSyncCommonDao.updateBySql(sql, null);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u6570\u636e\u5e93\u4e2d\u540c\u6b65\u4fe1\u606f\u8868\u7ed3\u6784:\u3010{}\u3011", (Object)JSON.toJSONString(mapTableColumn));
            }
        }
        catch (Exception e) {
            logger.error("\u6821\u9a8c\u8868\u7ed3\u6784\u5931\u8d25", (Throwable)e);
        }
    }

    private void reInitTable(String tableName, String createTableSql) {
        String drop = "DROP TABLE " + tableName;
        this.basicSyncCommonDao.updateBySql(drop, null);
        this.basicSyncCommonDao.updateBySql(createTableSql, null);
    }

    private Map<String, String> getDbAllTableName(Connection connection) throws SQLException {
        HashMap<String, String> mapDbAllTableName;
        block3: {
            block2: {
                mapDbAllTableName = new HashMap<String, String>();
                if (Consts.dbType != DbType.ORACLE && Consts.dbType != DbType.ORACLE_12C) break block2;
                String sql = "select table_name from tabs";
                List<?> list = this.basicSyncCommonDao.selectList(sql, null, Map.class);
                if (null == list) break block3;
                for (Map map : list) {
                    String table_name = (String)map.get("TABLE_NAME");
                    mapDbAllTableName.put(table_name.toLowerCase(), table_name.toLowerCase());
                }
                break block3;
            }
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet rs = metaData.getTables(connection.getCatalog(), null, null, null);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME").toLowerCase();
                mapDbAllTableName.put(tableName, tableName);
            }
        }
        return mapDbAllTableName;
    }

    private String getInitTableFileSql(String tableName) throws IOException {
        String path = tableName + "." + Consts.dbType.getDb().toLowerCase() + ".sql";
        InputStream inputStream = ExecuteScheduleSyncHandler.class.getClassLoader().getResourceAsStream(path);
        String sql = IOUtils.toString((InputStream)inputStream, (String)"utf-8");
        return sql;
    }

    public List<TableColumn> parseSql(String sql) throws IOException {
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        MySqlStatementParser sqlStatementParser = null;
        if (Consts.dbType == DbType.MYSQL) {
            sqlStatementParser = new MySqlStatementParser(sql);
        } else if (Consts.dbType == DbType.ORACLE || Consts.dbType == DbType.ORACLE_12C) {
            sqlStatementParser = new OracleStatementParser(sql);
        }
        SQLCreateTableStatement sqlCreateTableStatement = sqlStatementParser.parseCreateTable();
        List sqlObjects = sqlCreateTableStatement.getChildren();
        TableColumn tableColumn = null;
        for (SQLObject sqlObject : sqlObjects) {
            SQLIntegerExpr sqlIntegerExpr;
            if (!(sqlObject instanceof SQLColumnDefinition)) continue;
            tableColumn = new TableColumn();
            SQLColumnDefinition columnDefinition = (SQLColumnDefinition)sqlObject;
            String columnName = columnDefinition.getNameAsString();
            SQLExpr columnDefinitionComment = columnDefinition.getComment();
            SQLExpr defaultExpr = columnDefinition.getDefaultExpr();
            String columnType = columnDefinition.getDataType().getName();
            List arguments = columnDefinition.getDataType().getArguments();
            if (null != arguments && arguments.size() > 0 && null != (sqlIntegerExpr = (SQLIntegerExpr)arguments.get(0))) {
                Number number = sqlIntegerExpr.getNumber();
                tableColumn.setColumnLength(null != number ? number.intValue() : 0);
            }
            String comment = null;
            try {
                if (null != columnDefinitionComment) {
                    comment = columnDefinitionComment.toString();
                }
            }
            catch (Exception e) {
                logger.warn("\u89e3\u6790sql\u8bed\u53e5\u5b57\u6bb5:[{}],\u7c7b\u578b:[{}]\u5907\u6ce8\u5931\u8d25", new Object[]{columnName.toUpperCase(), columnType.toUpperCase(), e});
            }
            if (null != defaultExpr) {
                tableColumn.setDefaultValue(defaultExpr.toString());
            }
            tableColumn.setColumnName(columnName.toUpperCase());
            tableColumn.setColumnType(columnType.toUpperCase());
            tableColumn.setComment(comment);
            list.add(tableColumn);
        }
        return list;
    }

    public List<TableColumn> getTableTableColumn(Connection connection, String tableName) throws SQLException, IOException {
        DatabaseMetaData metaData = connection.getMetaData();
        if (Consts.dbType == DbType.MYSQL) {
            return this.getMysqlTableTableColumn(connection, tableName);
        }
        if (Consts.dbType == DbType.ORACLE || Consts.dbType == DbType.ORACLE_12C) {
            return this.getOracleTableTableColumn(connection, tableName);
        }
        logger.error("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
        return null;
    }

    private List<TableColumn> getMysqlTableTableColumn(Connection connection, String tableName) throws SQLException, IOException {
        ArrayList<TableColumn> listTableColumn = new ArrayList<TableColumn>();
        try (Statement statement = connection.createStatement();){
            ResultSet rs = statement.executeQuery("show create table " + tableName);
            if (null != rs && rs.next()) {
                String sql = rs.getString(2);
                List<TableColumn> list = this.parseSql(sql);
                return list;
            }
        }
        return listTableColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TableColumn> getOracleTableTableColumn(Connection connection, String tableName) throws SQLException, IOException {
        ArrayList<TableColumn> listTableColumn = new ArrayList<TableColumn>();
        ResultSet rs = null;
        try (Statement statement = connection.createStatement();){
            String sql = "SELECT a.owner AS ower,      a.TABLE_NAME as tableName,      a.column_name as columnName,      a.data_type as dataType,      a.data_length as dataLength,      b.comments as comments FROM all_tab_columns a,   all_col_comments b  WHERE a.table_name = b.table_name AND a.column_name  = b.column_name AND a.table_name   = '" + tableName.toUpperCase() + "' AND a.owner        = b.owner AND a.owner        = '" + connection.getMetaData().getUserName() + "'";
            rs = statement.executeQuery(sql);
            TableColumn tableColumn = null;
            while (rs.next()) {
                tableColumn = new TableColumn();
                String columnName = rs.getString("columnName");
                String columnType = rs.getString("dataType");
                int dataSize = rs.getInt("dataLength");
                String remarks = rs.getString("comments");
                tableColumn.setColumnName(columnName.toUpperCase());
                tableColumn.setColumnType(columnType.toUpperCase());
                tableColumn.setColumnLength(dataSize);
                tableColumn.setComment(remarks);
                listTableColumn.add(tableColumn);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u5e93\u8868[{}]\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25:", (Object)tableName, (Object)e);
        }
        finally {
            if (null != rs) {
                rs.close();
            }
        }
        return listTableColumn;
    }

    public void afterPropertiesSet() throws Exception {
        this.checkRequiredTableSchema(TableEnum.values());
        this.xdjaBasicPullSmcsService.platformInfoToSmcs();
    }
}

