/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.Regionalism;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.CcmSyncDao;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.util.RegionalismUtils;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CcmSyncDaoImpl
implements CcmSyncDao {
    private static final Logger logger = LoggerFactory.getLogger(CcmSyncDaoImpl.class);
    private static String insertRegialismSql = "INSERT INTO t_sync_regionalism (code, name, parent_code, short_name, status, create_time, update_time) VALUES  (?, ?, ?, ?, ?, ?, ?)";
    private static String updateRegialismSql = "UPDATE t_sync_regionalism SET  name = ?, parent_code = ?, short_name = ?, status = ?, create_time = ?, update_time = ?  WHERE  code = ?";
    private static String insertServiceInterfaceSql = "INSERT INTO t_sync_service_interface (interface_id, interface_code, interface_name, interface_url, network_area_code, regionalism_code, version, version_note, status, create_time, update_time, service_id, service_name, public_key, service_type) VALUES  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String updateServiceInterfaceSql = "UPDATE t_sync_service_interface SET interface_code = ?, interface_name = ?, interface_url = ?, network_area_code = ?, regionalism_code = ?, version = ?, version_note = ?, status = ?, create_time = ?, update_time = ?, service_id = ?, service_name = ?, public_key = ?, service_type = ? WHERE interface_id = ?";
    private static String insertBussinessTypeSql = "INSERT INTO t_sync_business_type (code, name, status, create_time, update_time) VALUES  (?, ?, ?, ?, ?)";
    private static String updateBussinessTypeSql = "UPDATE t_sync_business_type SET name = ?, status = ?, create_time = ?, update_time = ? WHERE  code = ?";
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public void saveRegionalism(JSONArray listRegionalismBean) {
        if (null != listRegionalismBean && !listRegionalismBean.isEmpty()) {
            try {
                Object[] args = null;
                for (int i = 0; i < listRegionalismBean.size(); ++i) {
                    JSONObject jsonObject = listRegionalismBean.getJSONObject(i);
                    String code = jsonObject.getString("regionCode");
                    String name = jsonObject.getString("name");
                    String parentCode = jsonObject.getString("parentRegionCode");
                    String shortName = "";
                    shortName = parentCode == null ? RegionalismUtils.getShortNameByRegionalismCode(code) : RegionalismUtils.getShortNameByRegionalismCode(parentCode);
                    Integer status = jsonObject.getInteger("status");
                    Long createTime = jsonObject.getLong("createTime");
                    Long updateTime = jsonObject.getLong("updateTime");
                    String sql = "select * from t_sync_regionalism where code = ?";
                    Regionalism regionalism = (Regionalism)this.basicSyncCommonDao.selectOne(sql, new Object[]{code}, Regionalism.class);
                    if (Objects.isNull(regionalism)) {
                        sql = insertRegialismSql;
                        args = new Object[]{code, name, parentCode, shortName, status, createTime, updateTime};
                    } else {
                        Long updateTime1 = regionalism.getUpdateTime();
                        if (Objects.isNull(updateTime) || Objects.isNull(updateTime1) || updateTime <= updateTime1) continue;
                        sql = updateRegialismSql;
                        args = new Object[]{name, parentCode, shortName, status, createTime, updateTime, code};
                    }
                    try {
                        this.basicSyncCommonDao.updateBySql(sql, args);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f,\u4fdd\u5b58\u5931\u8d25:", (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable) {
                logger.error("\u540c\u6b65\u884c\u653f\u533a\u5212\u4fe1\u606f,\u5f02\u5e38", throwable);
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u4fdd\u5b58\u884c\u653f\u533a\u5212\u5217\u8868\u5f02\u5e38" + throwable.getMessage());
            }
        }
    }

    @Override
    public Long queryServiceInterfaceLastUpdateTime() {
        String sql = "SELECT max(update_time) FROM t_sync_service_interface";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        return lastUpdateTime;
    }

    @Override
    public void saveServiceAndInterfaceInfo(JSONArray listServiceInterface) {
        if (CollectionUtils.isEmpty((Collection)listServiceInterface)) {
            logger.info("\u672c\u6b21\u4ece\u7ea7\u8054\u914d\u7f6e\u4e2d\u5fc3\u4e0a\u540c\u6b65\u5230\u7684\u7ea7\u8054\u63a5\u53e3\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u672c\u6b21\u4ece\u7ea7\u8054\u914d\u7f6e\u4e2d\u5fc3\u4e0a\u540c\u6b65\u5230\u7684\u7ea7\u8054\u63a5\u53e3\u6570\u636e\u4e3a:\u3010{}\u3011", (Object)listServiceInterface.toJSONString());
        }
        int size = listServiceInterface.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = listServiceInterface.getJSONObject(i);
            if (logger.isDebugEnabled()) {
                logger.debug("\u66f4\u65b0\u672c\u5730\u7ea7\u8054\u63a5\u53e3\u4fe1\u606f:[{}/{}],\u6570\u636e\u4e3a:\u3010{}\u3011>>>", new Object[]{i + 1, size, jsonObject.toJSONString()});
            }
            int status = jsonObject.getInteger("status");
            String interfaceId = jsonObject.getString("interfaceId");
            String serviceId = jsonObject.getString("serviceId");
            String regionalismCode = jsonObject.getString("regionCode");
            String serviceName = jsonObject.getString("serviceName");
            String serviceType = jsonObject.getString("serviceType");
            String positionCode = jsonObject.getString("positionCode");
            String interfaceCode = jsonObject.getString("interfaceCode");
            String interfaceName = jsonObject.getString("interfaceName");
            int version = jsonObject.getIntValue("version");
            String versionNote = jsonObject.getString("versionNote");
            String url = jsonObject.getString("url");
            long createTime = jsonObject.getLongValue("createTime");
            long updateTime = jsonObject.getLongValue("updateTime");
            try {
                String sql = "SELECT COUNT(1) FROM t_sync_service_interface WHERE interface_id = ?";
                Long count = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{interfaceId}, Long.class);
                Object[] args = null;
                if (!Objects.isNull(count) && count > 0L) {
                    sql = updateServiceInterfaceSql;
                    args = new Object[]{interfaceCode, interfaceName, url, positionCode, regionalismCode, version, versionNote, status, createTime, updateTime, serviceId, serviceName, "", "", interfaceId};
                } else {
                    sql = insertServiceInterfaceSql;
                    args = new Object[]{interfaceId, interfaceCode, interfaceName, url, positionCode, regionalismCode, version, versionNote, status, createTime, updateTime, serviceId, serviceName, "", ""};
                }
                this.basicSyncCommonDao.updateBySql(sql, args);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u66f4\u65b0\u672c\u5730\u7ea7\u8054\u63a5\u53e3\u4fe1\u606f:[{}/{}],\u6570\u636e\u7ed3\u675f<<<", (Object)(i + 1), (Object)size);
                continue;
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u7ea7\u8054\u63a5\u53e3\u51fa\u9519\uff1a\u3010{}\u3011", (Object)jsonObject.toJSONString(), (Object)e);
            }
        }
    }

    @Override
    public Long queryBusinessTypeLastUpdateTime() {
        String sql = "select max(update_time) from t_sync_business_type";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        return lastUpdateTime;
    }

    @Override
    public void saveBusinessType(JSONArray listBusinessType) {
        try {
            for (int i = 0; i < listBusinessType.size(); ++i) {
                JSONObject jsonObject = listBusinessType.getJSONObject(i);
                String code = jsonObject.getString("code");
                String name = jsonObject.getString("name");
                int status = jsonObject.getIntValue("status");
                long createTime = jsonObject.getLongValue("createTime");
                long updateTime = jsonObject.getLongValue("updateTime");
                String sql = "SELECT count(1) FROM t_sync_business_type WHERE code = ?";
                Long count = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{code}, Long.class);
                Object[] args = null;
                if (!Objects.isNull(count) && count > 0L) {
                    sql = updateBussinessTypeSql;
                    args = new Object[]{name, status, createTime, updateTime, code};
                } else {
                    sql = insertBussinessTypeSql;
                    args = new Object[]{code, name, status, createTime, updateTime};
                }
                this.basicSyncCommonDao.updateBySql(sql, args);
            }
        }
        catch (Throwable throwable) {
            logger.error("\u4fdd\u5b58\u4e1a\u52a1\u7c7b\u578b" + throwable.getMessage(), throwable);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), throwable.getMessage());
        }
    }
}

