/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.xdja.sync.bean.SyncPersonDevice;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.PersonDeviceSyncDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonDeviceSyncDaoImpl
implements PersonDeviceSyncDao {
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public void deletePersonDeviceByPersonId(String personId) {
        String sql = "DELETE FROM t_sync_person_device WHERE person_id = ?";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{personId});
    }

    @Override
    public boolean existPersonDevice(String personId, String deviceId) {
        String sql = "SELECT count(1) FROM t_sync_person_device WHERE person_id = ? AND device_id = ? ";
        Integer count = (Integer)this.basicSyncCommonDao.selectOne(sql, new Object[]{personId, deviceId}, Integer.class);
        return null != count && count != 0;
    }

    @Override
    public List<SyncPersonDevice> getPersonDeviceByPersonId(String personId) {
        String sql = "SELECT * FROM t_sync_person_device WHERE person_id = ?";
        return this.basicSyncCommonDao.selectList(sql, new Object[]{personId}, SyncPersonDevice.class);
    }

    @Override
    public void saveSyncPersonDevice(SyncPersonDevice syncPersonDevice) {
        this.saveSyncPersonDevice(Arrays.asList(syncPersonDevice));
    }

    @Override
    public void saveSyncPersonDevice(List<SyncPersonDevice> listSyncPersonDevice) {
        String sql = "INSERT INTO t_sync_person_device(person_device_id, person_id, device_id, create_time)  values (?, ?, ?, ?) ";
        ArrayList<Object[]> listArgs = new ArrayList<Object[]>();
        Object[] args = null;
        for (SyncPersonDevice syncPersonDevice : listSyncPersonDevice) {
            args = new Object[]{syncPersonDevice.getPersonDeviceId(), syncPersonDevice.getPersonId(), syncPersonDevice.getDeviceId(), syncPersonDevice.getCreateTime()};
            listArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, listArgs);
    }

    @Override
    public void deleteSyncPersonDevice(List<SyncPersonDevice> listDeleteDevice) {
        String sql = "DELETE FROM t_sync_person_device WHERE person_device_id = ?";
        for (SyncPersonDevice syncPersonDevice : listDeleteDevice) {
            this.basicSyncCommonDao.updateBySql(sql, new Object[]{syncPersonDevice.getPersonDeviceId()});
        }
    }
}

