/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.SyncResource;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.ResourceSyncDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ResourceSyncDaoImpl
implements ResourceSyncDao {
    private static String insertResourceSql = "INSERT INTO t_sync_resource ( id, resource_id, network_area_Code, resource_type, resource_service_type, resource_operator_type, resource_interface_type, resource_interface_address, power_type, regionalism_code, resource_name, resource_description, status, publish_scope, register_time, update_Time, dep_code, owner_Identifier, approver_Identifier, approve_Time, last_Update_Time) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String updateResourceSql = "UPDATE t_sync_resource SET resource_type=?, resource_service_type=?, resource_operator_type=?, resource_interface_type=?, resource_interface_address=?, power_type=?, resource_name=?, resource_description=?, status=?, publish_scope=?, register_time=?, update_Time=?, dep_code=?, owner_Identifier=?,  approver_Identifier=?, approve_Time=?, last_Update_Time=? where resource_id = ? and regionalism_code = ? and network_area_Code=?";
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public void saveResource(JSONArray resourceList, String regionalismCode) {
        for (int i = 0; i < resourceList.size(); ++i) {
            JSONObject jsonObject = resourceList.getJSONObject(i);
            String resourceId = jsonObject.getString("resourceId");
            String networkAreaCode = jsonObject.getString("networkAreaCode");
            String powerType = jsonObject.getString("powerType");
            powerType = StringUtils.isEmpty((Object)powerType) ? "10" : powerType;
            String resourceType = jsonObject.getString("resourceType");
            String resourceServiceType = jsonObject.getString("resourceServiceType");
            String resourceOperatorType = jsonObject.getString("resourceOperatorType");
            String resourceInterfaceType = jsonObject.getString("resourceInterfaceType");
            String resourceInterfaceAddress = jsonObject.getString("resourceInterfaceAddress");
            String regionalismCode2 = jsonObject.getString("regionalismCode");
            String resourceName = jsonObject.getString("resourceName");
            String depCode = jsonObject.getString("depCode");
            String ownerIdentifier = jsonObject.getString("ownerIdentifier");
            String approverIdentifier = jsonObject.getString("approverIdentifier");
            String resourceDescription = jsonObject.getString("resourceDescription");
            Long approveTime = jsonObject.getLongValue("approveTime");
            Long lastUpdateTime = jsonObject.getLongValue("lastUpdateTime");
            Long registerTime = jsonObject.getLongValue("registerTime");
            String status = jsonObject.getString("status");
            JSONArray publishScopeAry = jsonObject.getJSONArray("publishScope");
            String publishScope = "";
            for (int i1 = 0; i1 < publishScopeAry.size(); ++i1) {
                publishScope = publishScope + publishScopeAry.getString(i1) + ",";
            }
            String sql = "SELECT count(1) FROM t_sync_resource  where resource_id = ?  and regionalism_Code = ? ";
            Long count = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{resourceId, regionalismCode}, Long.class);
            Object[] args = null;
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            if (!Objects.isNull(count) && count > 0L) {
                sql = updateResourceSql;
                args = new Object[]{resourceType, resourceServiceType, resourceOperatorType, resourceInterfaceType, resourceInterfaceAddress, powerType, resourceName, resourceDescription, status, publishScope, registerTime, lastUpdateTime, depCode, ownerIdentifier, approverIdentifier, approveTime, lastUpdateTime, resourceId, regionalismCode2, networkAreaCode};
            } else {
                sql = insertResourceSql;
                args = new Object[]{id, resourceId, networkAreaCode, resourceType, resourceServiceType, resourceOperatorType, resourceInterfaceType, resourceInterfaceAddress, powerType, regionalismCode2, resourceName, resourceDescription, status, publishScope, registerTime, lastUpdateTime, depCode, ownerIdentifier, approverIdentifier, approveTime, lastUpdateTime};
            }
            this.basicSyncCommonDao.updateBySql(sql, args);
        }
    }

    @Override
    public void saveResource(List<SyncResource> resourceList) {
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        Object[] args = null;
        for (SyncResource syncResource : resourceList) {
            args = new Object[]{syncResource.getId(), syncResource.getResourceId(), syncResource.getNetworkAreaCode(), syncResource.getResourceType(), syncResource.getResourceServiceType(), syncResource.getResourceOperatorType(), syncResource.getResourceInterfaceType(), syncResource.getResourceInterfaceAddress(), syncResource.getPowerType(), syncResource.getRegionalismCode(), syncResource.getResourceName(), syncResource.getResourceDescription(), syncResource.getStatus(), syncResource.getPublishScope(), syncResource.getRegisterTime(), syncResource.getUpdateTime(), syncResource.getDepCode(), syncResource.getOwnerIdentifier(), syncResource.getApproverIdentifier(), syncResource.getApproveTime(), syncResource.getUpdateTime()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(insertResourceSql, batchArgs);
    }

    @Override
    public void saveResource(SyncResource syncResource) {
        this.saveResource(Arrays.asList(syncResource));
    }

    @Override
    public void updateResource(List<SyncResource> resourceList) {
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        Object[] args = null;
        for (SyncResource syncResource : resourceList) {
            args = new Object[]{syncResource.getResourceType(), syncResource.getResourceServiceType(), syncResource.getResourceOperatorType(), syncResource.getResourceInterfaceType(), syncResource.getResourceInterfaceAddress(), syncResource.getPowerType(), syncResource.getResourceName(), syncResource.getResourceDescription(), syncResource.getStatus(), syncResource.getPublishScope(), syncResource.getRegisterTime(), syncResource.getUpdateTime(), syncResource.getDepCode(), syncResource.getOwnerIdentifier(), syncResource.getApproverIdentifier(), syncResource.getApproveTime(), syncResource.getUpdateTime(), syncResource.getResourceId(), syncResource.getRegionalismCode(), syncResource.getNetworkAreaCode()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(updateResourceSql, batchArgs);
    }

    @Override
    public void updateResource(SyncResource syncResource) {
        this.updateResource(Arrays.asList(syncResource));
    }

    @Override
    public Long getResourceLastUpdateTime(String regionalismCode) {
        String sql = "SELECT MAX(update_time) FROM t_sync_resource where regionalism_code = ?";
        Long lastUpdateTime2 = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{regionalismCode}, Long.class);
        lastUpdateTime2 = null == lastUpdateTime2 ? 0L : lastUpdateTime2;
        return lastUpdateTime2;
    }

    @Override
    public SyncResource getResourceSyncByResourceId(String resourceId, String regionalismCode) {
        String sql = "SELECT * FROM t_sync_resource  where resource_id = ?  and regionalism_Code = ? ";
        List<?> list = this.basicSyncCommonDao.selectList(sql, new Object[]{resourceId, regionalismCode}, SyncResource.class);
        return null != list && list.size() > 0 ? (SyncResource)list.get(0) : null;
    }
}

