/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SyncHandlerThreadFactory {
    private static AtomicInteger atomicInteger = new AtomicInteger();
    private static AtomicLong atomicLong = new AtomicLong(10L);
    private static ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(4, runnable -> {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName("sync-pool-" + atomicInteger.getAndIncrement());
        return thread;
    });

    public static long getSyncInitialDelay() {
        return SyncHandlerThreadFactory.getSyncInitialDelay(10L);
    }

    public static long getSyncInitialDelay(long initialDelay) {
        return atomicLong.getAndAdd(initialDelay);
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return executorService;
    }

    private SyncHandlerThreadFactory() {
    }

    public static void main(String[] args) {
        long syncInitialDelay = SyncHandlerThreadFactory.getSyncInitialDelay();
        long syncInitialDelay2 = SyncHandlerThreadFactory.getSyncInitialDelay();
        long syncInitialDelay3 = SyncHandlerThreadFactory.getSyncInitialDelay();
    }
}

