/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.init;

import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.enums.NetworkAreaCodeEnum;
import com.xdja.sync.enums.SystemEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.ExecuteScheduleSyncHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicInfoSyncSystemInit {
    private static final Logger logger = LoggerFactory.getLogger(BasicInfoSyncSystemInit.class);
    private static volatile boolean isRunning = false;
    private static final long DEFAULT_PERIOD = 300L;

    public static void init(SystemEnum systemEnum, String regionalismCode, NetworkAreaCodeEnum networkAreaCodeEnum, String pamsServerUrl, String ccmServerUrl) {
        BasicInfoSyncSystemInit.init(systemEnum, regionalismCode, networkAreaCodeEnum, pamsServerUrl, ccmServerUrl, TableEnum.values());
    }

    public static void init(SystemEnum systemEnum, String regionalismCode, NetworkAreaCodeEnum networkAreaCodeEnum, String pamsServerUrl, String ccmServerUrl, TableEnum ... tableEnums) {
        BasicInfoSyncSystemInit.init(systemEnum, regionalismCode, networkAreaCodeEnum, pamsServerUrl, ccmServerUrl, null, null, null, tableEnums);
    }

    public static void init(SystemEnum systemEnum, String regionalismCode, NetworkAreaCodeEnum networkAreaCodeEnum, String pamsServerUrl, String ccmServerUrl, String redisHost, Integer redisPort, String redisPassword, TableEnum ... tableEnums) {
        BasicInfoSyncSystemInit.init(systemEnum, regionalismCode, networkAreaCodeEnum, pamsServerUrl, 300L, TimeUnit.SECONDS, ccmServerUrl, 300L, TimeUnit.SECONDS, null, null, null, tableEnums);
    }

    public static void init(SystemEnum systemEnum, String regionalismCode, NetworkAreaCodeEnum networkAreaCodeEnum, String pamsServerUrl, long pamsPeriod, TimeUnit pamsPeriodUnit, String ccmServerUrl, long ccmPeriod, TimeUnit ccmPeriodUnit, String redisHost, Integer redisPort, String redisPassword, TableEnum ... tableEnums) {
        if (isRunning) {
            logger.error("\u540c\u6b65\u7a0b\u5e8f\u5df2\u7ecf\u542f\u52a8,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u540c\u6b65\u7a0b\u5e8f\u5df2\u7ecf\u542f\u52a8,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
        }
        isRunning = true;
        if (null == systemEnum) {
            logger.error("\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            throw SyncClientException.operateErrorException("\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == regionalismCode) {
            logger.error("\u884c\u653f\u533a\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            throw SyncClientException.operateErrorException("\u884c\u653f\u533a\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == networkAreaCodeEnum) {
            logger.error("\u7f51\u7edc\u90e8\u7f72\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
            throw SyncClientException.operateErrorException("\u7f51\u7edc\u90e8\u7f72\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == tableEnums) {
            logger.error("\u540c\u6b65\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            throw SyncClientException.operateErrorException("\u540c\u6b65\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (TableEnum tableEnum : tableEnums) {
            String tableName = tableEnum.getTableName();
            if (TableEnum.TABLE_PERSON.getTableName().equalsIgnoreCase(tableName) || TableEnum.TABLE_DEPARTMENT.getTableName().equalsIgnoreCase(tableName)) {
                if (null != pamsServerUrl && !"".equals(pamsServerUrl)) continue;
                logger.error("pams\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                throw SyncClientException.operateErrorException("pams\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!TableEnum.TABLE_REGISIONALISM.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_BUSINESS_TYPE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_SERVICE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_SERVICE_INTERFACE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_RESOURCE.getTableName().equalsIgnoreCase(tableName) && !TableEnum.TABLE_APP.getTableName().equalsIgnoreCase(tableName) || null != ccmServerUrl && !"".equals(ccmServerUrl)) continue;
            logger.error("ccm\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            throw SyncClientException.operateErrorException("ccm\u670d\u52a1\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Consts.systemName = systemEnum.getName();
        Consts.local_regionalismCode = regionalismCode;
        Consts.local_networkAreaCode = networkAreaCodeEnum.getCode();
        Consts.pamsServerUrl = pamsServerUrl;
        Consts.ccmServerUrl = ccmServerUrl;
        ((ExecuteScheduleSyncHandler)Consts.applicationContext.getBean(ExecuteScheduleSyncHandler.class)).run(tableEnums);
    }

    public static void main(String[] args) {
        BasicInfoSyncSystemInit.init(null, null, null, null, null, null);
    }
}

