/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.service.impl;

import com.xdja.pki.gmssl.core.utils.GMSSLBCHmacUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.sync.bean.SyncPerson;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.service.BasicSyncPersonService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasicSyncPersonServiceImpl
implements BasicSyncPersonService {
    private static final Logger logger = LoggerFactory.getLogger(BasicSyncPersonServiceImpl.class);
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public SyncPerson querySyncPersonById(String personId) {
        String sql = "SELECT * FROM t_sync_person WHERE id = ?";
        return (SyncPerson)this.basicSyncCommonDao.selectOne(sql, new Object[]{personId}, SyncPerson.class);
    }

    @Override
    public SyncPerson querySyncPersonByCode(String code) {
        return this.querySyncPersonByCode(code, null);
    }

    @Override
    public SyncPerson querySyncPersonByCodePwd(String code, String pwd) {
        String sql = "SELECT * FROM t_sync_person WHERE code = ? AND password = ?";
        Object[] args = new Object[]{code, pwd};
        return (SyncPerson)this.basicSyncCommonDao.selectOne(sql, args, SyncPerson.class);
    }

    @Override
    public SyncPerson querySyncPersonByCodePwd(String code, String pwdInput, String verifycode) {
        SyncPerson syncPerson = this.querySyncPersonByCode(code);
        if (null != syncPerson) {
            String pwd = syncPerson.getPassword();
            try {
                byte[] respData = GMSSLBCHmacUtils.hmac((byte[])pwd.getBytes(), (byte[])verifycode.getBytes(), (String)"HMac-SM3");
                pwd = GMSSLByteArrayUtils.hexEncode((byte[])respData);
            }
            catch (Exception e) {
                logger.error("\u52a0\u5bc6\u5bc6\u7801\u5931\u8d25:", (Throwable)e);
            }
            if (pwd.equals(pwdInput)) {
                return syncPerson;
            }
        }
        return null;
    }

    @Override
    public SyncPerson querySyncPersonByCode(String code, String deleteFlag) {
        String sql = "SELECT * FROM t_sync_person WHERE code = ? ";
        Object[] args = new Object[]{code};
        if (null != deleteFlag && !"".equals(deleteFlag)) {
            sql = sql + " AND flag = ?";
            args = new Object[]{code, deleteFlag};
        }
        return (SyncPerson)this.basicSyncCommonDao.selectOne(sql, args, SyncPerson.class);
    }

    @Override
    public List<SyncPerson> querySyncPersonList(String deleteFlag) {
        String sql = "SELECT * FROM t_sync_person ";
        Object[] args = null;
        if (null != deleteFlag && !"".equals(deleteFlag)) {
            sql = sql + " WHERE flag = ?";
            args = new Object[]{deleteFlag};
        }
        return this.basicSyncCommonDao.selectList(sql, args, SyncPerson.class);
    }
}

