/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.util;

import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncPerson;
import com.xdja.sync.bean.common.Consts;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CredentialUtil {
    private static Logger logger = LoggerFactory.getLogger(CredentialUtil.class);

    public static String getValueFromCredential(String credentialString, String keyTokenizer) {
        if (StringUtils.isEmpty((Object)credentialString) || StringUtils.isEmpty((Object)keyTokenizer)) {
            return null;
        }
        try {
            credentialString = URLDecoder.decode(credentialString, "UTF-8");
            String[] keyTokens = keyTokenizer.split("\\.");
            JSONObject credentialObject = JSONObject.parseObject((String)credentialString);
            for (int i = 0; i < keyTokens.length; ++i) {
                if (i == keyTokens.length - 1) {
                    return credentialObject.getString(keyTokens[i]);
                }
                credentialObject = credentialObject.getJSONObject(keyTokens[i]);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u5e76\u83b7\u53d6\u51ed\u8bc1\u5931\u8d25,credentialString\uff1a{}, keyTokenizer : {}", (Object)credentialString, (Object)keyTokenizer);
            return null;
        }
        return null;
    }

    public static String getRegionalismCodeFromCredential(String appCredential) {
        if (StringUtils.isEmpty((Object)appCredential)) {
            return null;
        }
        return CredentialUtil.getValueFromCredential(appCredential, "credential.head.token.orgId");
    }

    public static String getAppIdFromCredential(String appCredential) {
        if (StringUtils.isEmpty((Object)appCredential)) {
            return null;
        }
        return CredentialUtil.getValueFromCredential(appCredential, "credential.load.appInfo.appId");
    }

    public static String getAppRegionalismCodeFromCredential(String appCredential) {
        if (StringUtils.isEmpty((Object)appCredential)) {
            return null;
        }
        return CredentialUtil.getValueFromCredential(appCredential, "credential.load.appInfo.orgId");
    }

    public static String getNetworkCodeFromCredential(String appCredential) {
        if (StringUtils.isEmpty((Object)appCredential)) {
            return null;
        }
        return CredentialUtil.getValueFromCredential(appCredential, "credential.load.appInfo.networkAreaCode");
    }

    public static String getAppCsTypeFromCredential(String appCredential) {
        return StringUtils.isEmpty((Object)appCredential) ? null : CredentialUtil.getValueFromCredential(appCredential, "credential.load.appInfo.csType");
    }

    public static String getAppCredential() {
        return CredentialUtil.getAppCredential(null, null);
    }

    public static String getDeviceCredential() {
        return CredentialUtil.getDeviceCredential("44T4C21A19001495");
    }

    public static String getDeviceCredential(String deviceId) {
        try {
            String appCredential = "{\"credential\":{\"head\":{\"version\":\"1.0\",\"credType\":\"4\",\"token\":{\"tokenId\":\"3b7cbcb20a7b4f84a06b547155298e05\",\"orgId\":\"410000000000\"},\"duration\":{\"startTime\":\"1695775319573\",\"endTime\":\"1695775679573\"}},\"load\":{\"deviceInfo\":{\"deviceId\":\"" + deviceId + "\",\"imei\":\"861942055706858\"}},\"serverSign\":{\"alg\":\"SM3+SM2\",\"signature\":\"MEUCIQCGB0DmLSPyhadGn94hB2/UsEKDeynBSAOLsz5pUbPTvgIgVSoYj64qWImijjvGfMfPHkywEkoG0NRzyE5XwqxdeG4=\",\"sn\":\"1000190E\",\"url\":\"http://172.27.147.68:8083/uaas-api\"}}}";
            logger.info("DeviceCredential\u751f\u6210\u7684\u8bbe\u5907\u51ed\u8bc1\u3010{}\u3011", (Object)appCredential);
            return URLEncoder.encode(appCredential, "UTF-8");
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u8bbe\u5907\u7968\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String getAppCredential(String regionalismCode, String appId) {
        SyncApp syncApp = new SyncApp();
        syncApp.setAppId(appId);
        syncApp.setRegionalismCode(regionalismCode);
        return CredentialUtil.getAppCredential(syncApp);
    }

    public static String getAppCredential(SyncApp syncApp) {
        String csType;
        String appName;
        String networkAreaCode;
        String appPackage;
        String regionalismCode;
        String appId;
        if (null == syncApp) {
            syncApp = new SyncApp();
        }
        if (StringUtils.isEmpty((Object)(appId = syncApp.getAppId()))) {
            appId = "3532b4567eef468f9238a81db2cff0ea";
        }
        if (StringUtils.isEmpty((Object)(regionalismCode = syncApp.getAppRegionalismCode()))) {
            regionalismCode = Consts.local_regionalismCode;
        }
        if (StringUtils.isEmpty((Object)(appPackage = syncApp.getAppPackage()))) {
            appPackage = "com.xdja.rsb";
        }
        if (StringUtils.isEmpty((Object)(networkAreaCode = syncApp.getNetworkAreaCode()))) {
            networkAreaCode = "3";
        }
        if (StringUtils.isEmpty((Object)(appName = syncApp.getAppName()))) {
            appName = "\u670d\u52a1\u603b\u7ebf";
        }
        if (StringUtils.isEmpty((Object)(csType = syncApp.getCsType()))) {
            csType = "2";
        }
        try {
            String appCredential = "{\"credential\":{\"head\":{\"version\":\"1.0\",\"credType\":\"2\",\"token\":{\"tokenId\":\"" + UUID.randomUUID().toString().replaceAll("-", "") + "\",\"orgId\":\"" + regionalismCode + "\",\"exten\":\"\"},\"duration\":{\"startTime\":\"2012312312231\",\"endTime\":\"9012312312290\"}},\"load\":{\"appInfo\":{\"appId\":\"" + appId + "\",\"orgId\":\"" + regionalismCode + "\",\"packageName\":\"" + appPackage + "\",\"networkAreaCode\":\"" + networkAreaCode + "\",\"name\":\"" + appName + "\",\"csType\":\"" + csType + "\",\"exten\":\"\"}},\"serverSign\":{\"alg\":\"SM3+SM2\",\"signature\":\"b000000120123123123123123ec892ba\",\"sn\":\"1000000000100211\",\"url\":\"http://20.3.1.166/UAS/Credential.do\"},\"clientSign\":{\"alg\":\"SM3+SM2\",\"signature\":\"b000000120123123123123123ec892ba\",\"sn\":\"1000000000100001\"}}}";
            logger.info("AppCredential\u751f\u6210\u7684\u5e94\u7528\u51ed\u8bc1\u3010{}\u3011", (Object)appCredential);
            return URLEncoder.encode(appCredential, "UTF-8");
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u5e94\u7528\u7968\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String getUserCredential() {
        return CredentialUtil.getUserCredential("", "");
    }

    public static String getUserCredential(String regionalismCode, String userId) {
        SyncPerson syncPerson = new SyncPerson();
        syncPerson.setId(userId);
        return CredentialUtil.getUserCredential(regionalismCode, syncPerson);
    }

    public static String getUserCredential(String regionalismCode, SyncPerson syncPerson) {
        String xm;
        String jh;
        String sfzh;
        String userId;
        if (null == syncPerson) {
            syncPerson = new SyncPerson();
        }
        if (StringUtils.isEmpty((Object)regionalismCode)) {
            regionalismCode = Consts.local_regionalismCode;
        }
        if (StringUtils.isEmpty((Object)(userId = syncPerson.getId()))) {
            userId = "b000000120123123123123123ec892ba";
        }
        if (StringUtils.isEmpty((Object)(sfzh = syncPerson.getIdentifier()))) {
            sfzh = "0";
        }
        if (StringUtils.isEmpty((Object)(jh = syncPerson.getCode()))) {
            jh = "0";
        }
        if (StringUtils.isEmpty((Object)(xm = syncPerson.getName()))) {
            xm = "admin";
        }
        try {
            String userCredential = "{\"credential\":{\"head\":{\"version\":\"1.0\",\"credType\":\"1\",\"token\":{\"tokenId\":\"" + UUID.randomUUID().toString().replaceAll("-", "") + "\",\"orgId\":\"" + regionalismCode + "\",\"exten\":\"\"},\"duration\":{\"startTime\":\"2012312312231\",\"endTime\":\"9012312312290\"}},\"load\":{\"userInfo\":{\"userId\":\"" + userId + "\",\"orgId\":\"" + regionalismCode + "\",\"sfzh\":\"" + sfzh + "\",\"jh\":\"" + jh + "\",\"xm\":\"" + xm + "\",\"exten\":\"\"}},\"serverSign\":{\"alg\":\"SM3+SM2\",\"signature\":\"b000000120123123123123123ec892ba\",\"sn\":\"1000000000100211\",\"url\":\"http://20.3.1.166/UAS/Credential.do\"},\"clientSign\":{\"alg\":\"SM3+SM2\",\"signature\":\"b000000120123123123123123ec892ba\",\"sn\":\"1000000000100001\"}}}";
            logger.info("UserCredential\u751f\u6210\u7684\u7528\u6237\u51ed\u8bc1\u3010{}\u3011", (Object)userCredential);
            return URLEncoder.encode(userCredential, "UTF-8");
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u7528\u6237\u7968\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String regionalismCode = "110000000000";
        String appId = "3532b4567eef468f9238a81db2cff0ea";
        String AppCredential = CredentialUtil.getAppCredential(regionalismCode, appId);
        System.out.println(AppCredential);
        String userCredential = CredentialUtil.getUserCredential(regionalismCode, "0");
        String decode = URLDecoder.decode(AppCredential, "utf-8");
        System.out.println(decode);
    }
}

