CREATE TABLE `t_sync_person_app` (
	`PERSON_APP_ID` BIGINT(20) NOT NULL COMMENT '主键',
	`APP_ID` VARCHAR(64) NOT NULL COMMENT '应用id',
	`APP_REGIONALISM_CODE` VARCHAR(32) NOT NULL COMMENT '应用行政区划代码',
	`APP_NETWORK_CODE` VARCHAR(1) NULL DEFAULT NULL COMMENT '1一类2二类3三类',
	`PERSON_ID` VARCHAR(64) NOT NULL COMMENT '人员id',
	`PERSON_REGIONALISM_CODE` VARCHAR(32) NOT NULL COMMENT '人员行政区划代码',
	`STATUS` INT(1) NOT NULL COMMENT '状态：1授权，2收回，3删除',
	`CREATE_TIME` BIGINT(19) NOT NULL COMMENT '创建时间戳',
	`LAST_UPDATE_TIME` BIGINT(19) NULL DEFAULT NULL COMMENT '最后更新时间戳',
	PRIMARY KEY (`PERSON_APP_ID`),
	UNIQUE INDEX `unique_person_app` (`APP_ID`, `PERSON_ID`, `APP_REGIONALISM_CODE`, `PERSON_REGIONALISM_CODE`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='人员应用关系表'
