/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.dao.AppSyncDao;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.util.IdGeneratorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppSyncDaoImpl
implements AppSyncDao {
    private static final Logger logger = LoggerFactory.getLogger(AppSyncDaoImpl.class);
    private String insertAppSql = "INSERT INTO t_sync_app (id, app_id, app_name, app_package, app_description, app_type, app_version, app_status, network_area_code, app_file_size, create_time, version_code, app_url, regionalism_Code, update_time, power_type, APP_BS_URL_SUB) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private String updateAppSql = "UPDATE t_sync_app SET app_name=?, app_package=?, app_description=?, app_type=?, app_version=?, app_status=?, network_area_code=?, app_file_size=?, create_time=?, version_code=?, app_url=?, update_time=?, power_type=?, APP_BS_URL_SUB=?  where app_id = ?  and regionalism_Code = ? ";
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public SyncApp querySyncAppByAppId(String appId, String appRegionalismCode) {
        String sql = "SELECT * FROM t_sync_app  where app_id = ?  and regionalism_Code = ? ";
        List<?> list = this.basicSyncCommonDao.selectList(sql, new Object[]{appId, appRegionalismCode}, SyncApp.class);
        return null != list && list.size() > 0 ? (SyncApp)list.get(0) : null;
    }

    @Override
    public void saveOrUpdateApp(JSONArray appList) {
        for (int i = 0; i < appList.size(); ++i) {
            JSONObject jsonObject = appList.getJSONObject(i);
            String appId = jsonObject.getString("appId");
            String networkAreaCode = jsonObject.getString("networkAreaCode");
            String powerType = jsonObject.getString("powerType");
            String appRegionalismCode = jsonObject.getString("appRegionalismCode");
            String appName = jsonObject.getString("appName");
            String appVersion = jsonObject.getString("appVersion");
            int versionCode = jsonObject.getIntValue("versionCode");
            String appLogoUrl = jsonObject.getString("appLogoUrl");
            String appDescription = jsonObject.getString("appDescription");
            String appType = jsonObject.getString("appType");
            String appUrl = jsonObject.getString("appUrl");
            String appPackage = jsonObject.getString("appPackage");
            int appFileSize = jsonObject.getIntValue("appFileSize");
            String appFileMD5 = jsonObject.getString("appFileMD5");
            String updateNote = jsonObject.getString("updateNote");
            JSONArray appPictures = jsonObject.getJSONArray("appPictures");
            String appVideoUrl = jsonObject.getString("appVideoUrl");
            String appVideoImage = jsonObject.getString("appVideoImage");
            long createTime = jsonObject.getLongValue("createTime");
            long updateTime = jsonObject.getLongValue("updateTime");
            Integer appStatus = jsonObject.getInteger("status");
            appStatus = Objects.isNull(appStatus) ? 1 : appStatus;
            JSONArray appBSURLSubList = jsonObject.getJSONArray("appBSURLSubList");
            StringBuffer buffer = new StringBuffer();
            if (null != appBSURLSubList && appBSURLSubList.size() > 0) {
                for (int j = 0; j < appBSURLSubList.size(); ++j) {
                    String url = appBSURLSubList.getString(j);
                    buffer.append(url);
                    if (j == appBSURLSubList.size()) continue;
                    buffer.append("@@@@");
                }
            }
            String sql = "SELECT count(1) FROM t_sync_app  where app_id = ?  and regionalism_Code = ? ";
            Long count = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{appId, appRegionalismCode}, Long.class);
            Object[] args = null;
            if (!Objects.isNull(count) && count > 0L) {
                sql = this.updateAppSql;
                args = new Object[]{appName, appPackage, appDescription, appType, appVersion, appStatus, networkAreaCode, appFileSize, createTime, versionCode, appUrl, updateTime, powerType, buffer.toString(), appId, appRegionalismCode};
            } else {
                sql = this.insertAppSql;
                args = new Object[]{IdGeneratorUtil.nextUUID(), appId, appName, appPackage, appDescription, appType, appVersion, appStatus, networkAreaCode, appFileSize, createTime, versionCode, appUrl, appRegionalismCode, updateTime, powerType, buffer.toString()};
            }
            this.basicSyncCommonDao.updateBySql(sql, args);
        }
    }

    @Override
    public void saveSyncApp(SyncApp syncApp) {
        this.saveSyncApp(Arrays.asList(syncApp));
    }

    @Override
    public void saveSyncApp(List<SyncApp> listSyncApp) {
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        Object[] args = null;
        for (SyncApp syncApp : listSyncApp) {
            args = new Object[]{syncApp.getId(), syncApp.getAppId(), syncApp.getAppName(), syncApp.getAppPackage(), syncApp.getAppDescription(), syncApp.getAppType(), syncApp.getAppVersion(), syncApp.getAppStatus(), syncApp.getNetworkAreaCode(), syncApp.getAppFileSize(), syncApp.getCreateTime(), syncApp.getVersionCode(), syncApp.getAppUrl(), syncApp.getAppRegionalismCode(), syncApp.getUpdateTime(), syncApp.getPowerType(), syncApp.getAppBSURLSubList()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(this.insertAppSql, batchArgs);
    }

    @Override
    public void updateSyncApp(SyncApp syncApp) {
        this.updateSyncApp(Arrays.asList(syncApp));
    }

    @Override
    public void updateSyncApp(List<SyncApp> listSyncApp) {
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        Object[] args = null;
        for (SyncApp syncApp : listSyncApp) {
            args = new Object[]{syncApp.getAppName(), syncApp.getAppPackage(), syncApp.getAppDescription(), syncApp.getAppType(), syncApp.getAppVersion(), syncApp.getAppStatus(), syncApp.getNetworkAreaCode(), syncApp.getAppFileSize(), syncApp.getCreateTime(), syncApp.getVersionCode(), syncApp.getAppUrl(), syncApp.getUpdateTime(), syncApp.getPowerType(), syncApp.getAppBSURLSubList(), syncApp.getAppId(), syncApp.getAppRegionalismCode()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(this.updateAppSql, batchArgs);
    }

    @Override
    public Long getAppLastUpdateTime(String regionalismCode) {
        String sql = "SELECT MAX(update_time) from t_sync_app where regionalism_Code = ?";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, new Object[]{regionalismCode}, Long.class);
        return lastUpdateTime;
    }

    @Override
    public List<SyncApp> querySyncAppListByRegionalismCode(String appRegionalismCode) {
        String sql = "SELECT * from t_sync_app where regionalism_Code = ?";
        return this.basicSyncCommonDao.selectList(sql, new Object[]{appRegionalismCode}, SyncApp.class);
    }
}

