/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.version.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.sync.bean.SyncSystemConfig;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.BasicSyncSystemConfigDao;
import com.xdja.version.service.BasicSyncVersionUpdateService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class BasicSyncVersionUpdateServiceImpl
implements BasicSyncVersionUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(BasicSyncVersionUpdateServiceImpl.class);
    @Autowired
    private BasicSyncSystemConfigDao basicSyncSystemConfigDao;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void checkUpdate() {
        SyncSystemConfig syncSystemConfig = this.basicSyncSystemConfigDao.getSystemConfigByCode("BASIC_SYNC_VERSION");
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u7a0b\u5e8f\u7248\u672c\u4fe1\u606f>>>SyncSystemConfig\uff1a\u3010{}\u3011", (Object)(null != syncSystemConfig ? JSON.toJSONString((Object)syncSystemConfig) : null));
        }
        if (null == syncSystemConfig) {
            syncSystemConfig = new SyncSystemConfig();
            syncSystemConfig.setConfigId("BASIC_SYNC_VERSION");
            syncSystemConfig.setConfigCode("BASIC_SYNC_VERSION");
            syncSystemConfig.setConfigName("\u540c\u6b65\u7a0b\u5e8f\u7248\u672c\u53f7");
            syncSystemConfig.setConfigValue("1.0.4");
            syncSystemConfig.setConfigDesc("\u540c\u6b65\u7a0b\u5e8f\u7248\u672c\u53f7");
            syncSystemConfig.setParentId("0");
            syncSystemConfig.setUpdateTime(System.currentTimeMillis());
            this.basicSyncSystemConfigDao.saveSystemConfig(syncSystemConfig);
            List<String> listSql = this.getInitTableFileSql("1.0.4");
            for (String sql : listSql) {
                this.basicSyncCommonDao.updateBySql(sql, null);
            }
        } else {
            String string = syncSystemConfig.getConfigValue();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u7a0b\u5e8f\u7248\u672c\u4fe1\u606f<<<SyncSystemConfig\uff1a\u3010{}\u3011", (Object)JSON.toJSONString((Object)syncSystemConfig));
        }
    }

    private List<String> getInitTableFileSql(String updateSqlName) {
        ArrayList<String> listSql = new ArrayList<String>();
        String sql = "";
        try {
            String path = updateSqlName + ".upgrade." + Consts.dbType.getDb().toLowerCase() + ".sql";
            InputStream inputStream = BasicSyncVersionUpdateServiceImpl.class.getClassLoader().getResourceAsStream(path);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while (null != (line = bufferedReader.readLine())) {
                if (StringUtils.isEmpty((Object)line)) continue;
                sql = sql + line;
                boolean b = line.endsWith(";");
                if (!b) continue;
                listSql.add(sql);
                sql = "";
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5347\u7ea7\u811a\u672c[{}]\u5931\u8d25\uff1a", (Object)updateSqlName, (Object)e);
        }
        return listSql;
    }
}

