/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xdja.log.enums.LogStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LogBaseController {
    private static final String HEADER_CODE = "code";
    private static final String HEADER_MESSAGE_ID = "messageId";
    private static final String HEADER_MESSAGE = "message";
    private static final String HEADER_APP_CREDENTIAL = "appCredential";
    private static final String HEADER_USER_CREDENTIAL = "userCredential";
    public static final String REQ_MESSAGE = "\u5165\u53c2\u4e3a\uff1a";
    public static final String REP_MESSAGE = "\u51fa\u53c2\u4e3a\uff1a";
    private int count;
    private static final Logger logger = LoggerFactory.getLogger(LogBaseController.class);

    protected void writeAndFlushFailResponse(HttpServletRequest request, HttpServletResponse response, int code, String message) {
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, code, messageId, message, userCredential, appCredential, null);
    }

    protected void writeAndFlushFailResponse(int code, String message) {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, code, messageId, message, userCredential, appCredential, null);
    }

    protected void writeAndFlushFailResponse(HttpServletRequest request, HttpServletResponse response, int code, String message, Object object) {
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, code, messageId, message, userCredential, appCredential, object);
    }

    protected void writeAndFlushFailResponse(int code, String message, Object object) {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, code, messageId, message, userCredential, appCredential, object);
    }

    protected void writeAndFlushFailResponse(int code, String message, Object object, String messageId) {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, code, messageId, message, userCredential, appCredential, object);
    }

    protected void writeAndFlushSuccessResponse(HttpServletRequest request, HttpServletResponse response) {
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, LogStatus.SUCCESS.getCode(), messageId, LogStatus.SUCCESS.getDesc(), userCredential, appCredential, null);
    }

    protected void writeAndFlushSuccessResponse(HttpServletRequest request, HttpServletResponse response, String message) {
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, LogStatus.SUCCESS.getCode(), messageId, message, userCredential, appCredential, null);
    }

    protected void writeAndFlushSuccessResponse(HttpServletRequest request, HttpServletResponse response, Object object) {
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, LogStatus.SUCCESS.getCode(), messageId, LogStatus.SUCCESS.getDesc(), userCredential, appCredential, object);
    }

    protected void writeAndFlushSuccessResponse() {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, LogStatus.SUCCESS.getCode(), messageId, LogStatus.SUCCESS.getDesc(), userCredential, appCredential, null);
    }

    protected void writeAndFlushSuccessResponse(Object object) {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, LogStatus.SUCCESS.getCode(), messageId, LogStatus.SUCCESS.getDesc(), userCredential, appCredential, object);
    }

    protected void writeAndFlushSuccessResponseWithoutCredential(Object object) {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        String messageId = request.getHeader(HEADER_MESSAGE_ID);
        this.writeAndFlushResponse(request, response, LogStatus.SUCCESS.getCode(), messageId, LogStatus.SUCCESS.getDesc(), null, null, object);
    }

    protected void writeAndFlushSuccessResponse(String messageId, String message, Object object) {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        String userCredential = request.getHeader(HEADER_USER_CREDENTIAL);
        this.writeAndFlushResponse(request, response, LogStatus.SUCCESS.getCode(), messageId, message, userCredential, appCredential, object);
    }

    protected void writeAndFlushSuccessResponse(String messageId, String message, String userCredential, Object object) {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        String appCredential = request.getHeader(HEADER_APP_CREDENTIAL);
        this.writeAndFlushResponse(request, response, LogStatus.SUCCESS.getCode(), messageId, message, userCredential, appCredential, object);
    }

    protected void writeAndFlushResponse(int code, String messageId, String message, String userCredential, String appCredential, Object object) {
        RequestAttributes requestAttributes1 = RequestContextHolder.getRequestAttributes();
        if (Objects.isNull(requestAttributes1)) {
            return;
        }
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)requestAttributes1;
        HttpServletRequest request = requestAttributes.getRequest();
        HttpServletResponse response = requestAttributes.getResponse();
        this.writeAndFlushResponse(request, response, code, messageId, message, userCredential, appCredential, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAndFlushResponse(HttpServletRequest request, HttpServletResponse response, int code, String messageId, String message, String userCredential, String appCredential, Object object) {
        if (null == object) {
            object = new Object();
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u8f93\u51fa\u54cd\u5e94");
        OutputStream outputStream = null;
        int writeLength = 0;
        try {
            this.fillResponse(response, messageId, code, message, userCredential, appCredential);
            outputStream = response.getOutputStream();
            writeLength = JSON.writeJSONStringWithFastJsonConfig((OutputStream)outputStream, (Charset)StandardCharsets.UTF_8, (Object)object, (SerializeConfig)SerializeConfig.globalInstance, null, (String)"yyy-MM-dd HH:mm:ss", (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
        }
        catch (Exception e) {
            logger.error("\u5199\u51fa\u54cd\u5e94\u7ed3\u679c\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        finally {
            stopWatch.stop();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                }
            }
        }
    }

    private void fillResponse(HttpServletResponse response, String messageId, int code, String message, String userCredential, String appCredential) throws UnsupportedEncodingException {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setHeader(HEADER_CODE, code + "");
        response.setHeader(HEADER_MESSAGE_ID, messageId);
        response.setHeader(HEADER_MESSAGE, URLEncoder.encode(message, "UTF-8"));
    }
}

