/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.xdja.sync.bean.AppAddressBean;
import com.xdja.sync.dao.AppAddressSyncDao;
import com.xdja.sync.dao.BasicSyncCommonDao;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AppAddressSyncDaoImpl
implements AppAddressSyncDao {
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public void deleteAppAddressByAppId(String appId) {
        this.deleteAppAddressByAppId(appId, null);
    }

    @Override
    public void deleteAppAddressByAppId(String appId, String appRegionalismCode) {
        String sql = "delete from t_sync_app_address where app_id = ? ";
        Object[] args = new Object[]{appId};
        if (!StringUtils.isEmpty((Object)appRegionalismCode)) {
            sql = sql + " and app_regionalism_code = ? ";
            args = new Object[]{appId, appRegionalismCode};
        }
        this.basicSyncCommonDao.updateBySql(sql, args);
    }

    @Override
    public List<AppAddressBean> getAppAddressByAppId(String appId) {
        return this.getAppAddressByAppId(appId, null);
    }

    @Override
    public List<AppAddressBean> getAppAddressByAppId(String appId, String appRegionalismCode) {
        String sql = "select * from t_sync_app_address where app_id = ? ";
        Object[] args = new Object[]{appId};
        if (!StringUtils.isEmpty((Object)appRegionalismCode)) {
            sql = sql + " and app_regionalism_code = ? ";
            args = new Object[]{appId, appRegionalismCode};
        }
        return this.basicSyncCommonDao.selectList(sql, args, AppAddressBean.class);
    }

    @Override
    public void saveSyncAppAddress(AppAddressBean appAddressBean) {
        this.saveSyncAppAddress(Arrays.asList(appAddressBean));
    }

    @Override
    public void saveSyncAppAddress(List<AppAddressBean> listAppAddressBean) {
        String sql = "INSERT INTO t_sync_app_address (id, app_id, app_regionalism_code, network_area_code, app_url, app_proxy_url, update_time, app_url_type, app_url_num, app_proxy_port)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (AppAddressBean appAddressBean : listAppAddressBean) {
            Object[] args = new Object[]{appAddressBean.getId(), appAddressBean.getAppId(), appAddressBean.getAppRegionalismCode(), appAddressBean.getNetworkAreaCode(), appAddressBean.getAppUrl(), appAddressBean.getAppProxyUrl(), appAddressBean.getUpdateTime(), appAddressBean.getAppUrlType(), appAddressBean.getAppUrlNum(), appAddressBean.getAppProxyPort()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public void deleteSyncAppAddress(List<AppAddressBean> listAppAddressBean) {
        String sql = "DELETE FROM t_sync_app_address WHERE id = ? ";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (AppAddressBean appAddressBean : listAppAddressBean) {
            Object[] args = new Object[]{appAddressBean.getId()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public List<AppAddressBean> getAppAddressByAppUrl(String appUrl) {
        Integer port = null;
        try {
            URL url = new URL(appUrl);
            port = url.getPort();
        }
        catch (Exception url) {
            // empty catch block
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = "select * from t_sync_app_address where app_proxy_url = ? ";
        values.add(appUrl);
        if (appUrl.endsWith("/")) {
            sql = sql + " OR app_proxy_url = ? ";
            values.add(appUrl.substring(0, appUrl.length() - 1));
        }
        if (null != port && 0 != port) {
            sql = sql + " OR app_proxy_port = ? ";
            values.add(port);
        }
        return this.basicSyncCommonDao.selectList(sql, values.toArray(), AppAddressBean.class);
    }
}

