/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.SyncResource;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.AppResourceSyncDao;
import com.xdja.sync.dao.AppSyncDao;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.ResourceSyncDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.AppResourceSyncHandler;
import com.xdja.sync.handler.AppSyncHandler;
import com.xdja.sync.handler.ResourceSyncHandler;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.util.IdGeneratorUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class SyncAppOrResourceNotLocalHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(SyncAppOrResourceNotLocalHandler.class);
    @Value(value="${sync.appOrResourceNotLocal.interval:1800}")
    private Long syncPersonAppInterval;
    private volatile boolean syncAppResourceRunning = false;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private AppSyncHandler appSyncHandler;
    @Autowired
    private AppSyncDao appSyncDao;
    @Autowired
    private ResourceSyncDao resourceSyncDao;
    @Autowired
    private AppResourceSyncHandler appResourceSyncHandler;
    @Autowired
    private ResourceSyncHandler resourceSyncHandler;
    @Autowired
    private AppResourceSyncDao appResourceSyncDao;

    @Override
    String getPoolName() {
        return "appOrResourceNotLocal";
    }

    @Override
    void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        executorService.scheduleWithFixedDelay(() -> {
            try {
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_APP_RESOURCE.getTableName().equals(tableEnum.getTableName())) continue;
                    this.appOrResourceNotLocal();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, 300L, this.syncPersonAppInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int appOrResourceNotLocal() {
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        SyncAppOrResourceNotLocalHandler syncAppOrResourceNotLocalHandler = this;
        synchronized (syncAppOrResourceNotLocalHandler) {
            if (this.syncAppResourceRunning) {
                logger.error("\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncAppResourceRunning = true;
        }
        try {
            List<?> listRoamApp;
            String localNetworkAreaCode;
            String localRegionalismCode;
            block47: {
                localRegionalismCode = Consts.local_regionalismCode;
                localNetworkAreaCode = Consts.local_networkAreaCode;
                String sql = "";
                try {
                    sql = "SELECT DISTINCT app_id, APP_REGIONALISM_CODE FROM t_sync_app_resource t WHERE t.APP_REGIONALISM_CODE != ? AND t.RESOURCE_REGIONALISM_CODE = ?";
                    List<?> listSyncAppResource = this.basicSyncCommonDao.selectList(sql, new Object[]{localRegionalismCode, localRegionalismCode}, SyncAppResource.class);
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u540c\u6b65\u7533\u8bf7\u672c\u5730\u8d44\u6e90\u7684\u5f02\u5730\u5e94\u7528\u4fe1\u606f>>>");
                    }
                    if (null != listSyncAppResource && listSyncAppResource.size() > 0) {
                        for (SyncAppResource syncAppResource : listSyncAppResource) {
                            JSONObject appDetail = this.appSyncHandler.queryAppDetail(syncAppResource.getAppId(), syncAppResource.getAppRegionalismCode(), localNetworkAreaCode);
                            if (null == appDetail) continue;
                            SyncApp syncApp = this.appSyncHandler.buildSyncApp(appDetail);
                            SyncApp syncAppDb = this.appSyncDao.querySyncAppByAppId(syncApp.getAppId(), syncApp.getAppRegionalismCode());
                            if (null == syncAppDb) {
                                this.appSyncDao.saveSyncApp(syncApp);
                                continue;
                            }
                            if (!syncApp.getUpdateTime().equals(syncAppDb.getUpdateTime())) {
                                this.appSyncDao.updateSyncApp(syncApp);
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("\u5e94\u7528\u4fe1\u606f\u672a\u53d1\u751f\u53d8\u66f4SyncApp:\u3010{}\u3011", (Object)appDetail.toJSONString());
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u540c\u6b65\u7533\u8bf7\u672c\u5730\u8d44\u6e90\u7684\u5f02\u5730\u5e94\u7528\u4fe1\u606f<<<");
                    }
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u7533\u8bf7\u672c\u5730\u8d44\u6e90\u7684\u5f02\u5730\u5e94\u7528\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u6f2b\u6e38\u5e94\u7528\u7684\u8d44\u6e90\u5217\u8868>>>");
                }
                if (!CollectionUtils.isEmpty(listRoamApp = this.basicSyncCommonDao.selectList(sql = "SELECT DISTINCT app_id, regionalism_Code FROM t_sync_app t WHERE t.regionalism_Code != ?", new Object[]{localRegionalismCode}, SyncApp.class))) break block47;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u6f2b\u6e38\u5e94\u7528\u7684\u8d44\u6e90\u5217\u8868\u4e3a\u7a7a");
                }
                int n = 0;
                return n;
            }
            try {
                for (SyncApp syncApp : listRoamApp) {
                    try {
                        Object roamAppResource;
                        Iterator roamAppResourceIterator;
                        List<SyncAppResource> listRoamSyncAppResource = this.appResourceSyncHandler.pullResourceList(syncApp.getAppId(), syncApp.getRegionalismCode(), null);
                        List<SyncAppResource> listSyncAppResourceDb = this.appResourceSyncDao.queryAppResourceByAppId(syncApp.getAppId(), syncApp.getRegionalismCode());
                        ArrayList<SyncAppResource> originAppResourceList = new ArrayList<SyncAppResource>(listSyncAppResourceDb);
                        ArrayList<SyncAppResource> roamAppResourceBeans = new ArrayList<SyncAppResource>(listRoamSyncAppResource);
                        if (!CollectionUtils.isEmpty(originAppResourceList)) {
                            Iterator originAppResourceIterator = originAppResourceList.iterator();
                            while (originAppResourceIterator.hasNext()) {
                                SyncAppResource appResource = (SyncAppResource)originAppResourceIterator.next();
                                if (!localRegionalismCode.equals(appResource.getResourceRegionalismCode())) continue;
                                originAppResourceIterator.remove();
                            }
                        }
                        if (!CollectionUtils.isEmpty(roamAppResourceBeans)) {
                            roamAppResourceIterator = roamAppResourceBeans.iterator();
                            while (roamAppResourceIterator.hasNext()) {
                                roamAppResource = (SyncAppResource)roamAppResourceIterator.next();
                                if (!localRegionalismCode.equals(((SyncAppResource)roamAppResource).getResourceRegionalismCode())) continue;
                                roamAppResourceIterator.remove();
                            }
                        }
                        roamAppResourceIterator = roamAppResourceBeans.iterator();
                        while (roamAppResourceIterator.hasNext()) {
                            roamAppResource = (SyncAppResource)roamAppResourceIterator.next();
                            SyncAppResource originAppResource = this.findAppResourceFromOrigin((SyncAppResource)roamAppResource, originAppResourceList);
                            if (originAppResource == null) continue;
                            if (!SyncAppResource.status_grant_1.equals(originAppResource.getStatus())) {
                                originAppResource.setStatus(SyncAppResource.status_grant_1);
                                originAppResource.setLastUpdateTime(System.currentTimeMillis());
                                originAppResource.setCreateTime(System.currentTimeMillis());
                                this.appResourceSyncDao.updateAppResourceStatus(originAppResource);
                            }
                            originAppResourceList.remove(originAppResource);
                            roamAppResourceIterator.remove();
                        }
                        if (!CollectionUtils.isEmpty(roamAppResourceBeans)) {
                            for (SyncAppResource syncAppResource : roamAppResourceBeans) {
                                syncAppResource.setAppResourceId(IdGeneratorUtil.nextIdStr());
                                syncAppResource.setStatus(SyncAppResource.status_grant_1);
                                syncAppResource.setCreateTime(System.currentTimeMillis());
                                syncAppResource.setLastUpdateTime(System.currentTimeMillis());
                                this.appResourceSyncDao.saveAppResource(syncAppResource);
                            }
                        }
                        if (!CollectionUtils.isEmpty(originAppResourceList)) {
                            for (SyncAppResource syncAppResource : originAppResourceList) {
                                syncAppResource.setStatus(SyncAppResource.status_delete_3);
                                syncAppResource.setLastUpdateTime(System.currentTimeMillis());
                                this.appResourceSyncDao.updateAppResourceStatus(syncAppResource);
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u5f00\u59cb\u62c9\u53d6{}\u4e2a\u8d44\u6e90\u8be6\u60c5", (Object)listRoamSyncAppResource.size());
                        }
                        ArrayList<SyncResource> listSyncResource = new ArrayList<SyncResource>();
                        for (SyncAppResource roamAppResourceBean : listRoamSyncAppResource) {
                            if (localRegionalismCode.equals(roamAppResourceBean.getResourceRegionalismCode())) {
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug("\u8d44\u6e90{}\u662f\u672c\u5730\u8d44\u6e90,\u8d44\u6e90\u8be6\u60c5\u66f4\u65b0\u5df2\u88ab\u5ffd\u7565", (Object)roamAppResourceBean.getResourceId());
                                continue;
                            }
                            SyncResource syncResource = null;
                            try {
                                JSONObject detail = this.resourceSyncHandler.httpQueryResourceDetail(roamAppResourceBean.getResourceId(), roamAppResourceBean.getResourceRegionalismCode(), localNetworkAreaCode);
                                syncResource = this.resourceSyncHandler.buildSyncResource(detail);
                                if (null == syncResource) continue;
                                listSyncResource.add(syncResource);
                            }
                            catch (Exception e) {
                                logger.error("\u83b7\u53d6\u884c\u653f\u533a\u5212{}-{}\u7684\u8d44\u6e90\u8be6\u60c5\u5f02\u5e38", new Object[]{roamAppResourceBean.getAppRegionalismCode(), roamAppResourceBean.getAppId(), e});
                            }
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u5171\u62c9\u53d6\u5230{}\u4e2a\u8d44\u6e90\u8be6\u60c5\n\u5185\u5bb9:{}", (Object)listSyncResource.size(), (Object)JSON.toJSONString(listSyncResource));
                        }
                        if (CollectionUtils.isEmpty(listSyncResource)) continue;
                        for (SyncResource syncResource : listSyncResource) {
                            SyncResource oldEntity = this.resourceSyncDao.getResourceSyncByResourceId(syncResource.getResourceId(), syncResource.getRegionalismCode());
                            if (oldEntity == null) {
                                this.resourceSyncDao.saveResource(syncResource);
                                continue;
                            }
                            if (oldEntity.getUpdateTime().equals(syncResource.getUpdateTime())) continue;
                            this.resourceSyncDao.updateResource(syncResource);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u672c\u6b21\u4ece\u5f02\u5730\u62c9\u53d6\u5230\u7684\u5e94\u7528\u8d44\u6e90\u6743\u9650\u6570\u636e<<<");
                        }
                    }
                    catch (Throwable throwable) {
                        logger.error("\u5f02\u5730\u5e94\u7528\u8d44\u6e90\u6743\u9650\u5165\u5e93\u5931\u8d25", throwable);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("\u540c\u6b65\u6f2b\u6e38\u5e94\u7528\u7684\u8d44\u6e90\u5217\u8868<<<");
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u6f2b\u6e38\u5e94\u7528\u7684\u8d44\u6e90\u5217\u8868\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncAppResourceRunning = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb<<<");
        }
        return 0;
    }

    private SyncAppResource findAppResourceFromOrigin(SyncAppResource condition, List<SyncAppResource> originAppResourceList) {
        if (!CollectionUtils.isEmpty(originAppResourceList)) {
            for (SyncAppResource appResource : originAppResourceList) {
                if (!appResource.getAppId().equals(condition.getAppId()) || !appResource.getAppRegionalismCode().equals(condition.getAppRegionalismCode()) || !appResource.getResourceId().equals(condition.getResourceId()) || !appResource.getResourceRegionalismCode().equals(condition.getResourceRegionalismCode())) continue;
                return appResource;
            }
        }
        return null;
    }

    @Override
    TableEnum[] supportType(TableEnum[] tableEnums) {
        return new TableEnum[0];
    }
}

