/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.common.RedisKeyConst;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.handler.BasicLogClearHandler;
import com.xdja.log.handler.BasicLogHandlerFactory;
import com.xdja.log.service.BasicLogCacheService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RedisBasicLogCacheServiceImpl
implements BasicLogCacheService {
    private static final Logger logger = LoggerFactory.getLogger(RedisBasicLogCacheServiceImpl.class);
    @Autowired(required=false)
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BasicLogHandlerFactory basicLogHandlerFactory;
    @Autowired
    private BasicLogClearHandler basicLogClearHandler;
    @Autowired
    private Environment environment;
    private AtomicInteger atomicInteger = new AtomicInteger(0);
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("log-cache-redis-" + RedisBasicLogCacheServiceImpl.this.atomicInteger.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    @Override
    public void cacheLog(LogCacheBean logCacheBean) {
        try {
            this.stringRedisTemplate.opsForList().rightPush((Object)RedisKeyConst.getLogCacheKey(), (Object)JSON.toJSONString((Object)logCacheBean));
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public void consumeLog() {
        try {
            this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        ListOperations stringStringListOperations = RedisBasicLogCacheServiceImpl.this.stringRedisTemplate.opsForList();
                        String logCacheKey = RedisKeyConst.getLogCacheKey();
                        Long size = stringStringListOperations.size((Object)logCacheKey);
                        if (null != size && size > 0L) {
                            int i = 0;
                            while ((long)i < size) {
                                String json = (String)stringStringListOperations.leftPop((Object)RedisKeyConst.getLogCacheKey());
                                if (logger.isDebugEnabled()) {
                                    logger.debug("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7[{}/{}]>>>LogCacheBean:\u3010{}\u3011", new Object[]{i + 1, size, json});
                                }
                                if (!StringUtils.isEmpty((Object)json)) {
                                    LogCacheBean logCacheBean = (LogCacheBean)JSON.parseObject((String)json, LogCacheBean.class);
                                    RedisBasicLogCacheServiceImpl.this.basicLogHandlerFactory.handlerLog(logCacheBean);
                                }
                                if (logger.isDebugEnabled()) {
                                    logger.debug("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7[{}/{}]<<<", (Object)(i + 1), (Object)size);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public void clearLog() {
        try {
            this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7>>>");
                        }
                        RedisBasicLogCacheServiceImpl.this.basicLogClearHandler.deleteLog();
                        RedisBasicLogCacheServiceImpl.this.basicLogClearHandler.clearLogField();
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7<<<");
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
                    }
                }
            }, 1L, 720L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
        }
    }
}

