/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.smcs.util;

import com.xdja.common.BasicSystemInitUtil;
import com.xdja.smcs.enums.NetworkEnum;
import com.xdja.smcs.enums.RegionalismEnum;
import org.apache.http.util.TextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class SmcsPlatformUtil {
    @Autowired
    private Environment environment;
    @Autowired
    private BasicSystemInitUtil basicSystemInitUtil;

    public String getSystemCode() {
        return this.basicSystemInitUtil.getSystemCode();
    }

    public String getSmcsSwitch() {
        String smcsSwitch = this.environment.getProperty("smcs.switch", "off");
        return smcsSwitch;
    }

    public String getWebUrl() {
        String webUrl = this.environment.getProperty("smcs.web.url", "/index.html");
        return webUrl;
    }

    public String getMiddlewares() {
        String middleWares = this.environment.getProperty("smcs.middle.wares", "\u65e0");
        return middleWares;
    }

    public String getOwnerName() {
        String ownerName = this.environment.getProperty("smcs.owner.name", "\u6280\u672f\u652f\u6301");
        return ownerName;
    }

    public String getOwnerPhone() {
        String ownerPhone = this.environment.getProperty("smcs.owner.phone", "400-888-7801");
        return ownerPhone;
    }

    public boolean reportSmcsSwitch() {
        return "on".equals(this.getSmcsSwitch());
    }

    public String getSmcsUrl() {
        String smcsUrl = this.environment.getProperty("smcs.server.url");
        return smcsUrl;
    }

    public String getDevelopLanguage() {
        String developLanguage = this.environment.getProperty("smcs.develop.language", "Java,vue");
        return developLanguage;
    }

    public String getRegionalismCode() {
        String regionalismCode;
        String systemCode = this.getSystemCode();
        if (!TextUtils.isEmpty((CharSequence)systemCode) && !TextUtils.isEmpty((CharSequence)(regionalismCode = RegionalismEnum.getRegionalismCode(systemCode)))) {
            return this.environment.getProperty(regionalismCode, "");
        }
        return "";
    }

    public String getNetWorkCode() {
        String regionalismCode;
        String systemCode = this.getSystemCode();
        if (!TextUtils.isEmpty((CharSequence)systemCode) && !TextUtils.isEmpty((CharSequence)(regionalismCode = NetworkEnum.getNetWorkCode(systemCode)))) {
            return this.environment.getProperty(regionalismCode, "");
        }
        return "";
    }
}

