/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.xdja.common.BasicSystemInitUtil;
import com.xdja.common.BisRedisUtil;
import com.xdja.common.RedisKeyConst;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncPersonApp;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.bean.common.PageReqBean;
import com.xdja.sync.bean.table.SyncTableConfig;
import com.xdja.sync.bean.table.SyncTableDataResBean;
import com.xdja.sync.dao.AppAddressSyncDao;
import com.xdja.sync.dao.AppResourceSyncDao;
import com.xdja.sync.dao.AppSyncDao;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.CcmSyncDao;
import com.xdja.sync.dao.DeviceNetworkGroupSyncDao;
import com.xdja.sync.dao.PamsSyncDao;
import com.xdja.sync.dao.PersonAppSyncDao;
import com.xdja.sync.dao.PersonDeviceSyncDao;
import com.xdja.sync.dao.ResourceSyncDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.RoamException;
import com.xdja.sync.exception.RoamExceptionCodeEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.service.BasicSyncAppService;
import com.xdja.sync.service.InterfaceSvcCallService;
import com.xdja.sync.util.IdGeneratorUtil;
import com.xdja.task.ThreadManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class TableDataSyncTask
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(TableDataSyncTask.class);
    private volatile boolean syncTableDataRunning = false;
    private volatile boolean syncSyncTableDataRunning = false;
    private volatile boolean syncSyncPersonAppTableDataRunning = false;
    @Autowired
    private Environment environment;
    @Autowired
    private BasicSystemInitUtil basicSystemInitUtil;
    @Autowired
    private InterfaceSvcCallService interfaceSvcCallService;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private AppSyncDao appSyncDao;
    @Autowired
    private BasicSyncAppService basicSyncAppService;
    @Autowired
    private ResourceSyncDao resourceSyncDao;
    @Autowired
    private PamsSyncDao pamsSyncDao;
    @Autowired
    private CcmSyncDao ccmSyncDao;
    @Autowired
    private PersonAppSyncDao personAppSyncDao;
    @Autowired
    private PersonDeviceSyncDao personDeviceSyncDao;
    @Autowired
    private AppResourceSyncDao appResourceSyncDao;
    @Autowired
    private AppAddressSyncDao appAddressSyncDao;
    @Autowired
    private DeviceNetworkGroupSyncDao deviceNetworkGroupSyncDao;
    private static final String DEFAULT_SYNCTABLE_CONFIG = "[\n\t{\n\t\t\"tableName\": \"t_sync_department\",\n\t\t\"primaryKey\": \"id\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"N_LAST_UPDATE_TIME\",\n\t\t\"pageSize\": 2000\n\t},\n\t{\n\t\t\"tableName\": \"t_sync_person\",\n\t\t\"primaryKey\": \"id\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"n_last_update_time\",\n\t\t\"pageSize\": 2000\n\t},\n\t{\n\t\t\"tableName\": \"t_sync_business_type\",\n\t\t\"primaryKey\": \"code\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"update_time\",\n\t\t\"pageSize\": 2000\n\t},\n\t{\n\t\t\"tableName\": \"t_sync_regionalism\",\n\t\t\"primaryKey\": \"code\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"update_time\",\n\t\t\"pageSize\": 2000\n\t},\n\t{\n\t\t\"tableName\": \"t_sync_service\",\n\t\t\"primaryKey\": \"service_id\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"update_time\",\n\t\t\"pageSize\": 2000\n\t},\n\t{\n\t\t\"tableName\": \"t_sync_service_interface\",\n\t\t\"primaryKey\": \"interface_id\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"update_time\",\n\t\t\"pageSize\": 2000\n\t},\n\t{\n\t\t\"tableName\": \"t_sync_app\",\n\t\t\"primaryKey\": \"id\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"update_time\",\n\t\t\"pageSize\": 2000\n\t},\n\t{\n\t\t\"tableName\": \"t_sync_resource\",\n\t\t\"primaryKey\": \"id\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"update_time\",\n\t\t\"pageSize\": 2000\n\t},\n\t{\n\t\t\"tableName\": \"t_sync_person_app\",\n\t\t\"primaryKey\": \"PERSON_APP_ID\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"LAST_UPDATE_TIME\",\n\t\t\"pageSize\": 2000\n\t},\n\t{\n\t\t\"tableName\": \"t_sync_device_network\",\n\t\t\"primaryKey\": \"id\",\n\t\t\"syncMode\": \"2\",\n\t\t\"lastOrderField\": \"CREATE_TIME\",\n\t\t\"pageSize\": 2000\n\t}\n]";

    public void afterPropertiesSet() throws Exception {
        String switchSync = this.environment.getProperty("crossNetwork.server.sync.switch", "off");
        if ("off".equalsIgnoreCase(switchSync)) {
            logger.info("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879{}=on", (Object)"crossNetwork.server.sync.switch");
            return;
        }
        ScheduledExecutorService executorService = SyncHandlerThreadFactory.getScheduledExecutorService(this.getPoolName());
        String frequency = this.environment.getProperty("crossNetwork.server.sync.frequency", "600");
        Integer syncInterval = Integer.parseInt(frequency);
        long syncInitialDelay = SyncHandlerThreadFactory.getSyncInitialDelay();
        logger.info("\u8de8\u7f51\u540c\u6b65sync\u8868\u6570\u636e[{}]\u79d2\u540e\u5f00\u542f", (Object)syncInitialDelay);
        executorService.scheduleWithFixedDelay(() -> {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("\u8de8\u7f51\u540c\u6b65sync\u8868\u6570\u636e\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879{}:[{}]\u79d2>>>", (Object)"crossNetwork.server.sync.frequency", (Object)syncInterval);
                }
                List<SyncTableConfig> listSyncTableConfig = new ArrayList();
                String syncTableJson = this.environment.getProperty("crossNetwork.server.sync.SyncTable", "");
                logger.info("\u8de8\u7f51\u540c\u6b65sync\u8868\u6570\u636e\u914d\u7f6e\u9879{}=\u3010{}\u3011", (Object)"crossNetwork.server.sync.SyncTable");
                if (StringUtils.isEmpty((Object)syncTableJson)) {
                    SyncTableConfig syncTableConfig = null;
                    for (TableEnum tableEnum : TableEnum.values()) {
                        String tableName = tableEnum.getTableName();
                        String primaryKey = tableEnum.getPrimaryKey();
                        String lastOrderField = tableEnum.getLastOrderField();
                        String crossSyncSwitch = tableEnum.getCrossSyncSwitch();
                        if (!"on".equals(crossSyncSwitch)) continue;
                        syncTableConfig = new SyncTableConfig();
                        syncTableConfig.setTableName(tableName);
                        syncTableConfig.setSyncMode("2");
                        syncTableConfig.setPageSize(2000);
                        syncTableConfig.setPrimaryKey(primaryKey);
                        syncTableConfig.setLastOrderField(lastOrderField);
                        listSyncTableConfig.add(syncTableConfig);
                    }
                } else {
                    listSyncTableConfig = JSONArray.parseArray((String)syncTableJson, SyncTableConfig.class);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u540c\u6b65\u8868\u914d\u7f6e\uff1a\u3010{}\u3011", (Object)syncTableJson);
                }
                String lockKey = RedisKeyConst.getLockSyncSyncTableDataKey();
                boolean personAppSwitch = false;
                Iterator iterator = listSyncTableConfig.iterator();
                while (iterator.hasNext()) {
                    SyncTableConfig syncTableConfig = (SyncTableConfig)iterator.next();
                    if (!syncTableConfig.getTableName().equalsIgnoreCase(TableEnum.TABLE_PERSON_APP.getTableName())) continue;
                    iterator.remove();
                    personAppSwitch = true;
                    break;
                }
                this.execSyncTableData(listSyncTableConfig, lockKey, true);
                if (personAppSwitch) {
                    this.syncSyncPersonApp();
                }
                if (logger.isInfoEnabled()) {
                    logger.info("\u8de8\u7f51\u540c\u6b65sync\u8868\u6570\u636e\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879{}:[{}]\u79d2<<<", (Object)"crossNetwork.server.sync.frequency", (Object)syncInterval);
                }
            }
            catch (Exception e) {
                logger.error("\u8de8\u7f51\u540c\u6b65sync\u8868\u6570\u636e\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879{}:[{}]\u79d2, \u5f02\u5e38\uff1a", new Object[]{"crossNetwork.server.sync.frequency", syncInterval, e});
            }
        }, syncInitialDelay, syncInterval.intValue(), TimeUnit.SECONDS);
        syncInitialDelay = SyncHandlerThreadFactory.getSyncInitialDelay();
        logger.info("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e[{}]\u79d2\u540e\u5f00\u542f", (Object)syncInitialDelay);
        executorService.scheduleWithFixedDelay(() -> {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879{}:[{}]\u79d2>>>", (Object)"crossNetwork.server.sync.frequency", (Object)syncInterval);
                }
                this.execSyncTableData(new ArrayList<SyncTableConfig>());
                if (logger.isInfoEnabled()) {
                    logger.info("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879{}:[{}]\u79d2<<<", (Object)"crossNetwork.server.sync.frequency", (Object)syncInterval);
                }
            }
            catch (Exception e) {
                logger.info("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879{}:[{}]\u79d2, \u5f02\u5e38\uff1a", new Object[]{"crossNetwork.server.sync.frequency", syncInterval, e});
            }
        }, syncInitialDelay, syncInterval.intValue(), TimeUnit.SECONDS);
    }

    private String getPoolName() {
        return "sync-thread-crossNetwork-1";
    }

    public void execSyncTableData(List<SyncTableConfig> listSyncTableConfig) {
        String lockKey = RedisKeyConst.getLockSyncTableDataKey();
        this.execSyncTableData(listSyncTableConfig, lockKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execSyncTableData(List<SyncTableConfig> listSyncTableConfig, final String lockKey, boolean syncSyncTable) {
        boolean existRedis;
        final long timeout = 900L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            TableDataSyncTask tableDataSyncTask = this;
            synchronized (tableDataSyncTask) {
                if (this.syncTableDataRunning) {
                    logger.error("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncTableDataRunning = true;
            }
        }
        try {
            if (CollectionUtils.isEmpty(listSyncTableConfig)) {
                String json = this.environment.getProperty("crossNetwork.server.sync.table", "");
                if (StringUtils.isEmpty((Object)json)) {
                    logger.error("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u8868\u914d\u7f6e\u9879{}\u4e3a\u7a7a", (Object)"crossNetwork.server.sync.table");
                    listSyncTableConfig = Consts.listSyncTableData;
                } else {
                    listSyncTableConfig = JSONArray.parseArray((String)json, SyncTableConfig.class);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u540c\u6b65\u8868\u914d\u7f6e\u8fc7\u6ee4\u524d\uff1a\u3010{}\u3011", (Object)JSON.toJSONString(listSyncTableConfig));
            }
            if (CollectionUtils.isEmpty(listSyncTableConfig)) {
                logger.error("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u8868\u4e3a\u7a7a");
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (TableEnum value : TableEnum.values()) {
                String crossSyncSwitch = value.getCrossSyncSwitch();
                if (!"on".equals(crossSyncSwitch)) continue;
                map.put(value.getTableName().toLowerCase(), value.getTableName().toLowerCase());
            }
            for (SyncTableConfig syncTableConfig : listSyncTableConfig) {
                String syncMode;
                String tableName = syncTableConfig.getTableName();
                if (!Consts.allTableName.containsKey(tableName.toLowerCase()) || !syncSyncTable && map.containsKey(tableName.toLowerCase()) || !"2".equals(syncMode = syncTableConfig.getSyncMode())) continue;
                String lastOrderFieldValue = this.getLastOrderFieldValue(syncTableConfig.getTableName(), syncTableConfig.getLastOrderField());
                syncTableConfig.setLastOrderFieldValue(lastOrderFieldValue);
                syncTableConfig.setPageNo(1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u540c\u6b65\u8868\u914d\u7f6e\u8fc7\u6ee4\u540e\uff1a\u3010{}\u3011", (Object)JSON.toJSONString(listSyncTableConfig));
            }
            ArrayList<Future> listFuture = new ArrayList<Future>();
            int total = listSyncTableConfig.size();
            for (int i = 0; i < listSyncTableConfig.size(); ++i) {
                final SyncTableConfig syncTableConfig = listSyncTableConfig.get(i);
                String tableName = syncTableConfig.getTableName();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e[{}/{}][{}]\u8868\u6570\u636e:\u3010{}\u3011>>>", new Object[]{i + 1, total, syncTableConfig.getTableName(), JSON.toJSONString((Object)syncTableConfig)});
                }
                Future future = ThreadManager.getInstance().submit(new Callable(){

                    public Object call() throws Exception {
                        TableDataSyncTask.this.syncTable(syncTableConfig, existRedis, lockKey, timeout);
                        return 1;
                    }
                }, "tableData");
                listFuture.add(future);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e[{}/{}][{}]\u8868\u6570\u636e<<<", new Object[]{i + 1, total, tableName});
            }
            for (Future future : listFuture) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    logger.error("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
                }
                if (!existRedis) continue;
                BisRedisUtil.renewalLock(lockKey, timeout);
            }
        }
        catch (Exception e) {
            logger.error("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u8868,\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            this.syncTableDataRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
    }

    private void syncTable(SyncTableConfig syncTableConfig, boolean existRedis, String lockKey, long timeout) {
        SyncTableDataResBean resBean = this.pullSyncTableData(syncTableConfig);
        if (null == resBean) {
            logger.warn("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u8868-\u54cd\u5e94\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        String syncMode = syncTableConfig.getSyncMode();
        ArrayList<SyncTableDataResBean> listResData = new ArrayList<SyncTableDataResBean>();
        if ("2".equals(syncMode)) {
            Page page = resBean.getPage();
            if (null == page || page.getTotal() < 1L || null == page.getData()) {
                return;
            }
            listResData.add(resBean);
            long total = page.getTotal();
            int pageNo = page.getPageNo();
            int pageSize = page.getPageSize();
            String tableName = resBean.getTableName();
            Object data = page.getData();
            List listMap = (List)JSONArray.parse((String)JSON.toJSONString((Object)data));
            int currentPullDataTotalSize = listMap.size();
            if (currentPullDataTotalSize == pageSize && (long)currentPullDataTotalSize < total) {
                int currentPullDataSize = currentPullDataTotalSize;
                ++pageNo;
                while (true) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u62c9\u53d6\u8868[{}]\u7b2c[{}]\u9875\u6570\u636e>>>", (Object)tableName, (Object)pageNo);
                    }
                    syncTableConfig.setPageNo(pageNo);
                    resBean = this.pullSyncTableData(syncTableConfig);
                    page = resBean.getPage();
                    if (null == page || page.getTotal() < 1L || null == page.getData()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u62c9\u53d6\u8868[{}]\u7b2c[{}]\u9875\u6570\u636e\u4e3a\u7a7a\uff0c\u7ed3\u675f\u62c9\u53d6", (Object)tableName, (Object)pageNo);
                        }
                        break;
                    }
                    listResData.add(resBean);
                    List listMap2 = (List)JSONArray.parse((String)JSON.toJSONString((Object)data));
                    currentPullDataSize = listMap2.size();
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u62c9\u53d6\u8868[{}]\u7b2c[{}]\u9875\u6570\u636e[{}]\u6761<<<", new Object[]{tableName, pageNo, currentPullDataSize});
                    }
                    if (currentPullDataSize < pageSize || (long)(currentPullDataTotalSize += currentPullDataSize) >= total) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u62c9\u53d6\u8868[{}]\u7b2c[{}]\u9875\u6570\u636e\uff0c\u5168\u90e8\u62c9\u53d6\u5b8c\u6210\uff0c\u5171[{}]\u6761\uff0c\u7ed3\u675f\u62c9\u53d6<<<", new Object[]{tableName, pageNo, currentPullDataTotalSize});
                        }
                        break;
                    }
                    ++pageNo;
                }
            }
        } else {
            listResData.add(resBean);
        }
        int total = listResData.size();
        for (int i = 0; i < listResData.size(); ++i) {
            Page page;
            resBean = (SyncTableDataResBean)listResData.get(i);
            String tableName = resBean.getTableName();
            if (logger.isDebugEnabled()) {
                logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8868[{}]-[{}/{}]\u6570\u636e:\u3010{}\u3011>>>", new Object[]{tableName, i + 1, total, JSON.toJSONString((Object)resBean)});
            }
            if (null == (page = resBean.getPage()) || page.getTotal() < 1L) {
                logger.warn("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8868[{}]\u65e0\u6570\u636e\u66f4\u65b0", (Object)resBean.getTableName());
                continue;
            }
            try {
                this.batchUpdateTable(resBean);
            }
            catch (Exception e) {
                logger.error("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8868[{}]-[{}/{}]\u6570\u636e\uff0c\u5165\u5e93\u5931\u8d25", new Object[]{tableName, i + 1, total, e});
            }
            if (existRedis) {
                BisRedisUtil.renewalLock(lockKey, timeout);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8868[{}]-[{}/{}]\u6570\u636e<<<", new Object[]{tableName, i + 1, total});
        }
    }

    private String getLastOrderFieldValue(String tableName, String lastOrderField) {
        String sql = "SELECT MAX(" + lastOrderField + ") FROM " + tableName;
        String lastOrderFieldValue = (String)this.basicSyncCommonDao.selectOne(sql, null, String.class);
        if (logger.isDebugEnabled()) {
            logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8868[{}],{}:[{}]", new Object[]{tableName, lastOrderField, lastOrderFieldValue});
        }
        return lastOrderFieldValue;
    }

    private SyncTableDataResBean pullSyncTableData(SyncTableConfig syncTableConfig) {
        SyncTableDataResBean result = null;
        List<SyncTableDataResBean> listResult = this.pullSyncTableData(Arrays.asList(syncTableConfig));
        if (CollectionUtils.isEmpty(listResult)) {
            logger.error("\u540c\u6b65\u670d\u52a1[{}]\u8868\u6570\u636e\u4e3a\u7a7a<<<");
            return result;
        }
        result = listResult.get(0);
        return result;
    }

    private List<SyncTableDataResBean> pullSyncTableData(List<SyncTableConfig> listSyncTableConfig) {
        ArrayList<SyncTableDataResBean> result = new ArrayList<SyncTableDataResBean>();
        String interfaceUrl = this.getInterfaceUrl("/admin/v1/syncData/syncTableData.do");
        if (logger.isDebugEnabled()) {
            logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8c03\u7528url\uff1a\u3010{}\u3011, param:\u3010{}\u3011>>>", (Object)interfaceUrl, (Object)JSON.toJSONString(listSyncTableConfig));
        }
        String resultJson = this.interfaceSvcCallService.executeCall(interfaceUrl, listSyncTableConfig);
        if (logger.isDebugEnabled()) {
            logger.debug("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8c03\u7528url\uff1a\u3010{}\u3011, param:\u3010{}\u3011<<<", (Object)interfaceUrl, (Object)JSON.toJSONString(listSyncTableConfig));
        }
        if (StringUtils.isEmpty((Object)resultJson)) {
            logger.warn("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u6570\u636e\u54cd\u5e94\u4e3a\u7a7a");
            return result;
        }
        List listResult = JSONArray.parseArray((String)resultJson, SyncTableDataResBean.class);
        if (CollectionUtils.isEmpty((Collection)listResult)) {
            logger.warn("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u6570\u636e\u54cd\u5e94\u4e3a\u7a7a<<<");
            return result;
        }
        return listResult;
    }

    private String getInterfaceUrl(String methodUrl) {
        String interfaceUrl = this.environment.getProperty("crossNetwork.server.url", "");
        if (StringUtils.isEmpty((Object)interfaceUrl)) {
            logger.error("\u540c\u6b65\u670d\u52a1[{}]crossNetwork.server.url\u914d\u7f6e\u5730\u5740\u4e3a\u7a7a");
            throw new RoamException(RoamExceptionCodeEnum.RES_EMPTY.getCode(), RoamExceptionCodeEnum.RES_EMPTY.getMessage());
        }
        interfaceUrl = interfaceUrl + methodUrl;
        return interfaceUrl;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateTable(SyncTableDataResBean resBean) {
        String tableName = resBean.getTableName();
        String primaryKey = resBean.getPrimaryKey().toUpperCase();
        Object data = resBean.getPage().getData();
        List listMap = (List)JSONArray.parse((String)JSON.toJSONString((Object)data));
        int i = 0;
        int total = listMap.size();
        for (Map<String, Object> row : listMap) {
            Object primaryKeyValue;
            ++i;
            row = this.translateMapKeyToUpper(row);
            if (logger.isDebugEnabled()) {
                logger.warn("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8868\uff1a[{}]\u5165\u5e93[{}/{}]>>>", new Object[]{tableName, i, total});
            }
            if (null == (primaryKeyValue = row.get(primaryKey))) {
                logger.warn("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8868\uff1a[{}]\u4e3b\u952e:[{}]\u503c\u4e3a\u7a7a\uff0c\u8fc7\u6ee4\u6389", (Object)tableName, (Object)primaryKey);
                continue;
            }
            ArrayList<String> listField = new ArrayList<String>();
            ArrayList<Object> listFieldValue = new ArrayList<Object>();
            this.analysisFieldAndValue(row, listField, listFieldValue);
            String sql = "SELECT COUNT(1) FROM " + tableName + " WHERE " + primaryKey + " = ?";
            Object[] args = new Object[]{primaryKeyValue};
            Integer count = (Integer)this.basicSyncCommonDao.selectOne(sql, args, Integer.class);
            sql = null == count || 0 == count ? this.buildInsertSql(tableName, listField) : this.buildUpdateSql(tableName, primaryKey, listField, listFieldValue);
            this.basicSyncCommonDao.updateBySql(sql, listFieldValue.toArray());
            if (!logger.isDebugEnabled()) continue;
            logger.warn("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e-\u8868\uff1a[{}]\u5165\u5e93[{}/{}]<<<", new Object[]{tableName, i, total});
        }
    }

    private Map<String, Object> translateMapKeyToUpper(Map<String, Object> map) {
        HashMap<String, Object> row = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            row.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        return row;
    }

    private String buildUpdateSql(String tableName, String primaryKey, List<String> listField, List<Object> listFieldValue) {
        StringBuffer fieldUpdate = new StringBuffer();
        for (int i = 0; i < listField.size(); ++i) {
            String fieldName = listField.get(i);
            if (fieldName.equalsIgnoreCase(primaryKey)) {
                Object primaryValue = listFieldValue.remove(i);
                listFieldValue.add(primaryValue);
                continue;
            }
            fieldUpdate.append(fieldName + " = ? ");
            if (i == listField.size() - 1) continue;
            fieldUpdate.append(", ");
        }
        String sql = "UPDATE " + tableName + " SET " + fieldUpdate + " WHERE " + primaryKey + " = ?";
        return sql;
    }

    private String buildInsertSql(String tableName, List<String> listField) {
        StringBuffer fieldInsert = new StringBuffer();
        StringBuffer fieldParam = new StringBuffer();
        for (int i = 0; i < listField.size(); ++i) {
            String fieldName = listField.get(i);
            fieldInsert.append(fieldName);
            fieldParam.append("?");
            if (i == listField.size() - 1) continue;
            fieldInsert.append(", ");
            fieldParam.append(", ");
        }
        String sql = "INSERT INTO " + tableName + " (" + fieldInsert + ") VALUES (" + fieldParam + ")";
        return sql;
    }

    private void analysisFieldAndValue(Map<String, Object> row, List<String> listField, List<Object> listFieldValue) {
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            String field = entry.getKey();
            listField.add(field);
            listFieldValue.add(entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncSyncPersonApp() {
        block21: {
            long timeout = 900L;
            String lockValue = BisRedisUtil.getExpireMillis(timeout);
            boolean lock = false;
            boolean existRedis = null != BisRedisUtil.getStringRedisTemplate();
            String lockKey = RedisKeyConst.getLockSyncSyncPersonAppTableDataKey();
            if (existRedis) {
                lock = BisRedisUtil.tryLock(lockKey, lockValue);
                if (!lock) {
                    logger.error("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
            } else {
                TableDataSyncTask tableDataSyncTask = this;
                synchronized (tableDataSyncTask) {
                    if (this.syncTableDataRunning) {
                        logger.error("\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                        throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u8de8\u7f51\u540c\u6b65\u8868\u6570\u636e\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    }
                    this.syncTableDataRunning = true;
                }
            }
            try {
                int i;
                final String interfaceUrl = this.getInterfaceUrl("/admin/v1/sync/queryPersonAppByAppId.do");
                final PageReqBean pageReqBean = new PageReqBean();
                pageReqBean.setPageSize(2000);
                List<SyncApp> listSyncApp = this.basicSyncAppService.querySyncAppList();
                if (CollectionUtils.isEmpty(listSyncApp)) {
                    return;
                }
                ArrayList<Future> listFuture = new ArrayList<Future>();
                for (i = 0; i < listSyncApp.size(); ++i) {
                    final SyncApp syncApp = listSyncApp.get(i);
                    String appStatus = syncApp.getAppStatus();
                    final String appId = syncApp.getAppId();
                    final String regionalismCode = syncApp.getRegionalismCode();
                    final String networkAreaCode = syncApp.getNetworkAreaCode();
                    if ("0".equals(appStatus)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("\u5e94\u7528\u3010{}\u3011\u5df2\u4e0b\u67b6", (Object)appId);
                        continue;
                    }
                    pageReqBean.setAppId(appId);
                    pageReqBean.setAppRegionalismCode(regionalismCode);
                    Future future = ThreadManager.getInstance().submit(new Callable(){

                        public Object call() throws Exception {
                            TableDataSyncTask.this.pullAndUpdatePersonApp(interfaceUrl, pageReqBean, syncApp, appId, regionalismCode, networkAreaCode);
                            return "1";
                        }
                    }, "tableData");
                    listFuture.add(future);
                }
                if (CollectionUtils.isEmpty(listFuture)) break block21;
                for (i = 0; i < listFuture.size(); ++i) {
                    try {
                        if (logger.isInfoEnabled()) {
                            logger.info("\u540c\u6b65\u4eba\u5458\u4e0e\u5e94\u7528\u6743\u9650\u5173\u7cfb[{}/{}]>>>", (Object)(i + 1), (Object)listFuture.size());
                        }
                        ((Future)listFuture.get(i)).get();
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u4eba\u5458\u4e0e\u5e94\u7528\u6743\u9650\u5173\u7cfb\u5931\u8d25", (Throwable)e);
                    }
                    if (!logger.isInfoEnabled()) continue;
                    logger.info("\u540c\u6b65\u4eba\u5458\u4e0e\u5e94\u7528\u6743\u9650\u5173\u7cfb[{}/{}]<<<", (Object)(i + 1), (Object)listFuture.size());
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u4e0e\u5e94\u7528\u6743\u9650\u5173\u7cfb\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.syncTableDataRunning = false;
                if (existRedis && lock) {
                    BisRedisUtil.releaseLock(lockKey, lockValue);
                }
            }
        }
    }

    private void pullAndUpdatePersonApp(String interfaceUrl, PageReqBean pageReqBean, SyncApp syncApp, String appId, String regionalismCode, String networkAreaCode) {
        ArrayList listPullSyncPersonApp = new ArrayList();
        try {
            List list = null;
            int pageNo = 1;
            String json = null;
            Page page = null;
            long total = 0L;
            int currentSize = 0;
            do {
                json = null;
                page = null;
                currentSize = 0;
                list = null;
                pageReqBean.setPageNo(pageNo);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u4e0e\u5e94\u7528\u6743\u9650\u5173\u7cfb-\u5206\u9875\u62c9\u53d6\u6570\u636epageReqBean:\u3010{}\u3011>>>", (Object)JSON.toJSONString((Object)pageReqBean));
                }
                json = this.interfaceSvcCallService.executeCall(interfaceUrl, pageReqBean);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u4e0e\u5e94\u7528\u6743\u9650\u5173\u7cfb-\u5206\u9875\u62c9\u53d6\u6570\u636epageResBean:\u3010{}\u3011<<<", (Object)json);
                }
                if (!StringUtils.isEmpty((Object)json) && null != (page = (Page)JSON.parseObject((String)json, Page.class)) && page.getTotal() > 0L && (currentSize = (list = (List)page.getRows()).size()) > 0) {
                    total += (long)currentSize;
                    listPullSyncPersonApp.addAll(list);
                }
                ++pageNo;
            } while (!StringUtils.isEmpty((Object)json) && null != page && page.getTotal() > 0L && total <= page.getTotal() && !CollectionUtils.isEmpty((Collection)list) && currentSize == pageReqBean.getPageSize());
            json = JSON.toJSONString(listPullSyncPersonApp);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u4e0e\u5e94\u7528\u6743\u9650\u5173\u7cfb-\u62c9\u53d6\u7684\u6570\u636e\u3010{}\u3011", (Object)json);
            }
            this.saveOrUpdateSyncPersonApp(appId, regionalismCode, networkAreaCode, JSONArray.parseArray((String)json, SyncPersonApp.class));
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u4e0e\u5e94\u7528\u6743\u9650\u5173\u7cfb\u5f02\u5e38,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011", new Object[]{appId, regionalismCode, e});
            throw e;
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateSyncPersonApp(String appId, String appRegionalismCode, String appNetworkAreaCode, List<SyncPersonApp> listPullSyncPersonApp) {
        try {
            int addCount = 0;
            int deleteCount = 0;
            if (CollectionUtils.isEmpty(listPullSyncPersonApp)) {
                logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5220\u9664\u5168\u90e8", (Object)appId, (Object)appRegionalismCode);
                this.personAppSyncDao.deletePersonAppByAppId(appId, appRegionalismCode);
            } else {
                Long count = this.personAppSyncDao.queryPersonAppCountByAppId(appId, appRegionalismCode);
                if (null == count || count < 1L) {
                    for (SyncPersonApp personApp : listPullSyncPersonApp) {
                        personApp.setPersonAppId(IdGeneratorUtil.nextIdNum());
                        personApp.setAppId(appId);
                        personApp.setAppRegionalismCode(appRegionalismCode);
                        personApp.setAppNetworkCode(appNetworkAreaCode);
                        long currentTimeMillis = System.currentTimeMillis();
                        personApp.setCreateTime(currentTimeMillis);
                        personApp.setLastUpdateTime(currentTimeMillis);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u65b0\u589e\u4eba\u5458\u5e94\u7528\u6743\u9650\uff1a\u3010{}\u3011", new Object[]{appId, appRegionalismCode, JSON.toJSONString(listPullSyncPersonApp)});
                    }
                    this.personAppSyncDao.savePersonApp(listPullSyncPersonApp);
                    addCount = listPullSyncPersonApp.size();
                } else {
                    HashMap<Object, SyncPersonApp> mapPullPersonApp = new HashMap<Object, SyncPersonApp>();
                    for (SyncPersonApp syncPersonApp2 : listPullSyncPersonApp) {
                        String key = syncPersonApp2.getPersonId() + syncPersonApp2.getPersonRegionalismCode() + appId + appRegionalismCode;
                        long currentTimeMillis = System.currentTimeMillis();
                        syncPersonApp2.setPersonAppId(IdGeneratorUtil.nextIdNum());
                        syncPersonApp2.setStatus(SyncPersonApp.status_grant_1);
                        syncPersonApp2.setCreateTime(currentTimeMillis);
                        syncPersonApp2.setLastUpdateTime(currentTimeMillis);
                        syncPersonApp2.setAppId(appId);
                        syncPersonApp2.setAppRegionalismCode(appRegionalismCode);
                        syncPersonApp2.setAppNetworkCode(appNetworkAreaCode);
                        mapPullPersonApp.put(key, syncPersonApp2);
                    }
                    List<SyncPersonApp> listDbSyncPersonApp = this.personAppSyncDao.queryPersonAppByAppId(appId, appRegionalismCode);
                    HashMap<String, SyncPersonApp> mapDbSyncPersonApp = new HashMap<String, SyncPersonApp>();
                    for (SyncPersonApp syncPersonApp3 : listDbSyncPersonApp) {
                        String key = syncPersonApp3.getPersonId() + syncPersonApp3.getPersonRegionalismCode() + syncPersonApp3.getAppId() + syncPersonApp3.getAppRegionalismCode();
                        mapDbSyncPersonApp.put(key, syncPersonApp3);
                    }
                    MapDifference difference = Maps.difference(mapPullPersonApp, mapDbSyncPersonApp);
                    Map mapAdd = difference.entriesOnlyOnLeft();
                    Map mapDelete = difference.entriesOnlyOnRight();
                    if (!CollectionUtils.isEmpty((Map)mapAdd)) {
                        ArrayList<SyncPersonApp> add = new ArrayList<SyncPersonApp>(mapAdd.values());
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u65b0\u589e\u4eba\u5458\u5e94\u7528\u6743\u9650\uff1a\u3010{}\u3011", new Object[]{appId, appRegionalismCode, JSON.toJSONString(add)});
                        }
                        this.personAppSyncDao.savePersonApp(add);
                        addCount = mapAdd.size();
                    }
                    if (!CollectionUtils.isEmpty((Map)mapDelete)) {
                        ArrayList delete = new ArrayList(mapDelete.values());
                        if (logger.isDebugEnabled()) {
                            logger.debug("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u5220\u9664\u4eba\u5458\u5e94\u7528\u6743\u9650\uff1a\u3010{}\u3011", new Object[]{appId, appRegionalismCode, JSON.toJSONString(delete)});
                        }
                        List<Long> listPersonAppId = delete.stream().map(syncPersonApp -> syncPersonApp.getPersonAppId()).collect(Collectors.toList());
                        this.personAppSyncDao.deletePersonAppById(listPersonAppId);
                        deleteCount = mapDelete.size();
                    }
                }
                logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761,\u5220\u9664:\u3010{}\u3011\u6761", new Object[]{appId, appRegionalismCode, addCount, deleteCount});
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5f02\u5e38:", new Object[]{appId, appRegionalismCode, e});
            throw e;
        }
    }
}

