/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.util;

public class SleepTimeCalculateUtil {
    public static void calculateSleepTime(SleepTimeCalculateBean sleepTimeCalculateBean) {
        int sleepMaxTime = sleepTimeCalculateBean.getSleepMaxTime();
        int retryMaxNum = sleepTimeCalculateBean.sleepMaxNum;
        int sleepTime = sleepTimeCalculateBean.getSleepTime();
        int sleepRate = sleepTimeCalculateBean.getSleepRate();
        int retryNum = sleepTimeCalculateBean.retryNum;
        if (++retryNum > retryMaxNum) {
            retryNum = 1;
            if ((sleepTime *= sleepRate) > sleepMaxTime) {
                sleepTime = sleepMaxTime;
            }
        }
        sleepTimeCalculateBean.setRetryNum(retryNum);
        sleepTimeCalculateBean.setSleepTime(sleepTime);
    }

    public static SleepTimeCalculateBean getSleepTimeCalculateBean() {
        return SleepTimeCalculateUtil.getSleepTimeCalculateBean(60, 2, 2, 2);
    }

    public static SleepTimeCalculateBean getSleepTimeCalculateBean(int sleepMaxTime, int sleepMaxNum, int sleepTime, int sleepRate) {
        return new SleepTimeCalculateBean(sleepMaxTime, sleepMaxNum, sleepTime, sleepRate);
    }

    public static class SleepTimeCalculateBean {
        public static final int DEFAULT_SLEEP_MAX_TIME = 60;
        public static final int DEFAULT_RETRY_MAX_NUM = 2;
        public static final int DEFAULT_SLEEP_TIME = 2;
        public static final int DEFAULT_SLEEP_RATE = 2;
        private int sleepMaxTime;
        private int sleepMaxNum;
        private int sleepTime;
        private int sleepRate;
        private int retryNum;

        public SleepTimeCalculateBean() {
            this.sleepMaxTime = 60;
            this.sleepMaxNum = 2;
            this.sleepTime = 2;
            this.sleepRate = 2;
            this.retryNum = 0;
        }

        public SleepTimeCalculateBean(int sleepMaxTime, int sleepMaxNum, int sleepFirstTime, int sleepRate) {
            this.sleepMaxTime = sleepMaxTime > 0 ? sleepMaxTime : 60;
            this.sleepMaxNum = sleepMaxNum > 0 ? sleepMaxNum : 2;
            this.sleepTime = sleepFirstTime > 0 ? sleepFirstTime : 2;
            this.sleepRate = sleepRate > 0 ? sleepRate : 2;
            this.retryNum = 0;
        }

        public int getSleepMaxTime() {
            return this.sleepMaxTime;
        }

        public void setSleepMaxTime(int sleepMaxTime) {
            this.sleepMaxTime = sleepMaxTime;
        }

        public int getSleepMaxNum() {
            return this.sleepMaxNum;
        }

        public void setSleepMaxNum(int sleepMaxNum) {
            this.sleepMaxNum = sleepMaxNum;
        }

        public int getSleepTime() {
            return this.sleepTime;
        }

        public void setSleepTime(int sleepTime) {
            this.sleepTime = sleepTime;
        }

        public int getRetryNum() {
            return this.retryNum;
        }

        public void setRetryNum(int retryNum) {
            this.retryNum = retryNum;
        }

        public int getSleepRate() {
            return this.sleepRate;
        }

        public void setSleepRate(int sleepRate) {
            this.sleepRate = sleepRate;
        }
    }
}

