create table t_sync_service_interface
(
  interface_id        VARCHAR2(32) not null,
  interface_code     VARCHAR2(64),
  interface_name     VARCHAR2(128),
  interface_url     VARCHAR2(2048),
  network_area_code     VARCHAR2(1),
  regionalism_code     VARCHAR2(32),
  version     NUMBER(11),
  version_note     VARCHAR2(4000),
  status     NUMBER(1) DEFAULT 1,
  create_time     NUMBER(19),
  update_time     NUMBER(19),
  service_id     VARCHAR2(32),
  service_name     VARCHAR2(500),
  public_key     VARCHAR2(4000),
  service_type     VARCHAR2(100)
);
comment on table t_sync_service_interface is '全国服务接口信息表';
comment on column t_sync_service_interface.interface_id is '接口id，主键';
comment on column t_sync_service_interface.interface_code is '接口代码';
comment on column t_sync_service_interface.interface_name is '接口名称';
comment on column t_sync_service_interface.interface_url is '接口地址';
comment on column t_sync_service_interface.network_area_code is '服务部署网络区域代码 1 互联网, 2 公安移动信息网, 3 公安网, 4 视频专网';
comment on column t_sync_service_interface.regionalism_code is '所属行政区划编码';
comment on column t_sync_service_interface.version is '接口版本号';
comment on column t_sync_service_interface.version_note is '接口版本说明';
comment on column t_sync_service_interface.status is '状态位标识，1：正常，0：禁用';
comment on column t_sync_service_interface.create_time is '创建时间';
comment on column t_sync_service_interface.update_time is '更新时间';
comment on column t_sync_service_interface.service_id is '服务id';
comment on column t_sync_service_interface.service_name is '服务名称';
comment on column t_sync_service_interface.public_key is '服务公钥信息';
comment on column t_sync_service_interface.service_type is '服务类型';
alter table t_sync_service_interface add primary key (interface_id);