/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.xdja.sync.bean.SyncDeviceNetworkGroup;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.DeviceNetworkGroupSyncDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceNetworkGroupSyncDaoImpl
implements DeviceNetworkGroupSyncDao {
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public void deleteDeviceNetworkGroupByDeviceId(String deviceId) {
        String sql = "DELETE FROM T_SYNC_DEVICE_NETWORK WHERE DEVICE_ID = ?";
        Object[] args = new Object[]{deviceId};
        this.basicSyncCommonDao.updateBySql(sql, args);
    }

    @Override
    public boolean existDeviceNetworkGroup(String deviceId, String networkGroupId) {
        String sql = "SELECT COUNT(1) FROM T_SYNC_DEVICE_NETWORK WHERE DEVICE_ID = ? AND NET_STRATEGY_ID = ?";
        Object[] args = new Object[]{deviceId, networkGroupId};
        Number count = (Number)this.basicSyncCommonDao.selectOne(sql, args, Integer.class);
        return null != count && count.intValue() != 0;
    }

    @Override
    public SyncDeviceNetworkGroup getDeviceNetworkGroup(String deviceId, String networkGroupId) {
        String sql = "SELECT * FROM T_SYNC_DEVICE_NETWORK WHERE DEVICE_ID = ? AND NET_STRATEGY_ID = ?";
        Object[] args = new Object[]{deviceId, networkGroupId};
        SyncDeviceNetworkGroup count = (SyncDeviceNetworkGroup)this.basicSyncCommonDao.selectOne(sql, args, SyncDeviceNetworkGroup.class);
        return count;
    }

    @Override
    public List<SyncDeviceNetworkGroup> getNetworkGroupByDeviceId(String deviceId) {
        return this.getNetworkGroupByDeviceId(deviceId, null);
    }

    @Override
    public List<SyncDeviceNetworkGroup> getNetworkGroupByDeviceId(String deviceId, Integer status) {
        String sql = "SELECT * FROM T_SYNC_DEVICE_NETWORK WHERE DEVICE_ID = ?";
        Object[] args = new Object[]{deviceId};
        if (null != status) {
            sql = sql + " AND STATUS = ? ";
            args = new Object[]{deviceId, status};
        }
        return this.basicSyncCommonDao.selectList(sql, args, SyncDeviceNetworkGroup.class);
    }

    @Override
    public void saveSyncNetworkGroup(SyncDeviceNetworkGroup syncDeviceNetworkGroup) {
        this.saveSyncNetworkGroup(Arrays.asList(syncDeviceNetworkGroup));
    }

    @Override
    public void saveSyncNetworkGroup(List<SyncDeviceNetworkGroup> listSyncDeviceNetworkGroup) {
        String sql = "INSERT INTO T_SYNC_DEVICE_NETWORK (ID, DEVICE_ID, NET_CONTROLLER_ID, NET_STRATEGY_ID, NET_STRATEGY_NAME, NET_STRATEGY_LEVEL, CREATE_TIME, STATUS)  VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        Object[] args = null;
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (SyncDeviceNetworkGroup syncDeviceNetworkGroup : listSyncDeviceNetworkGroup) {
            args = new Object[]{syncDeviceNetworkGroup.getId(), syncDeviceNetworkGroup.getDeviceId(), syncDeviceNetworkGroup.getNetControllerId(), syncDeviceNetworkGroup.getNetStrategyId(), syncDeviceNetworkGroup.getNetStrategyName(), syncDeviceNetworkGroup.getNetStrategyLevel(), syncDeviceNetworkGroup.getCreateTime(), syncDeviceNetworkGroup.getStatus()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public void deleteSyncNetworkGroup(List<SyncDeviceNetworkGroup> listDeleteDevice) {
        for (SyncDeviceNetworkGroup syncDeviceNetworkGroup : listDeleteDevice) {
            this.deleteDeviceNetworkGroupByDeviceId(syncDeviceNetworkGroup.getId());
        }
    }

    @Override
    public Long getMaxUpdateTime() {
        String sql = "SELECT MAX(CREATE_TIME) FROM T_SYNC_DEVICE_NETWORK";
        Object[] args = new Object[]{};
        return (Long)this.basicSyncCommonDao.selectOne(sql, args, Long.class);
    }

    @Override
    public void updateSyncNetworkGroup(List<SyncDeviceNetworkGroup> listUpdateSyncDeviceNetworkGroup) {
        String sql = "UPDATE T_SYNC_DEVICE_NETWORK  SET  DEVICE_ID = ?, NET_CONTROLLER_ID = ?, NET_STRATEGY_ID = ?, NET_STRATEGY_NAME = ?, NET_STRATEGY_LEVEL = ?, CREATE_TIME = ?, STATUS = ?  WHERE ID = ? ";
        Object[] args = null;
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (SyncDeviceNetworkGroup syncDeviceNetworkGroup : listUpdateSyncDeviceNetworkGroup) {
            args = new Object[]{syncDeviceNetworkGroup.getDeviceId(), syncDeviceNetworkGroup.getNetControllerId(), syncDeviceNetworkGroup.getNetStrategyId(), syncDeviceNetworkGroup.getNetStrategyName(), syncDeviceNetworkGroup.getNetStrategyLevel(), syncDeviceNetworkGroup.getCreateTime(), syncDeviceNetworkGroup.getStatus(), syncDeviceNetworkGroup.getId()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }

    @Override
    public void updateSyncNetworkGroup(SyncDeviceNetworkGroup syncDeviceNetworkGroup) {
        this.updateSyncNetworkGroup(Arrays.asList(syncDeviceNetworkGroup));
    }

    @Override
    public List<SyncDeviceNetworkGroup> queryDeviceNetworkGroupList(Long updateTime, Page page) {
        String sql = "SELECT * FROM T_SYNC_DEVICE_NETWORK WHERE DEVICE_ID = ?";
        Object[] args = new Object[]{};
        if (null != updateTime) {
            sql = sql + " AND CREATE_TIME > ? ";
            args = new Object[]{updateTime};
        }
        return this.basicSyncCommonDao.selectList(sql, args, SyncDeviceNetworkGroup.class, page);
    }
}

