/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.common;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class AbstractBaseLocalCache<K, V> {
    private LoadingCache<K, V> cache;

    public AbstractBaseLocalCache() {
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<K, V>(){

            public V load(K k) throws Exception {
                return AbstractBaseLocalCache.this.loadData(k);
            }
        });
    }

    public AbstractBaseLocalCache(long duration, TimeUnit timeUtil) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(duration, timeUtil).build(new CacheLoader<K, V>(){

            public V load(K k) throws Exception {
                return AbstractBaseLocalCache.this.loadData(k);
            }
        });
    }

    public AbstractBaseLocalCache(long maxSize) {
        this.cache = CacheBuilder.newBuilder().maximumSize(maxSize).build(new CacheLoader<K, V>(){

            public V load(K k) throws Exception {
                return AbstractBaseLocalCache.this.loadData(k);
            }
        });
    }

    public AbstractBaseLocalCache(long maxWeight, Weigher<K, V> weigher) {
        this.cache = CacheBuilder.newBuilder().maximumWeight(maxWeight).weigher(weigher).build(new CacheLoader<K, V>(){

            public V load(K k) throws Exception {
                return AbstractBaseLocalCache.this.loadData(k);
            }
        });
    }

    protected abstract V loadData(K var1);

    public V getCache(K param) {
        Object v = null;
        try {
            v = this.cache.get(param);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (V)v;
    }

    public void put(K k, V v) {
        this.cache.put(k, v);
    }

    public void invalidate(K k) {
        this.cache.invalidate(k);
    }

    public void invalidateAll(List<K> keys) {
        this.cache.invalidateAll(keys);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public void refresh(K k) {
        this.cache.refresh(k);
    }
}

