/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.handler;

import com.xdja.common.BasicSystemInitUtil;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.bean.common.DbType;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.enums.SystemEnum;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class BasicLogClearHandler {
    private static final Logger logger = LoggerFactory.getLogger(BasicLogClearHandler.class);
    @Autowired
    private Environment environment;
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private BasicSystemInitUtil basicSystemInitUtil;
    private static int maxDeleteNum = 5000;
    private static int batchDeleteNum = 1000;

    public void deleteLog() {
        String logSaveDay = this.environment.getProperty("log.save.day", "7");
        if (StringUtils.isEmpty((Object)logSaveDay)) {
            return;
        }
        String applicationName = this.basicSystemInitUtil.getSystemCode();
        String deleteLogTable = this.environment.getProperty("log.delete.table", Consts.getLogTable(applicationName));
        if (StringUtils.isEmpty((Object)deleteLogTable)) {
            return;
        }
        String[] ary = deleteLogTable.split(",");
        String sql = "";
        for (String tableName : ary) {
            int total;
            Object obj;
            String where = this.buildWhereSql(applicationName, tableName, Integer.parseInt(logSaveDay));
            sql = "SELECT COUNT(*) FROM " + tableName;
            if (!StringUtils.isEmpty((Object)where)) {
                sql = sql + where;
            }
            if (null == (obj = this.basicSyncCommonDao.selectOne(sql, null, Integer.class)) || (total = ((Integer)obj).intValue()) < 1) continue;
            if (total > maxDeleteNum && DbType.MYSQL == Consts.dbType) {
                where = where + " LIMIT " + batchDeleteNum;
                sql = "DELETE FROM " + tableName + where;
                int totalPage = (total + batchDeleteNum - 1) / batchDeleteNum;
                for (int i = 0; i < totalPage; ++i) {
                    this.executeSql(sql);
                }
                continue;
            }
            sql = "DELETE FROM " + tableName + where;
            this.executeSql(sql);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int executeSql(String sql) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u6267\u884c\u6e05\u9664\u65e5\u5fd7\u8868\u8bb0\u5f55sql:\u3010{}\u3011", (Object)sql);
            }
            return this.basicSyncCommonDao.updateBySql(sql, null);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u6e05\u9664\u65e5\u5fd7\u8868\u8bb0\u5f55sql:\u3010{}\u3011\u5931\u8d25\uff1a", (Object)sql, (Object)e);
            return 0;
        }
    }

    public void clearLogField() {
        String logSaveDay = this.environment.getProperty("log.tableField.save.day", "7");
        if (StringUtils.isEmpty((Object)logSaveDay)) {
            return;
        }
        String applicationName = this.basicSystemInitUtil.getSystemCode();
        String clearLogField = this.environment.getProperty("log.tableField.clear.field", "");
        if (StringUtils.isEmpty((Object)clearLogField)) {
            String[] tableNames;
            String logTable = Consts.getLogTable(applicationName);
            if (StringUtils.isEmpty((Object)logTable)) {
                return;
            }
            for (String tableName : tableNames = logTable.split(",")) {
                String logTableField = Consts.getLogTableField(tableName);
                if (StringUtils.isEmpty((Object)logTableField)) continue;
                clearLogField = clearLogField + tableName + ":" + logTableField + ";";
            }
        }
        if (StringUtils.isEmpty((Object)clearLogField)) {
            return;
        }
        long timeInMillis = this.getTimeInMillis(Integer.parseInt(logSaveDay));
        String[] aryTableField = clearLogField.split(";");
        if (null != aryTableField && aryTableField.length > 0) {
            for (String tableField : aryTableField) {
                String[] split = tableField.split(":");
                String tableName = split[0];
                String fields = split[1];
                if (StringUtils.isEmpty((Object)tableName) || StringUtils.isEmpty((Object)fields)) continue;
                String sql = "SELECT MAX(" + this.getTimeField(applicationName, tableName) + ")  FROM " + tableName + " WHERE ";
                String[] aryField = fields.split(",");
                for (int i = 0; i < aryField.length; ++i) {
                    String fieldName = aryField[i];
                    sql = sql + fieldName + " IS NOT NULL ";
                    if (i == aryField.length - 1) continue;
                    sql = sql + " OR ";
                }
                Long maxTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
                if (null == maxTime || maxTime >= timeInMillis) continue;
                sql = "UPDATE " + tableName + " SET ";
                for (String fieldName : aryField) {
                    sql = sql + fieldName + " = '',";
                }
                sql = sql.substring(0, sql.length() - 1);
                sql = sql + " WHERE " + this.getTimeField(applicationName, tableName) + " < " + timeInMillis;
                if (logger.isDebugEnabled()) {
                    logger.debug("{}\u5220\u9664\u65e5\u5fd7\u8868\u5b57\u6bb5sql:\u3010{}\u3011", (Object)applicationName, (Object)sql);
                }
                this.executeSql(sql);
            }
        }
    }

    private String buildWhereSql(String applicationName, String tableName, int logSaveDay) {
        long timeInMillis = this.getTimeInMillis(logSaveDay);
        String timeField = this.getTimeField(applicationName, tableName);
        return " WHERE " + timeField + " <= " + timeInMillis;
    }

    private long getTimeInMillis(int saveLogDay) {
        GregorianCalendar today = new GregorianCalendar(TimeZone.getDefault());
        today.setTimeInMillis(System.currentTimeMillis());
        ((Calendar)today).add(5, -saveLogDay);
        long timeInMillis = today.getTimeInMillis();
        return timeInMillis;
    }

    private String getTimeField(String applicationName, String tableName) {
        String time = " CREATE_TIME ";
        if ((applicationName.equalsIgnoreCase(SystemEnum.UAA.getCode()) || applicationName.equalsIgnoreCase(SystemEnum.UAAS_API.getCode()) || applicationName.equalsIgnoreCase(SystemEnum.UAAP_WEB.getCode())) && ("t_uaa_user_log".equals(tableName) || "t_uaa_server_app_log".equals(tableName) || "t_uaa_device_log".equals(tableName) || "t_uaa_client_app_log".equals(tableName))) {
            time = " TIME ";
        }
        return time;
    }
}

