/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.smcs.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.smcs.bean.policefirst.AppCallResourceReqBean;
import com.xdja.smcs.bean.policefirst.AppResourceReqBean;
import com.xdja.smcs.bean.policefirst.DeviceAddAppReqBean;
import com.xdja.smcs.bean.policefirst.PoliceFirstResBean;
import com.xdja.smcs.bean.policefirst.ResServiceReqBean;
import com.xdja.smcs.bean.policefirst.UserAppReqBean;
import com.xdja.smcs.service.BasicPullSmcsService;
import com.xdja.smcs.util.SmcsPlatformUtil;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.SyncPersonApp;
import com.xdja.sync.bean.SyncResource;
import com.xdja.sync.util.HttpUtils;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="policeOneBasicPullSmcsService")
public class PoliceOneBasicPullSmcsServiceImpl
implements BasicPullSmcsService {
    private static final Logger logger = LoggerFactory.getLogger(PoliceOneBasicPullSmcsServiceImpl.class);
    @Autowired
    private SmcsPlatformUtil smcsPlatformUtil;
    private CompletionService completionService = null;

    private CompletionService getCompletionService() {
        if ("on".equals(this.smcsPlatformUtil.getSmcsSwitch()) && this.completionService == null) {
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 10, 2L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024));
            this.completionService = new ExecutorCompletionService(executorService);
        }
        return this.completionService;
    }

    private PoliceFirstResBean execute(String interfaceUrl, String protocolType, Object bodyParam) {
        Future<Object> future = this.getCompletionService().submit(() -> {
            PoliceFirstResBean policeFirstResBean = null;
            String url = "";
            try {
                url = this.smcsPlatformUtil.getSmcsUrl() + interfaceUrl;
                if (logger.isDebugEnabled()) {
                    logger.debug("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7>>>url:\u3010{}\u3011, params\uff1a\u3010{}\u3011", (Object)url, (Object)JSON.toJSONString((Object)bodyParam));
                }
                String result = null;
                if ("POST_JSON".equals(protocolType)) {
                    result = HttpUtils.createPost(url).addJsonBody(bodyParam).execute().getString();
                } else if ("GET".equals(protocolType)) {
                    result = HttpUtils.createGet(url).execute().getString();
                } else if ("PUT".equals(protocolType)) {
                    result = HttpUtils.createPut(url).addJsonBody(bodyParam).execute().getString();
                } else if ("DELETE".equals(protocolType)) {
                    result = HttpUtils.createDelete(url).addJsonBody(bodyParam).execute().getString();
                }
                policeFirstResBean = (PoliceFirstResBean)JSON.parseObject((String)result, PoliceFirstResBean.class);
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u516c\u5b89\u90e8\u4e00\u6240\u96c6\u4e2d\u7ba1\u63a7\u4e0a\u62a5\u63a5\u53e3\u5931\u8d25\uff1a", (Throwable)e);
            }
            if (logger.isDebugEnabled() && logger.isDebugEnabled()) {
                logger.debug("\u4e0a\u62a5\u96c6\u4e2d\u7ba1\u63a7<<<url:\u3010{}\u3011, result\uff1a\u3010{}\u3011", (Object)url, (Object)JSON.toJSONString(policeFirstResBean));
            }
            return policeFirstResBean;
        });
        return null;
    }

    @Override
    public void pullAddAppToSmcs(List<SyncApp> listApp) {
        String addUrl = "/cmc/api/v1/mdm/devices/apps";
        if (CollectionUtils.isEmpty(listApp)) {
            return;
        }
        DeviceAddAppReqBean deviceAddAppReqBean = null;
        for (SyncApp syncApp : listApp) {
            deviceAddAppReqBean = new DeviceAddAppReqBean();
            deviceAddAppReqBean.setTerminalId(syncApp.getAppId());
            deviceAddAppReqBean.setPackageName(syncApp.getAppPackage());
            deviceAddAppReqBean.setAppName(syncApp.getAppName());
            deviceAddAppReqBean.setVersionName(syncApp.getAppVersion());
            deviceAddAppReqBean.setVersionCode(syncApp.getVersionCode());
            deviceAddAppReqBean.setAppSize(syncApp.getAppFileSize());
            deviceAddAppReqBean.setFirstInstallTime(syncApp.getCreateTime());
            this.execute(addUrl, "POST_JSON", deviceAddAppReqBean);
        }
    }

    @Override
    public void pullUpdateAppToSmcs(List<SyncApp> listApp) {
        String updateUrl = "/cmc/api/v1/mdm/devices/apps/{terminalId}/{packageName}";
        DeviceAddAppReqBean deviceAddAppReqBean = null;
        for (SyncApp syncApp : listApp) {
            String appStatus = syncApp.getAppStatus();
            if ("0".equals(appStatus)) continue;
            deviceAddAppReqBean = new DeviceAddAppReqBean();
            deviceAddAppReqBean.setTerminalId(syncApp.getAppId());
            deviceAddAppReqBean.setAppName(syncApp.getAppName());
            deviceAddAppReqBean.setVersionName(syncApp.getAppVersion());
            deviceAddAppReqBean.setVersionCode(syncApp.getVersionCode());
            deviceAddAppReqBean.setAppSize(syncApp.getAppFileSize());
            deviceAddAppReqBean.setFirstInstallTime(syncApp.getCreateTime());
            updateUrl = updateUrl.replace("{terminalId}", syncApp.getAppId()).replace("{packageName}", syncApp.getAppPackage());
            this.execute(updateUrl, "POST_JSON", deviceAddAppReqBean);
        }
    }

    @Override
    public void pullDeleteAppToSmcs(List<SyncApp> listApp) {
        String deleteUrl = "/cmc/api/v1/mdm/devices/apps/{terminalId}/{packageName}";
        for (SyncApp syncApp : listApp) {
            String appStatus = syncApp.getAppStatus();
            if (!"0".equals(appStatus)) continue;
            String deleteUrl2 = deleteUrl.replace("{terminalId}", syncApp.getAppId()).replace("{packageName}", syncApp.getAppPackage());
            this.execute(deleteUrl2, "DELETE", null);
        }
    }

    @Override
    public void pullAddResourceToSmcs(List<SyncResource> listAddSyncResource) {
        if (CollectionUtils.isEmpty(listAddSyncResource)) {
            return;
        }
        String url = "/cmc/api/v1/mr/resservices";
        ResServiceReqBean resServiceReqBean = null;
        for (SyncResource syncResource : listAddSyncResource) {
            resServiceReqBean = new ResServiceReqBean();
            resServiceReqBean.setResServiceId(syncResource.getResourceId());
            resServiceReqBean.setResServiceName(syncResource.getResourceName());
            resServiceReqBean.setType(Integer.parseInt(syncResource.getResourceServiceType().substring(0, 1)));
            resServiceReqBean.setServiceUrl(syncResource.getResourceInterfaceAddress());
            resServiceReqBean.setServiceType(syncResource.getResourceType());
            resServiceReqBean.setStatus(syncResource.getStatus() == 0 ? 2 : syncResource.getStatus());
            resServiceReqBean.setCreateTime(syncResource.getRegisterTime());
            resServiceReqBean.setPublishTime(syncResource.getApproveTime());
            resServiceReqBean.setUpdateTime(syncResource.getUpdateTime());
            resServiceReqBean.setVersion("1.0");
            resServiceReqBean.setVendor(syncResource.getRegionalismCode());
            this.execute(url, "POST_JSON", resServiceReqBean);
        }
    }

    @Override
    public void pullUpdateResourceToSmcs(List<SyncResource> listAddSyncResource) {
        if (CollectionUtils.isEmpty(listAddSyncResource)) {
            return;
        }
        String url = "/cmc/api/v1/mr/resservice/{resServiceId}";
        ResServiceReqBean resServiceReqBean = null;
        for (SyncResource syncResource : listAddSyncResource) {
            resServiceReqBean = new ResServiceReqBean();
            resServiceReqBean.setResServiceName(syncResource.getResourceName());
            resServiceReqBean.setType(Integer.parseInt(syncResource.getResourceServiceType().substring(0, 1)));
            resServiceReqBean.setDescription(syncResource.getResourceDescription());
            resServiceReqBean.setServiceUrl(syncResource.getResourceInterfaceAddress());
            resServiceReqBean.setServiceType(syncResource.getResourceType());
            resServiceReqBean.setStatus(syncResource.getStatus() == 0 ? 2 : syncResource.getStatus());
            resServiceReqBean.setCreateTime(syncResource.getRegisterTime());
            resServiceReqBean.setPublishTime(syncResource.getApproveTime());
            resServiceReqBean.setUpdateTime(syncResource.getUpdateTime());
            resServiceReqBean.setVersion("1.0");
            resServiceReqBean.setVendor(syncResource.getRegionalismCode());
            String url2 = url.replace("{resServiceId}", syncResource.getResourceId());
            this.execute(url2, "PUT", resServiceReqBean);
        }
    }

    @Override
    public void pullDeleteResourceToSmcs(List<SyncResource> listAddSyncResource) {
        if (CollectionUtils.isEmpty(listAddSyncResource)) {
            return;
        }
        String url = "/cmc/api/v1/mr/resservice/{resServiceId}";
        for (SyncResource syncResource : listAddSyncResource) {
            String url2 = url.replace("{resServiceId}", syncResource.getResourceId());
            this.execute(url2, "DELETE", null);
        }
    }

    @Override
    public void pullAddAppResourceToSmcs(List<SyncAppResource> listAddSyncAppResource) {
        if (CollectionUtils.isEmpty(listAddSyncAppResource)) {
            return;
        }
        String url = "/cmc/api/v1/mr/resservice/app_authorization";
        for (SyncAppResource syncResource : listAddSyncAppResource) {
            AppResourceReqBean appResourceReqBean = new AppResourceReqBean();
            appResourceReqBean.setResServiceId(syncResource.getResourceId());
            appResourceReqBean.setAppId(syncResource.getAppId());
            appResourceReqBean.setAuthoriserUserId("0");
            appResourceReqBean.setAuthorizationTime(syncResource.getCreateTime());
            this.execute(url, "POST_JSON", appResourceReqBean);
        }
    }

    @Override
    public void pullDeleteAppResourceToSmcs(List<SyncAppResource> listAddSyncAppResource) {
        if (CollectionUtils.isEmpty(listAddSyncAppResource)) {
            return;
        }
        String url = "/cmc/api/v1/mr/resservice/app_authorization";
        for (SyncAppResource syncResource : listAddSyncAppResource) {
            AppResourceReqBean appResourceReqBean = new AppResourceReqBean();
            appResourceReqBean.setResServiceId(syncResource.getResourceId());
            appResourceReqBean.setAppId(syncResource.getAppId());
            this.execute(url, "DELETE", appResourceReqBean);
        }
    }

    @Override
    public void pullAddPersonAppToSmcs(List<SyncPersonApp> listAddSyncPersonApp) {
        if (CollectionUtils.isEmpty(listAddSyncPersonApp)) {
            return;
        }
        String url = "/cmc/api/v1/pm/auth";
        UserAppReqBean userAppReqBean = null;
        for (SyncPersonApp syncPersonApp : listAddSyncPersonApp) {
            userAppReqBean = new UserAppReqBean();
            userAppReqBean.setAppId(syncPersonApp.getAppId());
            userAppReqBean.setObjectId(syncPersonApp.getPersonId());
            userAppReqBean.setObjectType(0);
            userAppReqBean.setAuthoriserUserId("0");
            userAppReqBean.setAuthorizationTime(syncPersonApp.getCreateTime());
            this.execute(url, "POST_JSON", userAppReqBean);
        }
    }

    @Override
    public void pullDeletePersonAppToSmcs(List<SyncPersonApp> listAddSyncPersonApp) {
        if (CollectionUtils.isEmpty(listAddSyncPersonApp)) {
            return;
        }
        String url = "/cmc/api/v1/pm/auth";
        UserAppReqBean userAppReqBean = null;
        for (SyncPersonApp syncPersonApp : listAddSyncPersonApp) {
            userAppReqBean = new UserAppReqBean();
            userAppReqBean.setAppId(syncPersonApp.getAppId());
            userAppReqBean.setObjectId(syncPersonApp.getPersonId());
            userAppReqBean.setObjectType(0);
            this.execute(url, "DELETE", userAppReqBean);
        }
    }

    @Override
    public void pullLogCacheBeanToSmcs(LogCacheBean logCacheBean) {
        if (null == logCacheBean) {
            return;
        }
        String url = "";
        Integer logType = logCacheBean.getLogType();
        if (4201 == logType) {
            String requestBody = logCacheBean.getRequestBody();
            if (StringUtils.isEmpty((Object)requestBody)) {
                return;
            }
            url = "/cmc/api/v1/mr/resservice/{resServiceId}/logs";
            JSONObject jsonObject = JSON.parseObject((String)requestBody);
            String appId = jsonObject.getString("appId");
            String resourceId = jsonObject.getString("resourceId");
            Integer status = jsonObject.getInteger("status");
            Long createTime = logCacheBean.getCreateTime();
            AppCallResourceReqBean appCallResourceReqBean = new AppCallResourceReqBean();
            appCallResourceReqBean.setAccessTime(createTime);
            appCallResourceReqBean.setAppId(appId);
            appCallResourceReqBean.setState(0 == status ? 1 : 3);
            this.execute(url.replace("{resServiceId}", resourceId), "POST_JSON", appCallResourceReqBean);
        }
    }
}

