/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.xdja.sync.bean.SyncPersonDevice;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.dao.PersonDeviceSyncDao;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PersonDeviceSyncDaoImpl
implements PersonDeviceSyncDao {
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;

    @Override
    public void deletePersonDeviceByPersonId(String personId) {
        String sql = "DELETE FROM t_sync_person_device WHERE person_id = ?";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{personId});
    }

    @Override
    public SyncPersonDevice getPersonDevice(String personId, String deviceId) {
        return this.getPersonDevice(personId, deviceId, null);
    }

    @Override
    public SyncPersonDevice getPersonDevice(String personId, String deviceId, Integer status) {
        List<?> list;
        String sql = "SELECT * FROM t_sync_person_device WHERE person_id = ? AND device_id = ? ";
        Object[] args = new Object[]{personId, deviceId};
        if (null != status) {
            sql = sql + " AND status = ? ";
            args = new Object[]{personId, deviceId, status};
        }
        return CollectionUtils.isEmpty(list = this.basicSyncCommonDao.selectList(sql, args, SyncPersonDevice.class)) ? null : (SyncPersonDevice)list.get(0);
    }

    @Override
    public boolean existPersonDevice(String personId, String deviceId) {
        return this.existPersonDevice(personId, deviceId, null);
    }

    @Override
    public boolean existPersonOrDevice(String personId, String deviceId) {
        return this.existPersonOrDevice(personId, deviceId, null);
    }

    @Override
    public boolean existPersonDevice(String personId, String deviceId, Integer status) {
        Integer count;
        String sql = "SELECT count(1) FROM t_sync_person_device WHERE person_id = ? AND device_id = ? ";
        Object[] args = new Object[]{personId, deviceId};
        if (null != status) {
            sql = sql + " AND status = ? ";
            args = new Object[]{personId, deviceId, status};
        }
        return null != (count = (Integer)this.basicSyncCommonDao.selectOne(sql, args, Integer.class)) && count != 0;
    }

    @Override
    public boolean existPersonOrDevice(String personId, String deviceId, Integer status) {
        Integer count;
        String sql = "SELECT count(1) FROM t_sync_person_device WHERE (person_id = ? OR device_id = ?) ";
        Object[] args = new Object[]{personId, deviceId};
        if (null != status) {
            sql = sql + " AND status = ? ";
            args = new Object[]{personId, deviceId, status};
        }
        return null != (count = (Integer)this.basicSyncCommonDao.selectOne(sql, args, Integer.class)) && count != 0;
    }

    @Override
    public List<SyncPersonDevice> getPersonDeviceByPersonId(String personId) {
        String sql = "SELECT * FROM t_sync_person_device WHERE person_id = ?";
        return this.basicSyncCommonDao.selectList(sql, new Object[]{personId}, SyncPersonDevice.class);
    }

    @Override
    public List<SyncPersonDevice> getPersonDeviceByPersonId(String personId, Integer status) {
        String sql = "SELECT * FROM t_sync_person_device WHERE person_id = ?";
        Object[] args = new Object[]{personId};
        if (null != status) {
            sql = sql + " AND status = ? ";
            args = new Object[]{personId, status};
        }
        return this.basicSyncCommonDao.selectList(sql, args, SyncPersonDevice.class);
    }

    @Override
    public void saveSyncPersonDevice(SyncPersonDevice syncPersonDevice) {
        this.saveSyncPersonDevice(Arrays.asList(syncPersonDevice));
    }

    @Override
    public void saveSyncPersonDevice(List<SyncPersonDevice> listSyncPersonDevice) {
        String sql = "INSERT INTO t_sync_person_device( person_device_id, person_id, device_id, PERSON_REGIONALISM_CODE, create_time, status)  values (?, ?, ?, ?, ?, ?) ";
        ArrayList<Object[]> listArgs = new ArrayList<Object[]>();
        Object[] args = null;
        for (SyncPersonDevice syncPersonDevice : listSyncPersonDevice) {
            args = new Object[]{syncPersonDevice.getPersonDeviceId(), syncPersonDevice.getPersonId(), syncPersonDevice.getDeviceId(), syncPersonDevice.getPersonRegionalismCode(), syncPersonDevice.getCreateTime(), syncPersonDevice.getStatus()};
            listArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, listArgs);
    }

    @Override
    public void deleteSyncPersonDevice(List<SyncPersonDevice> listDeleteDevice) {
        String sql = "DELETE FROM t_sync_person_device WHERE person_device_id = ?";
        for (SyncPersonDevice syncPersonDevice : listDeleteDevice) {
            this.basicSyncCommonDao.updateBySql(sql, new Object[]{syncPersonDevice.getPersonDeviceId()});
        }
    }

    @Override
    public void updateSyncPersonDeviceStatus(SyncPersonDevice syncPersonDevice) {
        String sql = "UPDATE t_sync_person_device SET STATUS = ?, create_time = ? WHERE person_device_id = ?";
        this.basicSyncCommonDao.updateBySql(sql, new Object[]{syncPersonDevice.getStatus(), syncPersonDevice.getCreateTime(), syncPersonDevice.getPersonDeviceId()});
    }

    @Override
    public void batchUpdateSyncPersonDeviceStatus(List<SyncPersonDevice> listDeleteDevice) {
        for (SyncPersonDevice syncPersonDevice : listDeleteDevice) {
            this.updateSyncPersonDeviceStatus(syncPersonDevice);
        }
    }

    @Override
    public Long querySyncPersonDeviceLastUpdateTime() {
        String sql = "SELECT max(create_time) FROM t_sync_person_device";
        Long lastUpdateTime = (Long)this.basicSyncCommonDao.selectOne(sql, null, Long.class);
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        return lastUpdateTime;
    }

    @Override
    public void updateSyncPersonDeviceStatusDelete(List<SyncPersonDevice> listDeleteDevice) {
        String sql = "UPDATE t_sync_person_device SET STATUS = ?, create_time = ? WHERE person_device_id = ?";
        for (SyncPersonDevice syncPersonDevice : listDeleteDevice) {
            this.basicSyncCommonDao.updateBySql(sql, new Object[]{SyncPersonDevice.status_revoke_2, System.currentTimeMillis(), syncPersonDevice.getPersonDeviceId()});
        }
    }

    @Override
    public Long getMaxUpdateTime() {
        String sql = "SELECT MAX(CREATE_TIME) FROM T_SYNC_PERSON_DEVICE";
        Object[] args = new Object[]{};
        return (Long)this.basicSyncCommonDao.selectOne(sql, args, Long.class);
    }

    @Override
    public List<String> getExistDeviceIdAndPersonIds(List<SyncPersonDevice> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT CONCAT(device_id,person_id) FROM T_SYNC_PERSON_DEVICE WHERE (device_id,person_id) IN (");
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            SyncPersonDevice item = list.get(i);
            params.add(item.getDeviceId());
            params.add(item.getPersonId());
            if (i < list.size() - 1) {
                sql.append("(?, ?), ");
                continue;
            }
            sql.append("(?, ?)");
        }
        sql.append(")");
        List<String> result = this.basicSyncCommonDao.selectList(sql.toString(), params.toArray(), String.class);
        return result;
    }

    @Override
    public void updateBatch(List<SyncPersonDevice> list) {
        String sql = "UPDATE T_SYNC_PERSON_DEVICE SET status = ?, create_time = ? WHERE person_id = ?  AND device_id = ? ";
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        for (SyncPersonDevice syncPersonDevice : list) {
            Object[] args = new Object[]{syncPersonDevice.getStatus(), syncPersonDevice.getCreateTime(), syncPersonDevice.getPersonId(), syncPersonDevice.getDeviceId()};
            batchArgs.add(args);
        }
        this.basicSyncCommonDao.batchUpdateBySql(sql, batchArgs);
    }
}

