/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.util;

import com.alibaba.fastjson.JSON;
import com.xdja.sync.util.HttpDeleteWithBody;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    public static final String GET = "GET";
    public static final String POST_JSON = "POST_JSON";
    public static final String POST_FROM = "POST_FROM";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    private static LayeredConnectionSocketFactory socketFactory;
    private static final int connectTimeout;
    private static final int requestTimeout;
    private static final int socketTimeout;
    private static HttpClientBuilder clientBuilder;

    public static PutUtil createPut(String url) {
        return new PutUtil(url);
    }

    public static DeleteUtil createDelete(String url) {
        return new DeleteUtil(url);
    }

    public static GetUtil createGet(String url) {
        return new GetUtil(url);
    }

    public static PostUtil createPost(String url) {
        return new PostUtil(url);
    }

    public static PostUtil createPost(String url, ContentType contentType) {
        return new PostUtil(url, contentType);
    }

    public static FormUtil createForm(String url) {
        return new FormUtil(url);
    }

    private static TrustManager[] getTrustingManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        return trustAllCerts;
    }

    private static LayeredConnectionSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            sslContext.init(null, HttpUtils.getTrustingManager(), new SecureRandom());
            return new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public HttpUtils setJKS(String jksFilePath, String password) {
        return this.setJKS(new File(jksFilePath), password);
    }

    public HttpUtils setJKS(File jksFile, String password) {
        HttpUtils httpUtils;
        FileInputStream instream = new FileInputStream(jksFile);
        try {
            httpUtils = this.setJKS(instream, password);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)instream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        ((InputStream)instream).close();
        return httpUtils;
    }

    public HttpUtils setJKS(InputStream is, String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(is, password.toCharArray());
            return this.setJKS(keyStore, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public HttpUtils setJKS(KeyStore keyStore, String password) {
        try {
            SSLContext sslContext = SSLContexts.custom().useTLS().loadKeyMaterial(keyStore, password.toCharArray()).loadTrustMaterial(keyStore).build();
            socketFactory = new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this;
    }

    private static CloseableHttpClient build(HttpRequestBase requestBase) {
        boolean https = requestBase.getURI().getScheme().equalsIgnoreCase("https");
        if (https && null != socketFactory) {
            clientBuilder.setSSLSocketFactory(socketFactory);
        } else if (https) {
            clientBuilder.setSSLSocketFactory(HttpUtils.getSSLSocketFactory());
        }
        return clientBuilder.build();
    }

    private static ResponseWrap exec(HttpRequestBase requestBase) {
        ResponseWrap responseWrap = null;
        try {
            CloseableHttpClient httpClient = HttpUtils.build(requestBase);
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse execute = httpClient.execute((HttpUriRequest)requestBase, (HttpContext)context);
            responseWrap = new ResponseWrap(httpClient, requestBase, execute, context);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return responseWrap;
    }

    static {
        connectTimeout = com.xdja.sync.bean.common.Consts.connectTimeout;
        requestTimeout = com.xdja.sync.bean.common.Consts.requestTimeout;
        socketTimeout = com.xdja.sync.bean.common.Consts.socketTimeout;
        clientBuilder = HttpClientBuilder.create();
    }

    public static class PutUtil {
        private HttpPut httpPut;
        private EntityBuilder entityBuilder;
        private final RequestConfig.Builder requestConfigBuilder;

        public PutUtil(String url) {
            this.httpPut = new HttpPut(url);
            this.entityBuilder = EntityBuilder.create().setParameters(new ArrayList());
            this.requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(requestTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout);
        }

        public PutUtil(String url, ContentType contentType) {
            this(url);
            this.entityBuilder.setContentType(contentType);
        }

        public PutUtil setConnectTimeOut(int timeout) {
            this.requestConfigBuilder.setConnectTimeout(timeout);
            return this;
        }

        public PutUtil setSocketTimeout(int timeout) {
            this.requestConfigBuilder.setSocketTimeout(timeout);
            return this;
        }

        public PutUtil addHeader(String name, String value) {
            this.httpPut.addHeader(name, value);
            return this;
        }

        public PutUtil addHeader(Map<String, String> headers) {
            if (null != headers) {
                for (String key : headers.keySet()) {
                    this.httpPut.addHeader(key, headers.get(key));
                }
            }
            return this;
        }

        public PutUtil addParameter(String param, String value) {
            this.entityBuilder.getParameters().add(new BasicNameValuePair(param, value));
            return this;
        }

        public PutUtil addParameters(Map<String, String> parameters) {
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                this.addParameter(key, parameters.get(key));
            }
            return this;
        }

        public PutUtil addJsonBody(Object object) {
            this.entityBuilder.setContentType(ContentType.APPLICATION_JSON);
            this.entityBuilder.setContentEncoding("utf-8");
            if (object instanceof String) {
                this.entityBuilder.setBinary(((String)object).getBytes());
            } else {
                this.entityBuilder.setBinary(JSON.toJSONString((Object)object).getBytes());
            }
            return this;
        }

        public PutUtil addBody(byte[] bytes) {
            this.entityBuilder.setBinary(bytes);
            return this;
        }

        public ResponseWrap execute() {
            HttpEntity httpEntity = this.entityBuilder.build();
            this.httpPut.setEntity(httpEntity);
            return HttpUtils.exec((HttpRequestBase)this.httpPut);
        }
    }

    public static class ResponseWrap {
        private CloseableHttpClient httpClient;
        private HttpRequestBase request;
        private CloseableHttpResponse response;
        private HttpClientContext context;
        private HttpEntity entity;

        ResponseWrap(CloseableHttpClient httpClient, HttpRequestBase request, CloseableHttpResponse response, HttpClientContext context) {
            this.httpClient = httpClient;
            this.request = request;
            this.response = response;
            this.context = context;
            try {
                HttpEntity entity = response.getEntity();
                this.entity = null != entity ? new BufferedHttpEntity(entity) : new BasicHttpEntity();
                EntityUtils.consume((HttpEntity)entity);
                this.response.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        public String getString() {
            try {
                return EntityUtils.toString((HttpEntity)this.entity, (Charset)Consts.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public byte[] getBytes() {
            try {
                return EntityUtils.toByteArray((HttpEntity)this.entity);
            }
            catch (IOException | ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public InputStream getInputStream() {
            try {
                return this.entity.getContent();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public int statusCode() {
            return this.response.getStatusLine().getStatusCode();
        }

        public String getHeaderValue(String key) {
            Header[] headers = this.response.getHeaders(key);
            if (headers == null || headers.length == 0) {
                return null;
            }
            return headers[0].getValue();
        }
    }

    public static class FormUtil {
        private HttpPost httpPost;
        private MultipartEntityBuilder builder;

        public FormUtil(String url) {
            this.httpPost = new HttpPost(url);
            this.builder = MultipartEntityBuilder.create();
            this.builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        }

        public FormUtil addParameter(String name, String value) {
            this.builder.addTextBody(name, value, ContentType.TEXT_PLAIN.withCharset(Charset.forName("UTF-8")));
            return this;
        }

        public FormUtil addParameters(Map<String, String> parameters) {
            Set<String> keySet = parameters.keySet();
            for (String key : keySet) {
                this.addParameter(key, parameters.get(key));
            }
            return this;
        }

        public FormUtil addParameter(String name, byte[] bytes) {
            this.builder.addBinaryBody(name, bytes);
            return this;
        }

        public FormUtil addParameter(String name, byte[] bytes, ContentType contentType, String filename) {
            this.builder.addBinaryBody(name, bytes, contentType, filename);
            return this;
        }

        public FormUtil addParameter(String name, File file, ContentType contentType, String fileName) {
            this.builder.addBinaryBody(name, file, contentType, fileName);
            return this;
        }

        public FormUtil setBoundary(String boundary) {
            this.builder.setBoundary(boundary);
            return this;
        }

        public ResponseWrap execute() {
            HttpEntity httpEntity = this.builder.build();
            this.httpPost.setEntity(httpEntity);
            return HttpUtils.exec((HttpRequestBase)this.httpPost);
        }
    }

    public static class PostUtil {
        private HttpPost httpPost;
        private EntityBuilder entityBuilder;
        private final RequestConfig.Builder requestConfigBuilder;

        public PostUtil(String url) {
            this.httpPost = new HttpPost(url);
            this.entityBuilder = EntityBuilder.create().setParameters(new ArrayList());
            this.requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(requestTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout);
        }

        public PostUtil(String url, ContentType contentType) {
            this(url);
            this.entityBuilder.setContentType(contentType);
        }

        public PostUtil setConnectTimeOut(int timeout) {
            this.requestConfigBuilder.setConnectTimeout(timeout);
            return this;
        }

        public PostUtil setSocketTimeout(int timeout) {
            this.requestConfigBuilder.setSocketTimeout(timeout);
            return this;
        }

        public PostUtil addHeader(String name, String value) {
            this.httpPost.addHeader(name, value);
            return this;
        }

        public PostUtil addHeader(Map<String, String> headers) {
            if (null != headers) {
                for (String key : headers.keySet()) {
                    this.httpPost.addHeader(key, headers.get(key));
                }
            }
            return this;
        }

        public PostUtil addParameter(String param, String value) {
            this.entityBuilder.getParameters().add(new BasicNameValuePair(param, value));
            return this;
        }

        public PostUtil addParameters(Map<String, String> parameters) {
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                this.addParameter(key, parameters.get(key));
            }
            return this;
        }

        public PostUtil addJsonBody(Object object) {
            this.entityBuilder.setContentType(ContentType.APPLICATION_JSON);
            this.entityBuilder.setContentEncoding("utf-8");
            if (object instanceof String) {
                this.entityBuilder.setBinary(((String)object).getBytes());
            } else {
                this.entityBuilder.setBinary(JSON.toJSONString((Object)object).getBytes());
            }
            return this;
        }

        public PostUtil addBody(byte[] bytes) {
            this.entityBuilder.setBinary(bytes);
            return this;
        }

        public ResponseWrap execute() {
            HttpEntity httpEntity = this.entityBuilder.build();
            this.httpPost.setEntity(httpEntity);
            return HttpUtils.exec((HttpRequestBase)this.httpPost);
        }
    }

    public static class DeleteUtil {
        private CloseableHttpClient httpClient = HttpClients.createDefault();
        private HttpDeleteWithBody httpDelete;

        public DeleteUtil(String url) {
            this.httpDelete = new HttpDeleteWithBody(url);
        }

        public DeleteUtil addHeader(String name, String value) {
            this.httpDelete.addHeader(name, value);
            return this;
        }

        public DeleteUtil addHeader(Map<String, String> headers) {
            if (null != headers) {
                for (String key : headers.keySet()) {
                    this.httpDelete.addHeader(key, headers.get(key));
                }
            }
            return this;
        }

        public DeleteUtil addParameter(String param, String value) throws UnsupportedEncodingException {
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
            paramList.add(new BasicNameValuePair(param, value));
            this.httpDelete.setEntity((HttpEntity)new UrlEncodedFormEntity(paramList, "UTF-8"));
            return this;
        }

        public DeleteUtil addParameters(Map<String, String> parameters) throws UnsupportedEncodingException {
            Set<String> keys = parameters.keySet();
            for (String key : keys) {
                this.addParameter(key, parameters.get(key));
            }
            return this;
        }

        public DeleteUtil addJsonBody(Object object) {
            this.httpDelete.setHeader("Content-Type", "application/json;charset=UTF-8");
            this.httpDelete.setHeader("accept", "application/json");
            if (null != object) {
                StringEntity stringEntity = null;
                stringEntity = object instanceof String ? new StringEntity(object + "", "UTF-8") : new StringEntity(JSON.toJSONString((Object)object), "UTF-8");
                stringEntity.setContentType("text/json");
                this.httpDelete.setEntity((HttpEntity)stringEntity);
            }
            return this;
        }

        public ResponseWrap execute() {
            return HttpUtils.exec((HttpRequestBase)this.httpDelete);
        }
    }

    public static class GetUtil {
        private HttpGet httpGet;
        private URIBuilder uriBuilder;
        private RequestConfig.Builder requestConfigBuilder;

        private GetUtil(String url) {
            this.httpGet = new HttpGet(url);
            this.uriBuilder = new URIBuilder(this.httpGet.getURI());
            this.uriBuilder.setCharset(Charset.forName("UTF-8"));
            this.requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(requestTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout);
        }

        public GetUtil addHeader(String name, String value) {
            this.httpGet.addHeader(name, value);
            return this;
        }

        public GetUtil addParameter(String param, String value) {
            this.uriBuilder.setParameter(param, value);
            return this;
        }

        public GetUtil setConnectTimeOut(int timeout) {
            this.requestConfigBuilder.setConnectTimeout(timeout);
            return this;
        }

        public GetUtil setSocketTimeout(int timeout) {
            this.requestConfigBuilder.setSocketTimeout(timeout);
            return this;
        }

        public ResponseWrap execute() {
            try {
                URI uri = new URI(this.uriBuilder.build().toString().replace("%3F", "?"));
                this.httpGet.setURI(uri);
                this.httpGet.setConfig(this.requestConfigBuilder.build());
            }
            catch (URISyntaxException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            return HttpUtils.exec((HttpRequestBase)this.httpGet);
        }
    }
}

