/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.xdja.common.BaseController;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.bean.table.SyncTableConfig;
import com.xdja.sync.bean.table.SyncTableDataResBean;
import com.xdja.sync.dao.BasicSyncCommonDao;
import com.xdja.sync.handler.ExecuteScheduleSyncHandler;
import com.xdja.sync.util.IdGeneratorUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class SyncTableDataController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(SyncTableDataController.class);
    @Autowired
    private BasicSyncCommonDao basicSyncCommonDao;
    @Autowired
    private ExecuteScheduleSyncHandler executeScheduleSyncHandler;

    @RequestMapping(value={"/admin/v1/syncData/syncTableData.do", "/admin/v1/syncData/syncTableData"})
    public void syncTableData(HttpServletRequest request, HttpServletResponse response) {
        int code = 0;
        String message = "\u540c\u6b65\u8868\u6570\u636e\u6210\u529f";
        ArrayList<SyncTableDataResBean> listResult = new ArrayList<SyncTableDataResBean>();
        try {
            String json = IOUtils.toString((InputStream)request.getInputStream(), (String)"utf-8");
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u8868\u6570\u636e>>>\u3010{}\u3011", (Object)json);
            }
            List listReqBean = JSONArray.parseArray((String)json, SyncTableConfig.class);
            int i = 0;
            int total = listReqBean.size();
            Page page = null;
            List<?> list = null;
            SyncTableDataResBean resBean = null;
            for (SyncTableConfig syncTableConfig : listReqBean) {
                ++i;
                String tableName = syncTableConfig.getTableName();
                String syncMode = syncTableConfig.getSyncMode();
                String lastOrderField = syncTableConfig.getLastOrderField();
                String lastOrderFieldValue = syncTableConfig.getLastOrderFieldValue();
                Integer pageNo = syncTableConfig.getPageNo();
                Integer pageSize = syncTableConfig.getPageSize();
                String primaryKey = syncTableConfig.getPrimaryKey();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u8868\u6570\u636e[{}/{}],SyncTableConfig:\u3010{}\u3011>>>", new Object[]{i, total, JSON.toJSONString((Object)syncTableConfig)});
                }
                resBean = new SyncTableDataResBean();
                resBean.setTableName(tableName);
                resBean.setPrimaryKey(primaryKey);
                String sql = "SELECT * FROM " + tableName + " ";
                if ("1".equals(syncMode)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u540c\u6b65\u8868\u6570\u636e-\u5168\u91cf\u540c\u6b65\u8868[{}]\uff0c\u540c\u6b65sql:\u3010{}\u3011", (Object)tableName, (Object)sql);
                    }
                    list = this.basicSyncCommonDao.selectList(sql, null, Map.class);
                    page = new Page(1, 10);
                    page.setTotal(0L);
                    if (!CollectionUtils.isEmpty(list)) {
                        page = new Page(1, list.size());
                        page.setTotal(list.size());
                        page.setData(list);
                    }
                } else if ("2".equals(syncMode)) {
                    if (!StringUtils.isEmpty((Object)lastOrderField)) {
                        if (!StringUtils.isEmpty((Object)lastOrderFieldValue)) {
                            sql = sql + this.buildWhere(lastOrderField, lastOrderFieldValue);
                        }
                        sql = sql + " ORDER BY " + lastOrderField + " ASC ";
                    }
                    page = new Page(1, Integer.MAX_VALUE);
                    if (null != pageNo) {
                        page.setPageNo(pageNo);
                    }
                    if (null != pageSize) {
                        page.setPageSize(pageSize);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u540c\u6b65\u8868\u6570\u636e-\u589e\u91cf\u540c\u6b65\u8868[{}]\uff0c\u540c\u6b65sql:\u3010{}\u3011, pageNo:\u3010{}\u3011, pageSize:\u3010{}\u3011", new Object[]{tableName, sql, pageNo, pageSize});
                    }
                    List<?> list1 = this.basicSyncCommonDao.selectList(sql, null, Map.class, page);
                    page.setData(list1);
                    page.setRows(null);
                }
                resBean.setPage(page);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u8868\u6570\u636e[{}/{}],SyncTableConfig:\u3010{}\u3011, data\uff1a\u3010{}\u3011<<<", new Object[]{i, total, JSON.toJSONString((Object)syncTableConfig), JSON.toJSONString((Object)resBean)});
                }
                listResult.add(resBean);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25", (Throwable)e);
            code = -1;
            message = "\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25";
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8868\u6570\u636e<<<\u3010{}\u3011", (Object)JSON.toJSONString(listResult));
        }
        super.writeAndFlushResponse(request, response, code, IdGeneratorUtil.nextIdStr(), message, null, null, listResult);
    }

    private String buildWhere(String lastOrderField, String lastOrderFieldValue) {
        String where = " WHERE " + lastOrderField + " >= " + lastOrderFieldValue;
        Object columnType = null;
        return where;
    }
}

