/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.util;

import com.alibaba.fastjson.JSON;
import com.xdja.common.AbstractBaseLocalCache;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.service.BasicSyncAppService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncAppLocalCacheUtil
extends AbstractBaseLocalCache<String, SyncApp> {
    private static final Logger logger = LoggerFactory.getLogger(SyncAppLocalCacheUtil.class);
    private BasicSyncAppService basicSyncAppService = (BasicSyncAppService)Consts.applicationContext.getBean(BasicSyncAppService.class);
    private static final int CACHE_REFRESH_TIME = 30;

    private SyncAppLocalCacheUtil(long duration, TimeUnit timeUtil) {
        super(duration, timeUtil);
    }

    public static SyncAppLocalCacheUtil getInstance() {
        return StringLocalCacheUtilHolder.instance;
    }

    @Override
    protected SyncApp loadData(String appId) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5e94\u7528\u4fe1\u606fappId:\u3010{}\u3011", (Object)appId);
        }
        SyncApp syncPerson = this.basicSyncAppService.querySyncAppById(appId);
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5e94\u7528\u4fe1\u606fappId:\u3010{}\u3011SyncApp:\u3010{}\u3011", (Object)appId, (Object)JSON.toJSONString((Object)syncPerson));
        }
        return syncPerson;
    }

    private static final class StringLocalCacheUtilHolder {
        private static final SyncAppLocalCacheUtil instance = new SyncAppLocalCacheUtil(30L, TimeUnit.MINUTES);

        private StringLocalCacheUtilHolder() {
        }
    }
}

