/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.enums;

import org.apache.commons.lang3.StringUtils;

public enum RequestMethod {
    GET(4, "GET"),
    POST(1, "POST"),
    DELETE(2, "DELETE"),
    PUT(4, "PUT");

    private Integer code;
    private String desc;

    public static String getNameByCode(Integer code) {
        RequestMethod[] values;
        if (null == code || code.equals(null)) {
            return null;
        }
        for (RequestMethod requestMethod : values = RequestMethod.values()) {
            if (requestMethod.getCode().intValue() != code.intValue()) continue;
            return requestMethod.getDesc();
        }
        return GET.getDesc();
    }

    public static Integer getCodeByName(String name) {
        RequestMethod[] values;
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (RequestMethod requestMethod : values = RequestMethod.values()) {
            if (!requestMethod.getDesc().equals(name)) continue;
            return requestMethod.getCode();
        }
        return GET.getCode();
    }

    private RequestMethod(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

