/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.log.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.common.BisRedisUtil;
import com.xdja.common.RedisKeyConst;
import com.xdja.log.bean.LogCacheBean;
import com.xdja.log.handler.BasicLogClearHandler;
import com.xdja.log.handler.BasicLogHandlerFactory;
import com.xdja.log.service.BasicLogCacheService;
import com.xdja.sync.bean.common.Consts;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RedisBasicLogCacheServiceImpl
implements BasicLogCacheService {
    private static final Logger logger = LoggerFactory.getLogger(RedisBasicLogCacheServiceImpl.class);
    @Autowired(required=false)
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private BasicLogHandlerFactory basicLogHandlerFactory;
    @Autowired
    private BasicLogClearHandler basicLogClearHandler;
    @Autowired
    private Environment environment;
    private AtomicInteger atomicInteger = new AtomicInteger(0);
    private volatile boolean basicLogClearTaskRunning = false;
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(2, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("log-cache-redis-" + RedisBasicLogCacheServiceImpl.this.atomicInteger.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    @Override
    public void cacheLog(LogCacheBean logCacheBean) {
        String logCacheKey = RedisKeyConst.getLogCacheKey();
        try {
            String json = JSON.toJSONString((Object)logCacheBean);
            if (logger.isDebugEnabled()) {
                logger.debug("\u7f13\u5b58[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7redisKey:\u3010{}\u3011LogCacheBean:\u3010{}\u3011", (Object)logCacheKey, (Object)json);
            }
            if (null == logCacheBean) {
                logger.warn("\u7f13\u5b58[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7LogCacheBean\u4e3a\u7a7a");
                return;
            }
            this.stringRedisTemplate.opsForList().rightPush((Object)logCacheKey, (Object)json);
        }
        catch (Exception e) {
            logger.error("\u7f13\u5b58[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7redisKey:\u3010{}\u3011\u5931\u8d25:", (Object)logCacheKey, (Object)e);
        }
    }

    @Override
    public void consumeLog() {
        try {
            long initialDelay = 5L;
            long delay = 5L;
            try {
                String property = ((Environment)Consts.applicationContext.getBean(Environment.class)).getProperty("log.consume.delay.time");
                if (!StringUtils.isEmpty((Object)property)) {
                    delay = Long.parseLong(property);
                }
            }
            catch (Exception e) {
                logger.warn("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u9891\u7387\uff1a\u3010{}\u3011", (Object)delay);
            }
            final long finalDelay = delay;
            this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (logger.isInfoEnabled()) {
                        logger.info("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c>>>");
                    }
                    try {
                        ListOperations stringStringListOperations = RedisBasicLogCacheServiceImpl.this.stringRedisTemplate.opsForList();
                        String logCacheKey = RedisKeyConst.getLogCacheKey();
                        Long size = null;
                        LogCacheBean logCacheBean = null;
                        do {
                            size = stringStringListOperations.size((Object)logCacheKey);
                            long currentTimeMillis = System.currentTimeMillis();
                            if (logger.isInfoEnabled()) {
                                logger.info("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7redisKey:[{}],total:[{}]>>>\u5f00\u59cb\u65f6\u95f4\uff1a\u3010{}\u3011", new Object[]{logCacheKey, size, currentTimeMillis});
                            }
                            if (null != size && size > 0L) {
                                int i = 0;
                                while ((long)i < size) {
                                    String json = (String)stringStringListOperations.leftPop((Object)logCacheKey);
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7redisKey:[{}],[{}/{}]>>>LogCacheBean:\u3010{}\u3011", new Object[]{logCacheKey, i + 1, size, json});
                                    }
                                    if (!StringUtils.isEmpty((Object)json)) {
                                        logCacheBean = (LogCacheBean)JSON.parseObject((String)json, LogCacheBean.class);
                                        RedisBasicLogCacheServiceImpl.this.basicLogHandlerFactory.handlerLog(logCacheBean);
                                    }
                                    if (logger.isInfoEnabled()) {
                                        logger.info("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7redisKey:[{}],[{}/{}]<<<", new Object[]{logCacheKey, i + 1, size});
                                    }
                                    ++i;
                                }
                            }
                            if (!logger.isInfoEnabled()) continue;
                            logger.info("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7redisKey:[{}],total:[{}]<<<\u7ed3\u675f\u65f6\u95f4\uff1a\u3010{}\u3011\u8017\u65f6\uff1a\u3010{}\u3011", new Object[]{logCacheKey, size, System.currentTimeMillis(), System.currentTimeMillis() - currentTimeMillis});
                        } while (null != size && size > 0L);
                    }
                    catch (Exception e) {
                        logger.error("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5b9a\u65f6\u4efb\u52a1[{}]s\u540e\u6267\u884c<<<", (Object)finalDelay);
                    }
                }
            }, initialDelay, delay, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error("\u6d88\u8d39[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
        }
    }

    @Override
    public void clearLog() {
        try {
            long initialDelay = RedisBasicLogCacheServiceImpl.laterSecond();
            long delay = 86400000L;
            try {
                String property = ((Environment)Consts.applicationContext.getBean(Environment.class)).getProperty("log.clear.delay.time");
                if (!StringUtils.isEmpty((Object)property)) {
                    delay = Long.parseLong(property);
                }
            }
            catch (Exception e) {
                logger.warn("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u9891\u7387\uff1a\u3010{}\u3011", (Object)delay);
            }
            final long finalDelay = delay;
            this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (logger.isInfoEnabled()) {
                        logger.info("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c>>>");
                    }
                    try {
                        boolean existRedis;
                        String lockKey = RedisKeyConst.getLockClearLogTableKey();
                        long timeout = 900L;
                        String lockValue = BisRedisUtil.getExpireMillis(timeout);
                        boolean lock = false;
                        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
                        if (existRedis) {
                            lock = BisRedisUtil.tryLock(lockKey, lockValue);
                            if (!lock) {
                                logger.info("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7,\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                                return;
                            }
                        } else {
                            3 var7_7 = this;
                            synchronized (var7_7) {
                                if (RedisBasicLogCacheServiceImpl.this.basicLogClearTaskRunning) {
                                    logger.info("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7,\u4efb\u52a1\u6b63\u5728\u6267\u884c\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                                    return;
                                }
                                RedisBasicLogCacheServiceImpl.this.basicLogClearTaskRunning = true;
                            }
                        }
                        long currentTimeMillis = System.currentTimeMillis();
                        if (logger.isInfoEnabled()) {
                            logger.info("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7redisKey:[{}]>>>\u5f00\u59cb\u65f6\u95f4\uff1a\u3010{}\u3011", (Object)lockKey, (Object)currentTimeMillis);
                        }
                        try {
                            RedisBasicLogCacheServiceImpl.this.basicLogClearHandler.deleteLog();
                        }
                        catch (Exception e) {
                            logger.error("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
                        }
                        finally {
                            RedisBasicLogCacheServiceImpl.this.basicLogClearTaskRunning = false;
                            if (existRedis && lock) {
                                BisRedisUtil.releaseLock(lockKey, lockValue);
                            }
                        }
                        if (logger.isInfoEnabled()) {
                            logger.info("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7redisKey:[{}]<<<\u7ed3\u675f\u65f6\u95f4\uff1a\u3010{}\u3011\u8017\u65f6\uff1a\u3010{}\u3011", new Object[]{lockKey, System.currentTimeMillis(), System.currentTimeMillis() - currentTimeMillis});
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5b9a\u65f6\u4efb\u52a1[{}]s\u540e\u6267\u884c<<<", (Object)finalDelay);
                    }
                }
            }, initialDelay, finalDelay, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664[\u57fa\u4e8eRedis\u7f13\u5b58]\u65e5\u5fd7\u5931\u8d25:", (Throwable)e);
        }
    }

    private static Long laterSecond() {
        long currentTimeMillis = System.currentTimeMillis();
        long zeroLater = 3600000L;
        return RedisBasicLogCacheServiceImpl.tomorrowZero() + zeroLater - currentTimeMillis;
    }

    private static Long tomorrowZero() {
        return RedisBasicLogCacheServiceImpl.dayZero() + 86400000L;
    }

    private static Long dayZero() {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date midnight = DateUtils.truncate((Date)calendar.getTime(), (int)5);
        return midnight.getTime();
    }
}

