/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.dao.imp;

import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.bean.common.DbType;
import com.xdja.sync.bean.common.Page;
import com.xdja.sync.dao.BasicSyncCommonDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BasicSyncCommonDaoImpl
implements BasicSyncCommonDao,
InitializingBean {
    private static Logger log = LoggerFactory.getLogger(BasicSyncCommonDaoImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public int updateBySql(String sql, final Object[] args) {
        if (log.isDebugEnabled()) {
            log.debug("execute sql:\u3010{}\u3011,params:\u3010{}\u3011", (Object)sql, (Object)args);
        }
        return this.jdbcTemplate.update(sql, new PreparedStatementSetter(){

            public void setValues(PreparedStatement preparedStatement) throws SQLException {
                if (args != null && args.length > 0) {
                    for (int i = 1; i <= args.length; ++i) {
                        preparedStatement.setObject(i, args[i - 1]);
                    }
                }
            }
        });
    }

    @Override
    public boolean batchUpdateBySql(String sql, List<Object[]> batchArgs) {
        if (log.isDebugEnabled()) {
            log.debug("execute update sql:\u3010{}\u3011,params:\u3010{}\u3011", (Object)sql, (Object)this.formatPrintBatchArgs(batchArgs));
        }
        this.jdbcTemplate.batchUpdate(sql, batchArgs);
        return true;
    }

    @Override
    public Object selectOne(String sql, Object[] args, Class<?> requiredClassType) {
        List<?> list = this.selectList(sql, args, requiredClassType);
        return null != list && list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public List<?> selectList(String sql, Object[] args, Class<?> requiredClassType) {
        List list = null;
        Object rowMapper = null;
        rowMapper = Map.class.isAssignableFrom(requiredClassType) ? new ColumnMapRowMapper() : (String.class.equals(requiredClassType) || Integer.class.equals(requiredClassType) || Integer.TYPE.equals(requiredClassType) || Long.class.equals(requiredClassType) || Long.TYPE.equals(requiredClassType) || Double.class.equals(requiredClassType) || Double.TYPE.equals(requiredClassType) || Float.class.equals(requiredClassType) || Float.TYPE.equals(requiredClassType) || Byte.class.equals(requiredClassType) || Byte.TYPE.equals(requiredClassType) || Short.class.equals(requiredClassType) || Short.TYPE.equals(requiredClassType) || Number.class.equals(requiredClassType) ? new SingleColumnRowMapper(requiredClassType) : new BeanPropertyRowMapper(requiredClassType));
        if (args == null) {
            args = new Object[]{};
        }
        if (log.isDebugEnabled()) {
            log.debug("execute select sql:\u3010{}\u3011,params:\u3010{}\u3011,page:\u3010{}\u3011", (Object)sql, (Object)args);
        }
        list = this.jdbcTemplate.query(sql, (RowMapper)rowMapper, args);
        return list;
    }

    @Override
    public List<?> selectList(String sql, Object[] args, Class<?> requiredClassType, Page page) {
        String selectCount = "select count(*) from (" + sql + ") tmp";
        if (null != selectCount && !selectCount.isEmpty() && null != page) {
            Long total = (Long)this.selectSingleColumn(selectCount, args, Long.class);
            page.setTotal(total);
            page.setRecordsTotal(total);
            page.setRecordsFiltered(total);
            sql = this.buildPageSql(sql, page);
        }
        List<?> list = this.selectList(sql, args, requiredClassType);
        page.setRows(list);
        page.setData(list);
        return list;
    }

    public Object selectSingleColumn(String sql, Object[] args, Class<?> requiredClassType) {
        List<?> list = this.selectList(sql, args, requiredClassType);
        return this.analysis(list, requiredClassType);
    }

    private Object analysis(List<?> list, Class<?> requiredClassType) {
        if (null == list || list.get(0) == null) {
            if (!requiredClassType.isPrimitive()) {
                return null;
            }
            if (requiredClassType.isAssignableFrom(Byte.TYPE)) {
                return 0;
            }
            if (requiredClassType.isAssignableFrom(Short.TYPE)) {
                return 0;
            }
            if (requiredClassType.isAssignableFrom(Integer.TYPE)) {
                return 0;
            }
            if (requiredClassType.isAssignableFrom(Long.TYPE)) {
                return 0L;
            }
            if (requiredClassType.isAssignableFrom(Double.TYPE)) {
                return 0.0;
            }
            if (requiredClassType.isAssignableFrom(Float.TYPE)) {
                return Float.valueOf(0.0f);
            }
            if (requiredClassType.isAssignableFrom(Character.TYPE)) {
                return null;
            }
            if (requiredClassType.isAssignableFrom(Boolean.TYPE)) {
                return false;
            }
        }
        return Objects.isNull(list) ? null : list.get(0);
    }

    private String formatPrintBatchArgs(List<Object[]> batchArgs) {
        if (null == batchArgs || batchArgs.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i < batchArgs.size(); ++i) {
            Object[] objects = batchArgs.get(i);
            if (null == objects || objects.length < 1) continue;
            buffer.append("[");
            for (int j = 0; j < objects.length; ++j) {
                buffer.append(objects[j]);
                if (j == objects.length - 1) continue;
                buffer.append(",");
            }
            buffer.append("]");
            if (i == batchArgs.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String buildPageSql(String sql, Page page) {
        int pageNo = page.getPageNo();
        int pageSize = page.getPageSize();
        StringBuffer pageSelect = new StringBuffer();
        if (DbType.MYSQL == Consts.dbType) {
            pageSelect.append("select * from ");
            pageSelect.append("(");
            pageSelect.append(sql);
            pageSelect.append(") tmp ");
            String limit = pageNo <= 1 ? " limit 0, " + pageSize : " limit " + (pageNo - 1) * pageSize + ", " + pageSize;
            pageSelect.append(limit);
            sql = pageSelect.toString();
        } else if (DbType.ORACLE == Consts.dbType) {
            pageSelect.append("SELECT * FROM (").append("SELECT rownum rn, a.* FROM (").append(sql).append(") a WHERE rownum <= ").append(pageNo * pageSize).append(" ) WHERE rn > ").append((pageNo - 1) * pageSize);
        } else {
            log.info("\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b:{}, {}", (Object)Consts.dbType.getDb(), (Object)Consts.dbType.getDesc());
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
        }
        return pageSelect.toString();
    }

    public void afterPropertiesSet() throws Exception {
        DbType dbType = DbType.MYSQL;
        try (Connection connection = this.getJdbcTemplate().getDataSource().getConnection();){
            String databaseType = connection.getMetaData().getDatabaseProductName().toLowerCase();
            dbType = DbType.getDbType(databaseType);
        }
        catch (SQLException e) {
            log.error("\u83b7\u53d6\u6570\u636e\u7c7b\u578b\u5931\u8d25:", (Throwable)e);
        }
        Consts.dbType = dbType;
    }
}

