/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.common.BisRedisUtil;
import com.xdja.common.RedisKeyConst;
import com.xdja.smcs.util.SmcsPlatformUtil;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.PamsSyncDao;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.util.HttpUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class PamsSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(PamsSyncHandler.class);
    @Autowired
    private PamsSyncDao pamsSyncDao;
    @Autowired
    private Environment environment;
    private Long syncPamsInterval;
    @Value(value="${sync.pams.switch:on}")
    private String syncPamsSwitch;
    @Autowired
    private SmcsPlatformUtil smcsPlatformUtil;
    private int pageSize = 200;
    private String person_uri = "/sso/basicinfosynchronizecontrol/vyyzc/personinfosyn.do";
    private String dept_uri = "/sso/basicinfosynchronizecontrol/vyyzc/departmentinfosyn.do";
    private volatile boolean syncDeptRunning = false;
    private volatile boolean syncPersonRunning = false;
    private volatile boolean syncPersonRoleRunning = false;

    @Override
    String getPoolName() {
        return "pams";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        if ("off".equalsIgnoreCase(this.syncPamsSwitch)) {
            logger.info("\u540c\u6b65\u5355\u4f4d\u4eba\u5458\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879sync.pams.switch=on");
            return;
        }
        if (null == executorService) {
            executorService = SyncHandlerThreadFactory.getScheduledExecutorService(this.getPoolName());
        }
        String property = this.environment.getProperty("sync.pams.interval", "300");
        this.syncPamsInterval = Long.parseLong(property);
        executorService.scheduleWithFixedDelay(() -> {
            try {
                logger.info("\u540c\u6b65\u5355\u4f4d\u4eba\u5458\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879sync.pams.interval[{}]\u79d2", (Object)this.syncPamsInterval);
                for (TableEnum tableEnum : tableEnums) {
                    if (TableEnum.TABLE_DEPARTMENT == tableEnum) {
                        try {
                            this.syncDept();
                        }
                        catch (Exception e) {
                            logger.error("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                        }
                        continue;
                    }
                    if (TableEnum.TABLE_PERSON != tableEnum) continue;
                    try {
                        this.syncPerson();
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    }
                }
                if ("uas".equals(this.smcsPlatformUtil.getSystemCode())) {
                    try {
                        this.syncPersonRole();
                    }
                    catch (Exception e) {
                        logger.error("\u540c\u6b65\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
                    }
                }
                this.pamsSyncDao.updatePersonTreeIdCode();
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65pams\u6570\u636e\u5f02\u5e38:", (Throwable)e);
            }
        }, SyncHandlerThreadFactory.getSyncInitialDelay(), this.syncPamsInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncDept() {
        boolean existRedis;
        String lockKey = RedisKeyConst.getLockSyncPamsKey() + "1";
        long timeout = 600L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            PamsSyncHandler pamsSyncHandler = this;
            synchronized (pamsSyncHandler) {
                if (this.syncDeptRunning) {
                    logger.error("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u540c\u6b65\u5355\u4f4d\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncDeptRunning = true;
            }
        }
        try {
            int size;
            JSONArray listDept = this.pullAllDept();
            int n = size = this.pamsSyncDao.updateDept(listDept);
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u5f02\u5e38", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncDeptRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncPerson() {
        boolean existRedis;
        String lockKey = RedisKeyConst.getLockSyncPamsKey() + "2";
        long timeout = 600L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            PamsSyncHandler pamsSyncHandler = this;
            synchronized (pamsSyncHandler) {
                if (this.syncPersonRunning) {
                    logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u540c\u6b65\u4eba\u5458\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncPersonRunning = true;
            }
        }
        try {
            int updatePerson;
            JSONArray jsonArray = this.pullAllPerson();
            int n = updatePerson = this.pamsSyncDao.updatePerson(jsonArray);
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,\u5f02\u5e38", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncPersonRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public int syncPersonRole() {
        PamsSyncHandler pamsSyncHandler = this;
        synchronized (pamsSyncHandler) {
            if (this.syncPersonRoleRunning) {
                logger.error("\u540c\u6b65\u4eba\u5458\u89d2\u8272\u4fe1\u606f,\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u540c\u6b65\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
            this.syncPersonRoleRunning = true;
        }
        try {
            int updatePerson;
            JSONArray jsonArray = this.pullAllPersonRole();
            int n = updatePerson = this.pamsSyncDao.updatePersonRole(jsonArray);
            return n;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u89d2\u8272\u4fe1\u606f,\u5f02\u5e38", (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        finally {
            this.syncPersonRoleRunning = false;
        }
    }

    private JSONArray pullAllPerson() {
        JSONArray listPerson;
        String url = Consts.pamsServerUrl + this.person_uri;
        Long lastUpdateTime = this.pamsSyncDao.getPersonLastUpdateTime();
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,url:\u3010{}\u3011, lastUpdateTime:\u3010{}\u3011", (Object)url, (Object)lastUpdateTime);
        }
        if (CollectionUtils.isEmpty((Collection)(listPerson = this.pullPamsData(lastUpdateTime, 1, 1, url)))) {
            logger.info("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,\u6ca1\u6709\u66f4\u65b0,lastUpdateTime:\u3010{}\u3011", (Object)lastUpdateTime);
            return new JSONArray();
        }
        int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;
        JSONArray listPersonResult = new JSONArray();
        int pageNum = 1;
        while (true) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,lastUpdateTime:\u3010{}\u3011,pageNo:\u3010{}\u3011>>>", (Object)lastUpdateTime, (Object)pageNum);
            }
            listPerson = this.pullPamsData(lastUpdateTime, pageNum, pageSize, url);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,lastUpdateTime:\u3010{}\u3011,pageNo:\u3010{}\u3011<<<", new Object[]{lastUpdateTime, pageNum, listPersonResult.toJSONString()});
            }
            if (!CollectionUtils.isEmpty((Collection)listPerson)) {
                listPersonResult.addAll((Collection)listPerson);
            }
            if (CollectionUtils.isEmpty((Collection)listPerson) || listPerson.size() < pageSize) break;
            ++pageNum;
        }
        logger.info("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,<<<");
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u4fe1\u606f,total:\u3010{}\u3011", (Object)listPersonResult.size());
        }
        return listPersonResult;
    }

    private JSONArray pullAllDept() {
        JSONArray listDept;
        String url = Consts.pamsServerUrl + this.dept_uri;
        Long lastUpdateTime = this.pamsSyncDao.getDepartmentLastUpdateTime();
        lastUpdateTime = null == lastUpdateTime ? 0L : lastUpdateTime;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,url:\u3010{}\u3011,lastUpdateTime:\u3010{}\u3011>>>", (Object)url, (Object)lastUpdateTime);
        }
        if (CollectionUtils.isEmpty((Collection)(listDept = this.pullPamsData(lastUpdateTime, 1, this.pageSize, url)))) {
            logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u672c\u6b21\u5355\u4f4d\u6ca1\u6709\u66f4\u65b0,lastUpdateTime:\u3010{}\u3011", (Object)lastUpdateTime);
            return new JSONArray();
        }
        int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;
        JSONArray listDeptResult = new JSONArray();
        int pageNum = 1;
        while (true) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u672c\u6b21\u5355\u4f4d\u6ca1\u6709\u66f4\u65b0,lastUpdateTime:\u3010{}\u3011,pageNo:\u3010{}\u3011>>>", (Object)lastUpdateTime, (Object)pageNum);
            }
            listDept = this.pullPamsData(lastUpdateTime, pageNum, pageSize, url);
            logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,\u672c\u6b21\u5355\u4f4d\u6ca1\u6709\u66f4\u65b0,lastUpdateTime:\u3010{}\u3011,pageNo:\u3010{}\u3011,rows:\u3010{}\u3011<<<", new Object[]{lastUpdateTime, pageNum, listDept.toJSONString()});
            if (!CollectionUtils.isEmpty((Collection)listDept)) {
                listDeptResult.addAll((Collection)listDept);
            }
            if (CollectionUtils.isEmpty((Collection)listDept) || listDept.size() < pageSize) break;
            ++pageNum;
        }
        logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,<<<");
        logger.debug("\u540c\u6b65\u5355\u4f4d\u4fe1\u606f,total:\u3010{}\u3011", (Object)listDeptResult.size());
        return listDeptResult;
    }

    private JSONArray pullAllPersonRole() {
        String url = Consts.pamsServerUrl + "/sso/basicinfosynchronizecontrol/getPerson2Role.do";
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u89d2\u8272\u4fe1\u606f,url:\u3010{}\u3011", (Object)url);
        }
        JSONArray listPersonRoleResult = new JSONArray();
        JSONArray listPersonRole = this.pullPamsPersonRoleData(url);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u89d2\u8272\u4fe1\u606f,data:\u3010{}\u3011<<<", (Object)listPersonRole.toJSONString());
        }
        if (!CollectionUtils.isEmpty((Collection)listPersonRole)) {
            listPersonRoleResult.addAll((Collection)listPersonRole);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u89d2\u8272\u4fe1\u606f,total:\u3010{}\u3011", (Object)listPersonRoleResult.size());
        }
        return listPersonRoleResult;
    }

    public JSONArray pullPamsData(Long dataMaxVersion, int pageNo, int pageSize, String url) {
        JSONArray listPamsData = new JSONArray();
        HashMap<String, String> requestParam = new HashMap<String, String>(4);
        requestParam.put("thirdId", Consts.systemName);
        requestParam.put("lastTime", dataMaxVersion == null ? "0" : String.valueOf(dataMaxVersion));
        requestParam.put("pageNo", pageNo + "");
        requestParam.put("pageSize", pageSize + "");
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606furl:[{}],param:\u3010{}\u3011>>>", (Object)url, (Object)JSON.toJSONString(requestParam));
            }
            if ((responseWrap = HttpUtils.createForm(url).addParameters(requestParam).execute()) == null) {
                logger.info("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            if (200 != responseWrap.statusCode()) {
                logger.info("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801, []", (Object)responseWrap.statusCode());
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        try {
            JSONObject jsonObject;
            String flag;
            String json = responseWrap.getString();
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606furl:[{}],param:\u3010{}\u3011,result:\u3010{}\u3011<<<", new Object[]{url, JSON.toJSONString(requestParam), json});
            }
            if (!"0".equals(flag = (jsonObject = JSONObject.parseObject((String)json)).getJSONObject("result").getString("flag"))) {
                logger.error("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fe1\u606f\u5931\u8d25flag:{}", (Object)flag);
                return listPamsData;
            }
            listPamsData = jsonObject.getJSONArray("list");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65pams\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        return null == listPamsData ? new JSONArray() : listPamsData;
    }

    public JSONArray pullPamsPersonRoleData(String url) {
        JSONArray listPamsData = new JSONArray();
        HttpUtils.ResponseWrap responseWrap = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65pams\u4eba\u5458\u89d2\u8272\u4fe1\u606furl:[{}]>>>", (Object)url);
            }
            if ((responseWrap = HttpUtils.createForm(url).execute()) == null) {
                logger.info("\u540c\u6b65pams\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u540c\u6b65pams\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
            }
            if (200 != responseWrap.statusCode()) {
                logger.info("\u540c\u6b65pams\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801 {}", (Object)responseWrap.statusCode());
                throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), "\u540c\u6b65pams\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u5f02\u5e38,\u8fd4\u56de\u72b6\u6001\u7801" + responseWrap.statusCode());
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65pams\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        try {
            JSONObject jsonObject;
            String flag;
            String json = responseWrap.getString();
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65pams\u4eba\u5458\u89d2\u8272\u4fe1\u606furl:[{}],result:\u3010{}\u3011<<<", (Object)url, (Object)json);
            }
            if (!"0".equals(flag = (jsonObject = JSONObject.parseObject((String)json)).getString("rtnCode"))) {
                logger.error("\u540c\u6b65pams\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u5931\u8d25flag:{}", (Object)flag);
                return listPamsData;
            }
            listPamsData = jsonObject.getJSONArray("data");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65pams\u4eba\u5458\u89d2\u8272\u4fe1\u606f\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new SyncClientException(SyncClientExceptionCode.OPERATE_ERROR.getCode(), e.getMessage());
        }
        return null == listPamsData ? new JSONArray() : listPamsData;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        List<TableEnum> listTableEnum = Arrays.asList(tableEnums).stream().filter(tableEnum -> TableEnum.TABLE_PERSON == tableEnum || TableEnum.TABLE_DEPARTMENT == tableEnum).collect(Collectors.toList());
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

