/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.xdja.common.BisRedisUtil;
import com.xdja.common.RedisKeyConst;
import com.xdja.sync.bean.SyncPerson;
import com.xdja.sync.bean.SyncPersonDevice;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.PersonDeviceSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncPersonService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.IdGeneratorUtil;
import com.xdja.task.ThreadManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PersonDeviceSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(PersonDeviceSyncHandler.class);
    @Autowired
    private Environment environment;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private BasicSyncPersonService basicSyncPersonService;
    @Autowired
    private PersonDeviceSyncDao personDeviceSyncDao;
    private Long syncPersonDeviceInterval;
    private String syncPersonDeviceSwitch;
    private volatile boolean syncPersonAppRunning = false;
    private int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;

    @Override
    String getPoolName() {
        return "personDevice";
    }

    @Override
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        String uasUrl = this.environment.getProperty("application.upm.server.url", "");
        if (StringUtils.isEmpty((Object)uasUrl)) {
            logger.info("\u540c\u6b65\u4eba\u5458\u5e94\u7528\u6743\u9650\u5173\u7cfb\uff0cuas\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\u914d\u7f6e\u9879application.upm.server.url");
            return;
        }
        this.syncPersonDeviceSwitch = this.environment.getProperty("sync.personDevice.switch", "off");
        if ("off".equalsIgnoreCase(this.syncPersonDeviceSwitch)) {
            logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u6743\u9650\u5173\u7cfb\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879sync.personDevice.switch=on");
            return;
        }
        if (null == executorService) {
            executorService = SyncHandlerThreadFactory.getScheduledExecutorService(this.getPoolName());
        }
        String property = this.environment.getProperty("sync.personDevice.interval", "300");
        this.syncPersonDeviceInterval = Long.parseLong(property);
        executorService.scheduleWithFixedDelay(() -> {
            try {
                logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u6743\u9650\u5173\u7cfb\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879sync.personDevice.interval[{}]\u79d2", (Object)this.syncPersonDeviceInterval);
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_PERSON_DEVICE.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncSelfPersonDevice(uasUrl);
                    List<SyncPerson> listSyncApp = this.basicSyncPersonService.querySyncPersonList("");
                    this.syncPersonDevice(listSyncApp);
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, SyncHandlerThreadFactory.getSyncInitialDelay(), this.syncPersonDeviceInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncPersonDevice(List<SyncPerson> listSyncPerson) {
        boolean existRedis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        String lockKey = RedisKeyConst.getLockSyncPersonDeviceKey();
        long timeout = 600L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            PersonDeviceSyncHandler personDeviceSyncHandler = this;
            synchronized (personDeviceSyncHandler) {
                if (this.syncPersonAppRunning) {
                    logger.error("\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncPersonAppRunning = true;
            }
        }
        int syncAppTotal = 0;
        try {
            if (CollectionUtils.isEmpty(listSyncPerson)) {
                logger.warn("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u4eba\u5458\u4fe1\u606f\u4e3a\u7a7a,\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u4eba\u5458:\u3010{}\u3011", (Object)JSON.toJSONString(listSyncPerson));
            }
            ArrayList<Future> listFuture = new ArrayList<Future>();
            for (SyncPerson syncPerson : listSyncPerson) {
                Future future = ThreadManager.getInstance().submit(new PersonDeviceTask(this.environment, this.basicInfoSyncService, this.basicSyncPersonService, this.personDeviceSyncDao, syncPerson, existRedis, lockKey, timeout));
                listFuture.add(future);
            }
            for (Future future : listFuture) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncPersonAppRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb<<<");
        }
        return syncAppTotal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncSelfPersonDevice(String uasUrl) {
        boolean existRedis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        String lockKey = RedisKeyConst.getLockSyncPersonDeviceKey();
        long timeout = 600L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            PersonDeviceSyncHandler personDeviceSyncHandler = this;
            synchronized (personDeviceSyncHandler) {
                if (this.syncPersonAppRunning) {
                    logger.error("\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncPersonAppRunning = true;
            }
        }
        int syncAppTotal = 0;
        try {
            new SelfPersonDeviceTask(this.environment, this.basicInfoSyncService, this.basicSyncPersonService, this.personDeviceSyncDao, uasUrl).run();
            if (existRedis) {
                BisRedisUtil.renewalLock(lockKey, timeout);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncPersonAppRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb<<<");
        }
        return syncAppTotal;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_PERSON_DEVICE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }

    public static class PersonDeviceTask
    implements Callable<Integer> {
        private Environment environment;
        private BasicInfoSyncService basicInfoSyncService;
        private BasicSyncPersonService basicSyncPersonService;
        private PersonDeviceSyncDao personDeviceSyncDao;
        private SyncPerson syncPerson;
        private boolean existRedis;
        private String lockKey;
        private long timeout;

        public PersonDeviceTask(Environment environment, BasicInfoSyncService basicInfoSyncService, BasicSyncPersonService basicSyncPersonService, PersonDeviceSyncDao personDeviceSyncDao, SyncPerson syncPerson, boolean existRedis, String lockKey, long timeout) {
            this.environment = environment;
            this.basicInfoSyncService = basicInfoSyncService;
            this.basicSyncPersonService = basicSyncPersonService;
            this.personDeviceSyncDao = personDeviceSyncDao;
            this.syncPerson = syncPerson;
            this.existRedis = existRedis;
            this.lockKey = lockKey;
            this.timeout = timeout;
        }

        @Override
        public Integer call() {
            String personId = this.syncPerson.getId();
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011>>>", (Object)personId);
            }
            Integer addCount = 0;
            Integer delCount = 0;
            try {
                List<SyncPersonDevice> listPullSyncPersonDevice = this.pullPersonDeviceList(personId);
                if (null == listPullSyncPersonDevice || listPullSyncPersonDevice.isEmpty()) {
                    logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011\u5220\u9664\u5168\u90e8", (Object)personId);
                    List<SyncPersonDevice> listDb = this.personDeviceSyncDao.getPersonDeviceByPersonId(personId, SyncPersonDevice.status_grant_1);
                    if (!CollectionUtils.isEmpty(listDb)) {
                        delCount = listDb.size();
                        for (SyncPersonDevice syncPersonDevice : listDb) {
                            if (SyncPersonDevice.status_grant_1.intValue() != syncPersonDevice.getStatus()) continue;
                            syncPersonDevice.setCreateTime(System.currentTimeMillis());
                            syncPersonDevice.setStatus(SyncPersonDevice.status_revoke_2);
                            this.personDeviceSyncDao.updateSyncPersonDeviceStatus(syncPersonDevice);
                        }
                    }
                } else {
                    List<SyncPersonDevice> listDb = this.personDeviceSyncDao.getPersonDeviceByPersonId(personId, SyncPersonDevice.status_grant_1);
                    if (CollectionUtils.isEmpty(listDb)) {
                        addCount = listPullSyncPersonDevice.size();
                        for (SyncPersonDevice syncPersonDevice : listPullSyncPersonDevice) {
                            SyncPersonDevice syncPersonDevice2 = this.personDeviceSyncDao.getPersonDevice(personId, syncPersonDevice.getDeviceId());
                            if (null == syncPersonDevice2) {
                                syncPersonDevice.setCreateTime(System.currentTimeMillis());
                                this.personDeviceSyncDao.saveSyncPersonDevice(syncPersonDevice);
                                continue;
                            }
                            if (SyncPersonDevice.status_grant_1.intValue() == syncPersonDevice2.getStatus()) continue;
                            syncPersonDevice2.setCreateTime(System.currentTimeMillis());
                            syncPersonDevice2.setStatus(SyncPersonDevice.status_grant_1);
                            this.personDeviceSyncDao.updateSyncPersonDeviceStatus(syncPersonDevice2);
                        }
                    } else {
                        HashMap<String, SyncPersonDevice> mapPullDeviceId = new HashMap<String, SyncPersonDevice>();
                        for (SyncPersonDevice syncPersonDevice : listPullSyncPersonDevice) {
                            mapPullDeviceId.put(syncPersonDevice.getDeviceId(), syncPersonDevice);
                        }
                        HashMap<String, SyncPersonDevice> mapDbDeviceId = new HashMap<String, SyncPersonDevice>();
                        for (SyncPersonDevice syncPersonDevice : listDb) {
                            mapDbDeviceId.put(syncPersonDevice.getDeviceId(), syncPersonDevice);
                        }
                        MapDifference mapDifference = Maps.difference(mapPullDeviceId, mapDbDeviceId);
                        Map mapAdd = mapDifference.entriesOnlyOnLeft();
                        Map mapDelete = mapDifference.entriesOnlyOnRight();
                        if (!CollectionUtils.isEmpty((Map)mapAdd)) {
                            addCount = mapAdd.size();
                            for (SyncPersonDevice syncPersonDevice : mapAdd.values()) {
                                SyncPersonDevice syncPersonDeviceTmp = this.personDeviceSyncDao.getPersonDevice(personId, syncPersonDevice.getDeviceId());
                                if (null == syncPersonDeviceTmp) {
                                    syncPersonDevice.setCreateTime(System.currentTimeMillis());
                                    syncPersonDevice.setStatus(SyncPersonDevice.status_grant_1);
                                    this.personDeviceSyncDao.saveSyncPersonDevice(syncPersonDevice);
                                    continue;
                                }
                                if (SyncPersonDevice.status_grant_1.intValue() == syncPersonDeviceTmp.getStatus()) continue;
                                syncPersonDeviceTmp.setCreateTime(System.currentTimeMillis());
                                syncPersonDeviceTmp.setStatus(SyncPersonDevice.status_grant_1);
                                this.personDeviceSyncDao.updateSyncPersonDeviceStatus(syncPersonDeviceTmp);
                            }
                        }
                        if (!CollectionUtils.isEmpty((Map)mapDelete)) {
                            for (SyncPersonDevice syncPersonDevice : mapDelete.values()) {
                                if (SyncPersonDevice.status_grant_1.intValue() != syncPersonDevice.getStatus()) continue;
                                syncPersonDevice.setCreateTime(System.currentTimeMillis());
                                syncPersonDevice.setStatus(SyncPersonDevice.status_revoke_2);
                                this.personDeviceSyncDao.updateSyncPersonDeviceStatus(syncPersonDevice);
                            }
                            delCount = mapDelete.size();
                        }
                    }
                    logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011, personCode:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761,\u5220\u9664:\u3010{}\u3011\u6761", new Object[]{personId, this.syncPerson.getCode(), addCount, delCount});
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011\u5f02\u5e38:", (Object)personId, (Object)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011<<<", (Object)personId);
            }
            if (this.existRedis) {
                BisRedisUtil.renewalLock(this.lockKey, this.timeout);
            }
            return 1;
        }

        private List<SyncPersonDevice> pullPersonDeviceList(String personId) {
            HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
            mapReqParam.put("pageNo", 1);
            mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
            mapReqParam.put("personId", personId);
            long appResourceTotal = 0L;
            String localRegionalismCode = Consts.local_regionalismCode;
            String localNetworkCode = Consts.local_networkAreaCode;
            JSONArray listDevice = new JSONArray();
            int pageNo = 1;
            while (true) {
                mapReqParam.put("pageNo", pageNo);
                JSONArray deviceList = this.queryOffsitePersonDeviceList(localRegionalismCode, localNetworkCode, mapReqParam);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011, personRegionalismCode:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{personId, localRegionalismCode, pageNo, null != deviceList ? deviceList.toJSONString() : null});
                }
                if (!CollectionUtils.isEmpty((Collection)deviceList)) {
                    listDevice.addAll((Collection)deviceList);
                    appResourceTotal += (long)deviceList.size();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,,personId:\u3010{}\u3011, personRegionalismCode:\u3010{}\u3011, pageNo:\u3010{}\u3011, rows:\u3010{}\u3011, total:\u3010{}\u3011<<<", new Object[]{personId, localRegionalismCode, pageNo, deviceList.toJSONString(), appResourceTotal});
                }
                if (CollectionUtils.isEmpty((Collection)deviceList) || deviceList.size() < Consts.SYNC_DEFAULT_PAGE_SIZE) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,appId:\u3010{}\u3011, personRegionalismCode:\u3010{}\u3011\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f", (Object)personId, (Object)localRegionalismCode);
                    break;
                }
                ++pageNo;
            }
            return this.buildSyncPersonDevice(listDevice, personId, localRegionalismCode);
        }

        private List<SyncPersonDevice> buildSyncPersonDevice(JSONArray personList, String personId, String localRegionalismCode) {
            ArrayList<SyncPersonDevice> listSyncPersonApp = new ArrayList<SyncPersonDevice>();
            if (null == personList) {
                return listSyncPersonApp;
            }
            SyncPersonDevice syncPersonApp = null;
            for (int i = 0; i < personList.size(); ++i) {
                String deviceId = personList.getString(i);
                syncPersonApp = new SyncPersonDevice();
                syncPersonApp.setPersonDeviceId(IdGeneratorUtil.nextIdNum());
                syncPersonApp.setDeviceId(deviceId);
                syncPersonApp.setPersonId(personId);
                syncPersonApp.setPersonRegionalismCode(localRegionalismCode);
                syncPersonApp.setCreateTime(System.currentTimeMillis());
                listSyncPersonApp.add(syncPersonApp);
            }
            return listSyncPersonApp;
        }

        private JSONArray queryOffsitePersonDeviceList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
            JSONArray resultList;
            String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_UPM_SVC_22.getCode(), localNetworkCode, IdGeneratorUtil.nextIdStr(), CredentialUtil.getUserCredential(), CredentialUtil.getAppCredential(), CredentialUtil.getDeviceCredential(), mapReqParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb<<<\u3010{}\u3011", (Object)json);
            }
            if (StringUtils.isEmpty((Object)json)) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
                return new JSONArray();
            }
            try {
                JSONObject result = JSON.parseObject((String)json);
                resultList = result.getJSONArray("deviceList");
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
                throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
            }
            if (null == resultList) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
                return new JSONArray();
            }
            return resultList;
        }
    }

    public static class SelfPersonDeviceTask {
        private Environment environment;
        private BasicInfoSyncService basicInfoSyncService;
        private BasicSyncPersonService basicSyncPersonService;
        private PersonDeviceSyncDao personDeviceSyncDao;
        private static final String syncPersonDevicePath = "/v1/personDevice/getPersonDeviceList.do";
        private String uasUrl;

        public SelfPersonDeviceTask(Environment environment, BasicInfoSyncService basicInfoSyncService, BasicSyncPersonService basicSyncPersonService, PersonDeviceSyncDao personDeviceSyncDao, String uasUrl) {
            this.environment = environment;
            this.basicInfoSyncService = basicInfoSyncService;
            this.basicSyncPersonService = basicSyncPersonService;
            this.personDeviceSyncDao = personDeviceSyncDao;
            this.uasUrl = uasUrl;
        }

        public void run() {
            Long updateTime = this.personDeviceSyncDao.getMaxUpdateTime();
            try {
                this.pullPersonDeviceList(updateTime);
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,updateTime:\u3010{}\u3011\u5f02\u5e38:", (Object)updateTime, (Object)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,updateTime:\u3010{}\u3011<<<", (Object)updateTime);
            }
        }

        private void operationPersonDeviceInfo(String personId, List<SyncPersonDevice> listPullSyncPersonDevice) {
            Integer addCount = 0;
            List<SyncPersonDevice> listDb = this.personDeviceSyncDao.getPersonDeviceByPersonId(personId);
            if (CollectionUtils.isEmpty(listDb)) {
                addCount = listPullSyncPersonDevice.size();
                this.personDeviceSyncDao.saveSyncPersonDevice(listPullSyncPersonDevice);
            } else {
                String deviceId;
                HashMap<String, SyncPersonDevice> listPullDeviceId = new HashMap<String, SyncPersonDevice>();
                for (SyncPersonDevice syncPersonDevice : listPullSyncPersonDevice) {
                    listPullDeviceId.put(syncPersonDevice.getDeviceId(), syncPersonDevice);
                }
                HashMap<String, SyncPersonDevice> listDbDeviceId = new HashMap<String, SyncPersonDevice>();
                for (SyncPersonDevice syncPersonDevice : listPullSyncPersonDevice) {
                    listDbDeviceId.put(syncPersonDevice.getDeviceId(), syncPersonDevice);
                }
                ArrayList<SyncPersonDevice> arrayList = new ArrayList<SyncPersonDevice>();
                ArrayList<SyncPersonDevice> listUpdateDevice = new ArrayList<SyncPersonDevice>();
                ArrayList<SyncPersonDevice> listDeleteDevice = new ArrayList<SyncPersonDevice>();
                for (Map.Entry entry : listPullDeviceId.entrySet()) {
                    deviceId = (String)entry.getKey();
                    if (listDbDeviceId.containsKey(deviceId)) {
                        listUpdateDevice.add((SyncPersonDevice)listDbDeviceId.get(deviceId));
                        continue;
                    }
                    arrayList.add((SyncPersonDevice)entry.getValue());
                }
                for (Map.Entry entry : listDbDeviceId.entrySet()) {
                    deviceId = (String)entry.getKey();
                    if (listPullDeviceId.containsKey(deviceId)) continue;
                    listDeleteDevice.add((SyncPersonDevice)entry.getValue());
                }
                if (!CollectionUtils.isEmpty(arrayList)) {
                    addCount = arrayList.size();
                    this.personDeviceSyncDao.saveSyncPersonDevice(arrayList);
                }
                if (!CollectionUtils.isEmpty(listDeleteDevice)) {
                    this.personDeviceSyncDao.deleteSyncPersonDevice(listDeleteDevice);
                    this.personDeviceSyncDao.updateSyncPersonDeviceStatusDelete(listDeleteDevice);
                }
            }
            logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personId:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761", (Object)personId, (Object)addCount);
        }

        private void pullPersonDeviceList(Long updateTime) {
            HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
            mapReqParam.put("pageNo", 1);
            mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
            mapReqParam.put("updateTime", updateTime);
            long appResourceTotal = 0L;
            String localRegionalismCode = Consts.local_regionalismCode;
            int pageNo = 1;
            while (true) {
                mapReqParam.put("pageNo", pageNo);
                JSONArray deviceList = this.queryOffsitePersonDeviceList(localRegionalismCode, this.uasUrl, mapReqParam);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,updateTime:\u3010{}\u3011, personRegionalismCode:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{updateTime, localRegionalismCode, pageNo, null != deviceList ? deviceList.toJSONString() : null});
                }
                if (!CollectionUtils.isEmpty((Collection)deviceList)) {
                    appResourceTotal += (long)deviceList.size();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,,updateTime:\u3010{}\u3011, personRegionalismCode:\u3010{}\u3011, pageNo:\u3010{}\u3011, total:\u3010{}\u3011<<<", new Object[]{updateTime, localRegionalismCode, pageNo, appResourceTotal});
                }
                List list = deviceList.toJavaList(SyncPersonDevice.class);
                this.saveBatch(list);
                if (CollectionUtils.isEmpty((Collection)deviceList) || deviceList.size() < Consts.SYNC_DEFAULT_PAGE_SIZE) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,updateTime:\u3010{}\u3011, personRegionalismCode:\u3010{}\u3011\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f", (Object)updateTime, (Object)localRegionalismCode);
                    break;
                }
                ++pageNo;
            }
        }

        private List<SyncPersonDevice> buildSyncPersonDevice(JSONArray personList, String personId, String localRegionalismCode) {
            ArrayList<SyncPersonDevice> listSyncPersonApp = new ArrayList<SyncPersonDevice>();
            if (null == personList) {
                return listSyncPersonApp;
            }
            SyncPersonDevice syncPersonApp = null;
            for (int i = 0; i < personList.size(); ++i) {
                String deviceId = personList.getString(i);
                syncPersonApp = new SyncPersonDevice();
                syncPersonApp.setPersonDeviceId(IdGeneratorUtil.nextIdNum());
                syncPersonApp.setDeviceId(deviceId);
                syncPersonApp.setPersonId(personId);
                syncPersonApp.setPersonRegionalismCode(localRegionalismCode);
                syncPersonApp.setCreateTime(System.currentTimeMillis());
                listSyncPersonApp.add(syncPersonApp);
            }
            return listSyncPersonApp;
        }

        private JSONArray queryOffsitePersonDeviceList(String regionalismCode, String uasUrl, Map<String, Object> mapReqParam) {
            JSONArray resultList;
            String interfaceUrl = uasUrl + syncPersonDevicePath;
            String json = this.basicInfoSyncService.executeCallCustom(interfaceUrl, null, mapReqParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb<<<\u3010{}\u3011", (Object)json);
            }
            if (StringUtils.isEmpty((Object)json)) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
                return new JSONArray();
            }
            try {
                JSONObject result = JSON.parseObject((String)json);
                resultList = result.getJSONArray("deviceList");
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
                throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u4eba\u5458\u8bbe\u5907\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
            }
            if (null == resultList) {
                logger.debug("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,personRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
                return new JSONArray();
            }
            return resultList;
        }

        @Transactional(rollbackFor={Exception.class})
        public void saveBatch(List<SyncPersonDevice> list) {
            ArrayList<SyncPersonDevice> updateList = new ArrayList<SyncPersonDevice>();
            ArrayList<SyncPersonDevice> insertList = new ArrayList<SyncPersonDevice>();
            List<String> updateDeviceIdAndPersonIds = this.personDeviceSyncDao.getExistDeviceIdAndPersonIds(list);
            list.forEach(syncPersonDevice -> {
                syncPersonDevice.setPersonRegionalismCode(Consts.local_regionalismCode);
                String key = syncPersonDevice.getDeviceId() + syncPersonDevice.getPersonId();
                if (!CollectionUtils.isEmpty((Collection)updateDeviceIdAndPersonIds) && updateDeviceIdAndPersonIds.contains(key)) {
                    updateList.add((SyncPersonDevice)syncPersonDevice);
                } else {
                    syncPersonDevice.setPersonDeviceId(IdGeneratorUtil.nextIdNum());
                    insertList.add((SyncPersonDevice)syncPersonDevice);
                }
            });
            this.personDeviceSyncDao.updateBatch(updateList);
            this.personDeviceSyncDao.saveSyncPersonDevice(insertList);
            logger.info("\u540c\u6b65\u4eba\u5458\u8bbe\u5907\u5173\u7cfb,<<<\u65b0\u589e\u3010{}\u3011\u6761,\u66f4\u65b0:\u3010{}\u3011\u6761", (Object)insertList.size(), (Object)updateList.size());
        }
    }
}

