/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.util;

import com.alibaba.fastjson.JSON;
import com.xdja.common.AbstractBaseLocalCache;
import com.xdja.sync.bean.SyncPerson;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.service.BasicSyncPersonService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncPersonLocalCacheUtil
extends AbstractBaseLocalCache<String, SyncPerson> {
    private static final Logger logger = LoggerFactory.getLogger(SyncPersonLocalCacheUtil.class);
    private BasicSyncPersonService basicSyncPersonService = (BasicSyncPersonService)Consts.applicationContext.getBean(BasicSyncPersonService.class);
    private static final int CACHE_REFRESH_TIME = 60;

    private SyncPersonLocalCacheUtil(long duration, TimeUnit timeUtil) {
        super(duration, timeUtil);
    }

    public static SyncPersonLocalCacheUtil getInstance() {
        return StringLocalCacheUtilHolder.instance;
    }

    @Override
    protected SyncPerson loadData(String personId) {
        SyncPerson syncPerson;
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u4eba\u5458\u4fe1\u606fpersonId:\u3010{}\u3011", (Object)personId);
        }
        if (null == (syncPerson = this.basicSyncPersonService.querySyncPersonById(personId))) {
            syncPerson = this.basicSyncPersonService.querySyncPersonByCode(personId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u4eba\u5458\u4fe1\u606fpersonId:\u3010{}\u3011SyncPerson:\u3010{}\u3011", (Object)personId, (Object)JSON.toJSONString((Object)syncPerson));
        }
        return syncPerson;
    }

    private static final class StringLocalCacheUtilHolder {
        private static final SyncPersonLocalCacheUtil instance = new SyncPersonLocalCacheUtil(60L, TimeUnit.MINUTES);

        private StringLocalCacheUtilHolder() {
        }
    }
}

