create table T_SYS_LOG
(
    `id`                varchar(32) NOT NULL COMMENT '主键',
    `client_type`       int(1) NOT NULL DEFAULT '1' COMMENT '客户端类型,1：系统操作日志，2：Android客户端日志，3:服务日志',
    `log_type`          int(4) NOT NULL DEFAULT '-1' COMMENT '日志类型',
    `operate_type`      int(1) NOT NULL DEFAULT '4' COMMENT '操作类型（1:增,2:删,3:改,4:查）',
    `log_content`       LONGTEXT DEFAULT NULL COMMENT '日志内容',
    `user_id`           varchar(32) DEFAULT NULL COMMENT '操作用户id',
    `user_code`         varchar(32) DEFAULT NULL COMMENT '操作用户账号',
    `user_name`         varchar(255) DEFAULT NULL COMMENT '操作用户名称',
    `ip`                varchar(255) DEFAULT NULL COMMENT 'IP',
    `request_method`    int(1) NOT NULL DEFAULT '4' COMMENT '请求方法，(1:POST,2:DELETE,3:PUT,4:GET)',
    `request_url`       varchar(500) DEFAULT NULL COMMENT '请求路径',
    `request_type`      int(1) DEFAULT NULL COMMENT '请求类型,1:form,2:json',
    `request_header`    LONGTEXT DEFAULT NULL COMMENT '请求头',
    `request_body`      LONGTEXT DEFAULT NULL COMMENT '请求体',
    `response_header`   LONGTEXT DEFAULT NULL COMMENT '响应头',
    `response_body`     LONGTEXT DEFAULT NULL COMMENT '响应体',
    `cost_time`         bigint(20) DEFAULT NULL COMMENT '耗时',
    `status`            int(6) NOT NULL DEFAULT '0' COMMENT '状态，0:成功,其他失败',
    `error_msg`         LONGTEXT DEFAULT NULL COMMENT '错误内容',
    `create_by`         varchar(32) DEFAULT NULL COMMENT '创建人',
    `create_time`       bigint(20) DEFAULT NULL COMMENT '创建时间',
    `update_by`         varchar(32) DEFAULT NULL COMMENT '更新人',
    `update_time`       bigint(20)  DEFAULT NULL COMMENT '更新时间',
    `verify`       varchar(255)  DEFAULT NULL COMMENT '完整信息校验',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='日志信息表'
