/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.xdja.common.BisRedisUtil;
import com.xdja.common.RedisKeyConst;
import com.xdja.smcs.factory.BasicPullSmcsFactory;
import com.xdja.smcs.util.SmcsPlatformUtil;
import com.xdja.sync.bean.SyncApp;
import com.xdja.sync.bean.SyncAppResource;
import com.xdja.sync.bean.SyncPersonApp;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.AppResourceSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncAppService;
import com.xdja.sync.service.BasicSyncResourceService;
import com.xdja.sync.util.CredentialUtil;
import com.xdja.sync.util.IdGeneratorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AppResourceSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(AppResourceSyncHandler.class);
    @Autowired
    private BasicSyncAppService basicSyncAppService;
    @Autowired
    private BasicSyncResourceService basicSyncResourceService;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private AppResourceSyncDao appResourceSyncDao;
    @Autowired
    private BasicPullSmcsFactory basicPullSmcsFactory;
    @Autowired
    private Environment environment;
    @Autowired
    private SmcsPlatformUtil smcsPlatformUtil;
    private Long syncAppResourceInterval;
    private String syncAppResourceSwitch;
    private String syncAppResourceAppRegionalismCode_key = "sync.appResource.app.regionalismCode";
    private volatile boolean syncAppResourceRunning = false;
    private int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;

    @Override
    String getPoolName() {
        return "appResource";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        String syncAppResourceSwitch = this.environment.getProperty("sync.appResource.switch", "on");
        if ("off".equalsIgnoreCase(syncAppResourceSwitch)) {
            logger.info("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u6743\u9650\u5173\u7cfb\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879sync.appResource.switch=on");
            return;
        }
        String property = this.environment.getProperty("sync.appResource.interval", "300");
        try {
            this.syncAppResourceInterval = Long.parseLong(property);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == executorService) {
            executorService = SyncHandlerThreadFactory.getScheduledExecutorService(this.getPoolName());
        }
        executorService.scheduleWithFixedDelay(() -> {
            try {
                logger.info("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u6743\u9650\u5173\u7cfb\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879sync.appResource.interval[{}]\u79d2", (Object)this.syncAppResourceInterval);
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_APP_RESOURCE.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncAppResource();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, SyncHandlerThreadFactory.getSyncInitialDelay(), this.syncAppResourceInterval, TimeUnit.SECONDS);
    }

    @Transactional(rollbackFor={Exception.class})
    public int syncAppResource() {
        List<SyncApp> listSyncApp = this.basicSyncAppService.querySyncAppList();
        return this.syncAppResource(listSyncApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncAppResource(List<SyncApp> listSyncApp) {
        boolean existRedis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        String lockKey = RedisKeyConst.getLockSyncAppResourceKey();
        long timeout = 600L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            AppResourceSyncHandler appResourceSyncHandler = this;
            synchronized (appResourceSyncHandler) {
                if (this.syncAppResourceRunning) {
                    logger.error("\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncAppResourceRunning = true;
            }
        }
        int syncAppTotal = 0;
        try {
            String syncAppResourceAppRegionalismCode;
            if (CollectionUtils.isEmpty(listSyncApp)) {
                logger.warn("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u5e94\u7528\u4fe1\u606f\u4e3a\u7a7a,\u540c\u6b65\u7ed3\u675f");
                int n = syncAppTotal;
                return n;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u5e94\u7528:\u3010{}\u3011", (Object)JSON.toJSONString(listSyncApp));
            }
            if (!StringUtils.isEmpty((Object)(syncAppResourceAppRegionalismCode = this.environment.getProperty(this.syncAppResourceAppRegionalismCode_key, "")))) {
                String[] ary = syncAppResourceAppRegionalismCode.split(",");
                List<String> listAppRegionalsimCode = Arrays.asList(ary);
                ArrayList<SyncApp> listSyncAppTmp = new ArrayList<SyncApp>();
                for (SyncApp syncApp : listSyncApp) {
                    String appRegionalismCode = syncApp.getAppRegionalismCode();
                    if (!listAppRegionalsimCode.contains(appRegionalismCode)) continue;
                    listSyncAppTmp.add(syncApp);
                }
                listSyncApp = listSyncAppTmp;
            }
            for (SyncApp syncApp : listSyncApp) {
                String appId = syncApp.getAppId();
                String appRegionalismCode = syncApp.getRegionalismCode();
                String appNetworkAreaCode = syncApp.getNetworkAreaCode();
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011,appRegionalismCode:\u3010{}\u3011>>>", (Object)appId, (Object)appRegionalismCode);
                }
                int addCount = 0;
                int deleteCount = 0;
                try {
                    List<SyncAppResource> listPullSyncAppResource = this.pullResourceList(appId, appRegionalismCode, appNetworkAreaCode);
                    if (null == listPullSyncAppResource || listPullSyncAppResource.isEmpty()) {
                        logger.info("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5220\u9664\u5168\u90e8", (Object)appId, (Object)appRegionalismCode);
                        List<SyncAppResource> listDbSyncAppResource = this.appResourceSyncDao.queryAppResourceByAppId(appId, appRegionalismCode, SyncAppResource.status_grant_1);
                        if (null != listDbSyncAppResource && listDbSyncAppResource.size() > 0) {
                            for (SyncAppResource syncAppResource : listDbSyncAppResource) {
                                syncAppResource.setStatus(SyncAppResource.status_delete_3);
                                syncAppResource.setLastUpdateTime(System.currentTimeMillis());
                                this.appResourceSyncDao.updateAppResourceStatus(syncAppResource);
                            }
                        }
                    } else {
                        HashMap<Object, SyncAppResource> mapPullSyncAppResource = new HashMap<Object, SyncAppResource>();
                        for (SyncAppResource syncAppResource : listPullSyncAppResource) {
                            syncAppResource.setAppId(appId);
                            syncAppResource.setAppRegionalismCode(appRegionalismCode);
                            syncAppResource.setAppNetworkCode(appNetworkAreaCode);
                            String key = syncAppResource.getAppId() + syncAppResource.getAppRegionalismCode() + syncAppResource.getResourceId() + syncAppResource.getResourceRegionalismCode();
                            mapPullSyncAppResource.put(key, syncAppResource);
                        }
                        List<SyncAppResource> listDbSyncAppResource = this.appResourceSyncDao.queryAppResourceByAppId(appId, appRegionalismCode, SyncAppResource.status_grant_1);
                        HashMap<String, SyncAppResource> mapDbSyncAppResource = new HashMap<String, SyncAppResource>();
                        if (null != listDbSyncAppResource && !listDbSyncAppResource.isEmpty()) {
                            for (SyncAppResource syncAppResource : listDbSyncAppResource) {
                                String key = syncAppResource.getAppId() + syncAppResource.getAppRegionalismCode() + syncAppResource.getResourceId() + syncAppResource.getResourceRegionalismCode();
                                mapDbSyncAppResource.put(key, syncAppResource);
                            }
                        }
                        MapDifference difference = Maps.difference(mapPullSyncAppResource, mapDbSyncAppResource);
                        Map mapAdd = difference.entriesOnlyOnLeft();
                        Map mapDelete = difference.entriesOnlyOnRight();
                        if (!CollectionUtils.isEmpty((Map)mapAdd)) {
                            SyncAppResource syncAppResourceTmp = null;
                            for (SyncAppResource syncAppResource : mapAdd.values()) {
                                syncAppResourceTmp = this.appResourceSyncDao.queryAppResource(appId, appRegionalismCode, syncAppResource.getResourceId(), syncAppResource.getResourceRegionalismCode());
                                if (null == syncAppResourceTmp) {
                                    syncAppResource.setLastUpdateTime(System.currentTimeMillis());
                                    this.appResourceSyncDao.saveAppResource(syncAppResource);
                                    continue;
                                }
                                syncAppResourceTmp.setLastUpdateTime(System.currentTimeMillis());
                                syncAppResourceTmp.setStatus(SyncAppResource.status_grant_1);
                                this.appResourceSyncDao.updateAppResourceStatusById(syncAppResourceTmp);
                            }
                            addCount = mapAdd.size();
                        }
                        if (!CollectionUtils.isEmpty((Map)mapDelete)) {
                            for (SyncAppResource syncAppResource : mapDelete.values()) {
                                if (syncAppResource.getStatus().intValue() != SyncPersonApp.status_grant_1.intValue()) continue;
                                syncAppResource.setLastUpdateTime(System.currentTimeMillis());
                                syncAppResource.setStatus(SyncPersonApp.status_delete_3);
                                this.appResourceSyncDao.updateAppResourceStatus(syncAppResource);
                                ++deleteCount;
                            }
                        }
                        logger.info("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<\u65b0\u589e\u3010{}\u3011\u6761,\u5220\u9664:\u3010{}\u3011\u6761", new Object[]{appId, appRegionalismCode, addCount, deleteCount});
                    }
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u5f02\u5e38:", new Object[]{appId, appRegionalismCode, e});
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011<<<", (Object)appId, (Object)appRegionalismCode);
                }
                if (!existRedis) continue;
                BisRedisUtil.renewalLock(lockKey, timeout);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncAppResourceRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb<<<");
        }
        return syncAppTotal;
    }

    private List<SyncAppResource> computeDeleteSyncAppResource(Map<String, SyncAppResource> mapPullSyncAppResource, Map<String, SyncAppResource> mapDbSyncAppResource) {
        ArrayList<SyncAppResource> listDeleteSyncAppResource = new ArrayList<SyncAppResource>();
        for (Map.Entry<String, SyncAppResource> entry : mapDbSyncAppResource.entrySet()) {
            String key = entry.getKey();
            if (mapPullSyncAppResource.containsKey(key) || SyncAppResource.status_delete_3.intValue() == entry.getValue().getStatus().intValue()) continue;
            long currentTimeMillis = System.currentTimeMillis();
            SyncAppResource syncAppResource = entry.getValue();
            syncAppResource.setLastUpdateTime(currentTimeMillis);
            syncAppResource.setStatus(SyncAppResource.status_delete_3);
            listDeleteSyncAppResource.add(syncAppResource);
        }
        return listDeleteSyncAppResource;
    }

    private List<SyncAppResource> computeUpdateSyncAppResource(Map<String, SyncAppResource> mapPullSyncAppResource, Map<String, SyncAppResource> mapDbSyncAppResource) {
        ArrayList<SyncAppResource> listUpdateSyncAppResource = new ArrayList<SyncAppResource>();
        for (Map.Entry<String, SyncAppResource> entry : mapPullSyncAppResource.entrySet()) {
            String key = entry.getKey();
            if (!mapDbSyncAppResource.containsKey(key)) continue;
            SyncAppResource syncAppResource = mapDbSyncAppResource.get(key);
            if (SyncAppResource.status_grant_1.intValue() == syncAppResource.getStatus().intValue()) continue;
            syncAppResource.setStatus(SyncAppResource.status_grant_1);
            long currentTimeMillis = System.currentTimeMillis();
            syncAppResource.setCreateTime(currentTimeMillis);
            syncAppResource.setLastUpdateTime(currentTimeMillis);
            listUpdateSyncAppResource.add(syncAppResource);
        }
        return listUpdateSyncAppResource;
    }

    private List<SyncAppResource> computeAddSyncAppResource(Map<String, SyncAppResource> mapPullSyncAppResource, Map<String, SyncAppResource> mapDbSyncAppResource) {
        ArrayList<SyncAppResource> listAddSyncAppResource = new ArrayList<SyncAppResource>();
        for (Map.Entry<String, SyncAppResource> entry : mapPullSyncAppResource.entrySet()) {
            String key = entry.getKey();
            if (!mapDbSyncAppResource.containsKey(key)) {
                long currentTimeMillis = System.currentTimeMillis();
                SyncAppResource syncAppResource = entry.getValue();
                syncAppResource.setAppResourceId(IdGeneratorUtil.nextIdStr());
                syncAppResource.setStatus(SyncAppResource.status_grant_1);
                syncAppResource.setCreateTime(currentTimeMillis);
                syncAppResource.setLastUpdateTime(currentTimeMillis);
                listAddSyncAppResource.add(syncAppResource);
                continue;
            }
            SyncAppResource syncAppResource = mapDbSyncAppResource.get(key);
            Integer status = syncAppResource.getStatus();
            if (SyncAppResource.status_grant_1.intValue() == status.intValue()) continue;
            syncAppResource.setStatus(SyncAppResource.status_grant_1);
            long currentTimeMillis = System.currentTimeMillis();
            syncAppResource.setCreateTime(currentTimeMillis);
            syncAppResource.setLastUpdateTime(currentTimeMillis);
            listAddSyncAppResource.add(syncAppResource);
        }
        return listAddSyncAppResource;
    }

    public List<SyncAppResource> pullResourceList(String appId, String appRegionalismCode, String appNetworkAreaCode) {
        HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
        mapReqParam.put("pageNo", 1);
        mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
        mapReqParam.put("appId", appId);
        mapReqParam.put("appRegionalismCode", appRegionalismCode);
        String localNetworkCode = Consts.local_networkAreaCode;
        long appResourceTotal = 0L;
        JSONArray resourceAllList = new JSONArray();
        int pageNo = 1;
        while (true) {
            mapReqParam.put("pageNo", pageNo);
            JSONArray resourceList = this.queryOffsiteAppResourceList(appRegionalismCode, localNetworkCode, mapReqParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{appId, appRegionalismCode, pageNo, null != resourceList ? resourceList.toJSONString() : null});
            }
            if (!CollectionUtils.isEmpty((Collection)resourceList)) {
                resourceAllList.addAll((Collection)resourceList);
                appResourceTotal += (long)resourceList.size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011, pageNo:\u3010{}\u3011, rows:\u3010{}\u3011, total:\u3010{}\u3011<<<", new Object[]{appId, appRegionalismCode, pageNo, resourceList.toJSONString(), appResourceTotal});
            }
            if (CollectionUtils.isEmpty((Collection)resourceList) || resourceList.size() < this.pageSize) {
                if (!logger.isDebugEnabled()) break;
                logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appId:\u3010{}\u3011, appRegionalismCode:\u3010{}\u3011\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f", (Object)appId, (Object)appRegionalismCode);
                break;
            }
            ++pageNo;
        }
        return this.buildSyncAppResource(resourceAllList, appId, appRegionalismCode, appNetworkAreaCode);
    }

    private List<SyncAppResource> buildSyncAppResource(JSONArray resourceList, String appId, String appRegionalismCode, String appNetworkAreaCode) {
        ArrayList<SyncAppResource> listSyncAppResource = new ArrayList<SyncAppResource>();
        SyncAppResource syncAppResource = null;
        for (int i = 0; i < resourceList.size(); ++i) {
            JSONObject jsonObject = resourceList.getJSONObject(i);
            String resourceId = jsonObject.getString("resourceId");
            String resourceRegionalismCode = jsonObject.getString("resourceRegionalismCode");
            syncAppResource = new SyncAppResource();
            syncAppResource.setAppResourceId(IdGeneratorUtil.nextIdStr());
            syncAppResource.setAppId(appId);
            syncAppResource.setAppRegionalismCode(appRegionalismCode);
            syncAppResource.setAppNetworkCode(appNetworkAreaCode);
            syncAppResource.setResourceId(resourceId);
            syncAppResource.setResourceRegionalismCode(resourceRegionalismCode);
            listSyncAppResource.add(syncAppResource);
        }
        return listSyncAppResource;
    }

    private JSONArray queryOffsiteAppResourceList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_UPM_SVC_06.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011,appResource:\u3010{}\u3011", (Object)regionalismCode, (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("resourceList");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u5e94\u7528\u8d44\u6e90\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
        }
        if (null == resultList) {
            logger.debug("\u540c\u6b65\u5e94\u7528\u8d44\u6e90\u5173\u7cfb,appRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        return resultList;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_APP_RESOURCE != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

