/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.sync.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.common.BisRedisUtil;
import com.xdja.common.RedisKeyConst;
import com.xdja.sync.bean.SyncDeviceNetworkGroup;
import com.xdja.sync.bean.common.Consts;
import com.xdja.sync.dao.DeviceNetworkGroupSyncDao;
import com.xdja.sync.enums.InterfaceCodeEnum;
import com.xdja.sync.enums.TableEnum;
import com.xdja.sync.exception.SyncClientException;
import com.xdja.sync.exception.SyncClientExceptionCode;
import com.xdja.sync.handler.AbstractSyncHandler;
import com.xdja.sync.handler.SyncHandlerThreadFactory;
import com.xdja.sync.service.BasicInfoSyncService;
import com.xdja.sync.service.BasicSyncPersonService;
import com.xdja.sync.util.CredentialUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class DeviceNetworkGroupSyncHandler
extends AbstractSyncHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeviceNetworkGroupSyncHandler.class);
    @Autowired
    private Environment environment;
    @Autowired
    private BasicInfoSyncService basicInfoSyncService;
    @Autowired
    private BasicSyncPersonService basicSyncPersonService;
    @Autowired
    private DeviceNetworkGroupSyncDao deviceNetworkGroupSyncDao;
    private Long syncDeviceNetworkInterval;
    private String syncDeviceNetworkSwitch;
    private volatile boolean syncDeviceNetworkRunning = false;
    private int pageSize = Consts.SYNC_DEFAULT_PAGE_SIZE;

    @Override
    String getPoolName() {
        return "deviceNetwork";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handler(TableEnum[] tableEnums, ScheduledExecutorService executorService) {
        this.syncDeviceNetworkSwitch = this.environment.getProperty("sync.deviceNetwork.switch", "on");
        if ("off".equalsIgnoreCase(this.syncDeviceNetworkSwitch)) {
            logger.info("\u540c\u6b65\u8bbe\u5907\u7f51\u7edc\u6743\u9650\u5173\u7cfb\u672a\u5f00\u542f\uff0c\u5982\u9700\u5f00\u542f\u8bf7\u6dfb\u52a0\u6216\u4fee\u6539\u914d\u7f6e\u9879sync.deviceNetwork.switch=on");
            return;
        }
        if (null == executorService) {
            executorService = SyncHandlerThreadFactory.getScheduledExecutorService(this.getPoolName());
        }
        String property = this.environment.getProperty("sync.deviceNetwork.interval", "300");
        this.syncDeviceNetworkInterval = Long.parseLong(property);
        executorService.scheduleWithFixedDelay(() -> {
            try {
                logger.info("\u540c\u6b65\u8bbe\u5907\u7f51\u7edc\u6743\u9650\u5173\u7cfb\uff0c\u540c\u6b65\u9891\u7387\u914d\u7f6e\u9879sync.deviceNetwork.interval[{}]\u79d2", (Object)this.syncDeviceNetworkInterval);
                for (TableEnum tableEnum : tableEnums) {
                    if (!TableEnum.TABLE_DEVICE_NETWORK.getTableName().equals(tableEnum.getTableName())) continue;
                    this.syncDeviceNetwork();
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }, SyncHandlerThreadFactory.getSyncInitialDelay(), this.syncDeviceNetworkInterval, TimeUnit.SECONDS);
    }

    @Transactional(rollbackFor={Exception.class})
    public int syncDeviceNetwork() {
        return this.syncDeviceNetwork(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public int syncDeviceNetwork(List<String> listSyncDevice) {
        boolean existRedis;
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb\u4fe1\u606f>>>>>>");
        }
        String lockKey = RedisKeyConst.getLockSyncDeviceNetworkKey();
        long timeout = 600L;
        String lockValue = BisRedisUtil.getExpireMillis(timeout);
        boolean lock = false;
        boolean bl = existRedis = null != BisRedisUtil.getStringRedisTemplate();
        if (existRedis) {
            lock = BisRedisUtil.tryLock(lockKey, lockValue);
            if (!lock) {
                logger.error("\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
            }
        } else {
            DeviceNetworkGroupSyncHandler deviceNetworkGroupSyncHandler = this;
            synchronized (deviceNetworkGroupSyncHandler) {
                if (this.syncDeviceNetworkRunning) {
                    logger.error("\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                    throw new SyncClientException(SyncClientExceptionCode.REPEAT_START.getCode(), "\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb\u4fe1\u606f\u6b63\u5728\u540c\u6b65\u4e2d,\u8bf7\u52ff\u91cd\u590d\u542f\u52a8");
                }
                this.syncDeviceNetworkRunning = true;
            }
        }
        int syncDeviceTotal = 0;
        try {
            List<SyncDeviceNetworkGroup> listPushSyncDeviceNetworkGroup;
            block26: {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,\u4eba\u5458:\u3010{}\u3011", (Object)JSON.toJSONString(listSyncDevice));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb>>>");
                }
                Long updateTime = this.deviceNetworkGroupSyncDao.getMaxUpdateTime();
                listPushSyncDeviceNetworkGroup = this.pullDeviceNetworkGroupList(null, updateTime);
                if (null != listPushSyncDeviceNetworkGroup && !listPushSyncDeviceNetworkGroup.isEmpty()) break block26;
                logger.warn("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u6743\u9650\u5173\u7cfb");
                int n = syncDeviceTotal;
                return n;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u6743\u9650\u5173\u7cfb:\u3010{}\u3011", (Object)JSON.toJSONString(listPushSyncDeviceNetworkGroup));
                }
                ArrayList<SyncDeviceNetworkGroup> listAddSyncDeviceNetworkGroup = new ArrayList<SyncDeviceNetworkGroup>();
                ArrayList<SyncDeviceNetworkGroup> listUpdateSyncDeviceNetworkGroup = new ArrayList<SyncDeviceNetworkGroup>();
                for (SyncDeviceNetworkGroup syncDeviceNetworkGroup : listPushSyncDeviceNetworkGroup) {
                    SyncDeviceNetworkGroup existDeviceNetworkGroup = this.deviceNetworkGroupSyncDao.getDeviceNetworkGroup(syncDeviceNetworkGroup.getDeviceId(), syncDeviceNetworkGroup.getNetStrategyId());
                    if (null == existDeviceNetworkGroup) {
                        listAddSyncDeviceNetworkGroup.add(syncDeviceNetworkGroup);
                        continue;
                    }
                    if (syncDeviceNetworkGroup.getStatus().intValue() == existDeviceNetworkGroup.getStatus().intValue()) continue;
                    listUpdateSyncDeviceNetworkGroup.add(syncDeviceNetworkGroup);
                }
                if (!CollectionUtils.isEmpty(listAddSyncDeviceNetworkGroup)) {
                    this.deviceNetworkGroupSyncDao.saveSyncNetworkGroup(listPushSyncDeviceNetworkGroup);
                }
                if (!CollectionUtils.isEmpty(listUpdateSyncDeviceNetworkGroup)) {
                    this.deviceNetworkGroupSyncDao.updateSyncNetworkGroup(listUpdateSyncDeviceNetworkGroup);
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb\u5f02\u5e38:", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.syncDeviceNetworkRunning = false;
            if (existRedis && lock) {
                BisRedisUtil.releaseLock(lockKey, lockValue);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb<<<");
        }
        return syncDeviceTotal;
    }

    private List<SyncDeviceNetworkGroup> pullDeviceNetworkGroupList(String deviceId, Long updateTime) {
        HashMap<String, Object> mapReqParam = new HashMap<String, Object>();
        mapReqParam.put("pageNo", 1);
        mapReqParam.put("pageSize", Consts.SYNC_DEFAULT_PAGE_SIZE);
        mapReqParam.put("deviceId", deviceId);
        mapReqParam.put("updateTime", updateTime);
        long appResourceTotal = 0L;
        String localRegionalismCode = Consts.local_regionalismCode;
        String localNetworkCode = Consts.local_networkAreaCode;
        JSONArray listDevice = new JSONArray();
        int pageNo = 1;
        while (true) {
            mapReqParam.put("pageNo", pageNo);
            JSONArray deviceList = this.queryOffsiteDeviceNetworkList(localRegionalismCode, localNetworkCode, mapReqParam);
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,deviceId:\u3010{}\u3011, localRegionalismCode:\u3010{}\u3011,\u7b2c[{}]\u9875\u6570\u636e:\u3010{}\u3011>>>", new Object[]{updateTime, localRegionalismCode, pageNo, null != deviceList ? deviceList.toJSONString() : null});
            }
            if (!CollectionUtils.isEmpty((Collection)deviceList)) {
                listDevice.addAll((Collection)deviceList);
                appResourceTotal += (long)deviceList.size();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,deviceId:\u3010{}\u3011, localRegionalismCode:\u3010{}\u3011, pageNo:\u3010{}\u3011, rows:\u3010{}\u3011, total:\u3010{}\u3011<<<", new Object[]{deviceId, localRegionalismCode, pageNo, deviceList.toJSONString(), appResourceTotal});
            }
            if (CollectionUtils.isEmpty((Collection)deviceList) || deviceList.size() < this.pageSize) {
                if (!logger.isDebugEnabled()) break;
                logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,deviceId:\u3010{}\u3011, localRegionalismCode:\u3010{}\u3011\u4e0d\u591f\u4e0b\u4e00\u6b21\u5206\u9875\uff0c\u540c\u6b65\u7ed3\u675f", (Object)deviceId, (Object)localRegionalismCode);
                break;
            }
            ++pageNo;
        }
        return this.buildSyncPersonDevice(listDevice, deviceId, localRegionalismCode);
    }

    private List<SyncDeviceNetworkGroup> buildSyncPersonDevice(JSONArray deviceNetworkList, String personId, String localRegionalismCode) {
        ArrayList<SyncDeviceNetworkGroup> listSyncDeviceNetworkGroup = new ArrayList<SyncDeviceNetworkGroup>();
        if (null == deviceNetworkList) {
            return listSyncDeviceNetworkGroup;
        }
        return JSONArray.parseArray((String)deviceNetworkList.toJSONString(), SyncDeviceNetworkGroup.class);
    }

    private JSONArray queryOffsiteDeviceNetworkList(String regionalismCode, String localNetworkCode, Map<String, Object> mapReqParam) {
        JSONArray resultList;
        String json = this.basicInfoSyncService.executeCallIF(regionalismCode, InterfaceCodeEnum.IF_UPM_SVC_100.getCode(), localNetworkCode, CredentialUtil.getAppCredential(), CredentialUtil.getUserCredential(), mapReqParam);
        if (logger.isDebugEnabled()) {
            logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb<<<\u3010{}\u3011", (Object)json);
        }
        if (StringUtils.isEmpty((Object)json)) {
            logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,localRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        try {
            JSONObject result = JSON.parseObject((String)json);
            resultList = result.getJSONArray("deviceNetworkList");
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,localRegionalismCode:\u3010{}\u3011\u8f6c\u5316\u5f02\u5e38,\u539f\u6570\u636e\u3010{}\u3011", (Object)regionalismCode, (Object)json);
            throw SyncClientException.operateErrorException("\u540c\u6b65\u884c\u653f\u533a\u5212" + regionalismCode + "\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb\u5217\u8868\u7ed3\u679c\u8f6c\u5316\u5f02\u5e38");
        }
        if (null == resultList) {
            logger.debug("\u540c\u6b65\u8bbe\u5907\u4e0e\u7f51\u7edc\u5173\u7cfb,localRegionalismCode:\u3010{}\u3011\u5217\u8868\u4e3a\u7a7a", (Object)regionalismCode);
            return new JSONArray();
        }
        return resultList;
    }

    @Override
    public TableEnum[] supportType(TableEnum[] tableEnums) {
        ArrayList<TableEnum> listTableEnum = new ArrayList<TableEnum>();
        for (TableEnum tableEnum : tableEnums) {
            if (TableEnum.TABLE_DEVICE_NETWORK != tableEnum) continue;
            listTableEnum.add(tableEnum);
        }
        return listTableEnum.toArray(new TableEnum[listTableEnum.size()]);
    }
}

